package org.gcube.application.framework.http.content.access;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Servlet implementation class ContentViewer
 */
public class ContentViewer extends HttpServlet {
	
	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(ContentViewer.class);
	
	private static final long serialVersionUID = 1L;
	
	private static final String operationID = "GetContent";
	
	//private static final int maxChar = 1024;

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public ContentViewer() {
		super();
	}

	protected void doHead(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		//-- Check if the user is authenticated
		AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall(request, operationID);
		if (!authenticationResp.isAuthenticated()) {
			response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
			return;
		}

		String username = authenticationResp.getUserId();
		if (request.getParameter("contentIdentification") == null || request.getParameter("contentIdentification").equals("")) {
			response.sendError(400, "No content object identification given");
			return;
		}

		try {
			String oid = request.getParameter("OID");
			logger.info("The CID passed is: " + oid);
			//	String username = request.getParameter("username");
			ASLSession session = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
			DigitalObject digObj = new DigitalObject(session, oid, null);
			String mime = "";
			long length = 0;
			mime = digObj.getMimeType();
			length = digObj.getLength();
			String name = digObj.getCollectionName();
			response.addHeader("content_name", name);
			response.addHeader("contentID", oid);

			logger.info("The content type is: " + mime);
			response.setContentType(mime);
			response.addHeader("Content-Length", "0");
			//response.addHeader("Content-Length","" + length); // maybe I have
			// to change the name of the header...
		} catch (Exception e) {
			//response.setContentType("unknown/unknown");
			response.sendError(500);
			return;
		}


	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
				//-- Check if the user is authenticated
				AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall(request, operationID);
				if (!authenticationResp.isAuthenticated()) {
					response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
					return;
				}

				String username = authenticationResp.getUserId();

			try {
				String save = request.getParameter("save");
				
				String uri = request.getParameter("documentURI");
				logger.info("The document URI: " + uri);
				
				if (uri == null || uri.equals("")) {
					// the document has not id - not found
					response.sendError(404);
					return;
				}
				
				OutputStream out = response.getOutputStream();
				ASLSession session = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
				DigitalObject digObj = new DigitalObject(session, uri);
				String mime = "";
				long length = 0;
				String name = "";
				String elementType = request.getParameter("elementType");
				if (elementType == null)
					elementType = new String();
				digObj.setType(elementType);
				
				mime = digObj.getMimeType();
				length = digObj.getLength();
				name = digObj.getCollectionName();
				String oid = digObj.getObjectId();
				response.addHeader("content_name", name);
				response.addHeader("Content-Name", name);
				response.addHeader("contentID", oid);
	
				if(mime == null)
				{
					response.addHeader("content-disposition", "attachment; filename=" +name);
					response.setContentType("unknown/unknown");
				}
				else if (mime.contains("text/uri-list")) {
					response.setContentType("text/html");
					out.write("<html> <head> <meta http-equiv=\"Refresh\" content=\"0;url="
									.getBytes());
				} 
				else if (mime.contains("application")) {
					// tell the browser about system going to return an application
					// file instead of normal html page
					response.setHeader("Content-Disposition",
					"attachment");
				}
				else
				{
					logger.debug("The content type is: " + mime);
					logger.debug("The content name is: " + name);
					response.setContentType(mime);
					if (length > 0)
						response.setContentLength((int) length);
					response.addHeader("content_name", name);
					response.addHeader("Content-Name", name);
					if (save != null && save.equals("true")) {
						response.addHeader("content-disposition", "attachment; filename=" + name);
					}
				}
				//byte[] buf = new byte[maxChar];
				logger.info("About to get object");
				
				//InputStream in = digObj.getObject(elementType);
				InputStream in = digObj.getObject();
				logger.info("Got the object " + in.toString());
				

				IOUtils.copy(in, out);
				if (mime != null && mime.contains("text/uri-list")) {
						out.write("\" /> </head></html>".getBytes());
				}
				//char[] newarr = new String(buf).toCharArray();
				//String content = new String(buf);
				//logger.info("Content to string: " + content);
				logger.info("Printing outToString: " + out.toString());
				out.flush();
				out.close();
			} catch (Exception e) {
				//response.sendError(500);
				//response.setContentType("unknown/unknown");
				logger.error("Exception:", e);
			}
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	}

}
