/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.content.access;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObjectType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.http.content.access.tools.ContentParsers;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContentInfo
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ContentInfo.class);
    private static final long serialVersionUID = 1L;
    private static final String operationID = "ShowContentInfos";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        String documentURI = request.getParameter("documentURI");
        logger.debug("documentURI: " + documentURI);
        ASLSession aslSession = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
        DigitalObject digObj = new DigitalObject(aslSession, documentURI);
        String mime = "";
        long length = 0L;
        String name = digObj.getCollectionName();
        String collectionType = digObj.getType().toString();
        logger.debug("digObj.getCollectionName(): " + name);
        String secondaryURLs = request.getParameter("secondaryURLs");
        if (secondaryURLs == null) {
            secondaryURLs = "";
        }
        String link = null;
        if (documentURI.contains("http://") && documentURI.contains("/tree/")) {
            logger.info("About to get tree object");
            String content = digObj.getContent();
            TreeMap links = null;
            if (collectionType.equalsIgnoreCase(DigitalObjectType.FIGIS.toString())) {
                links = ContentParsers.parseFIGIS_Payload((String)content);
            }
            if (collectionType.equalsIgnoreCase(DigitalObjectType.OAI.toString())) {
                links = ContentParsers.parseOAI_Payload((String)content);
            }
            if (links != null) {
                if (secondaryURLs.equalsIgnoreCase("true")) {
                    List alternativeURLs = (List)links.get("alternativeURLs");
                    if (alternativeURLs != null && alternativeURLs.size() > 0) {
                        link = (String)alternativeURLs.get(0);
                    }
                } else {
                    List mainURLs = (List)links.get("mainURLs");
                    if (mainURLs != null && mainURLs.size() > 0) {
                        link = (String)mainURLs.get(0);
                    }
                }
            }
        } else {
            link = documentURI;
        }
        logger.debug("LINK is: " + link);
        URLConnection objConn = new URL(link).openConnection();
        mime = objConn.getContentType();
        length = objConn.getContentLength();
        logger.debug("MIME is: " + mime);
        logger.debug("length is: " + length);
        String oid = digObj.getObjectId();
        String colId = digObj.getCollectionID();
        logger.debug("oid is: " + oid);
        logger.debug("colId is: " + colId);
        if (request.getParameter("responseType") == null || request.getParameter("responseType").equals("") || request.getParameter("responseType").equals("json")) {
            response.setContentType("application/json");
            JSONObject responseObject = new JSONObject();
            try {
                if (oid != null) {
                    responseObject.put("OID", (Object)oid);
                }
                if (colId != null) {
                    responseObject.put("CID", (Object)colId);
                }
                if (name != null) {
                    responseObject.put("Name", (Object)name);
                }
                if (mime != null) {
                    responseObject.put("MimeType", (Object)mime);
                }
                responseObject.put("Length", (Object)String.valueOf(length));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ServletOutputStream out = response.getOutputStream();
            out.write(responseObject.toString().getBytes());
            out.close();
        } else {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = dbfac.newDocumentBuilder();
            }
            catch (ParserConfigurationException exep) {
                logger.error("Exception:", (Throwable)exep);
            }
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("ContentInfos");
            doc.appendChild(root);
            Element nameEl = doc.createElement("Name");
            nameEl.setTextContent(name);
            root.appendChild(nameEl);
            Element oidEl = doc.createElement("ObjectId");
            oidEl.setTextContent(oid);
            root.appendChild(oidEl);
            Element mimeEl = doc.createElement("MimeType");
            mimeEl.setTextContent(mime);
            root.appendChild(mimeEl);
            Element lengthEl = doc.createElement("Length");
            lengthEl.setTextContent(String.valueOf(length));
            root.appendChild(lengthEl);
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            String xmlToStr = "";
            StringWriter writer = new StringWriter();
            try {
                DOMSource domSource = new DOMSource(doc);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
            }
            catch (Exception exep) {
                logger.error("Exception:", (Throwable)exep);
            }
            xmlToStr = writer.toString();
            logger.info(xmlToStr);
            out.write(xmlToStr);
            out.close();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

