/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.harvesting.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.harvesting.common.ElementGenerator;
import org.gcube.application.framework.harvesting.common.db.exceptions.DBConnectionException;
import org.gcube.application.framework.harvesting.common.db.exceptions.SourceIDNotFoundException;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSource;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Edge;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Table;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DBDataDom {
    private DBSource dbSource;
    private Connection conn;
    private static HashMap<String, String> dbNameToDriverClass = new HashMap();

    public DBDataDom(String sourceID, String filepath) {
        if (filepath == null) {
            filepath = System.getProperty("catalina.base") + "/shared/d4s/sqlDBMappings.xml";
        }
        try {
            this.dbSource = SourcePropsTools.parseSourceProps((String)filepath, (String)sourceID);
        }
        catch (SourceIDNotFoundException e) {
            e.printStackTrace();
        }
    }

    public DBSource getUserProps() {
        return this.dbSource;
    }

    public String getUserData() throws SQLException, DBConnectionException {
        Document doc = ElementGenerator.getDocument();
        String rootTable = "";
        ArrayList tables = this.dbSource.getTables();
        ArrayList edges = this.dbSource.getEdges();
        for (Table table : tables) {
            boolean root = true;
            for (Edge edge : edges) {
                if (!table.getName().equalsIgnoreCase(edge.getChild())) continue;
                root = false;
            }
            if (!root) continue;
            rootTable = table.getName();
            break;
        }
        this.conn = this.connectToDatabaseOrDieTrying();
        Element root = doc.createElement("root");
        root.appendChild(this.formSubElement(rootTable, new HashMap()));
        try {
            return ElementGenerator.domToXML((Element)root);
        }
        catch (TransformerException e) {
            return e.getMessage();
        }
    }

    public Element formSubElement(String tableName, HashMap<String, String> keysVals) throws SQLException {
        Document doc = ElementGenerator.getDocument();
        ResultSet rs = this.getFilteredTableResultSet(tableName, this.conn, keysVals);
        ResultSetMetaData fields = rs.getMetaData();
        Element elementList = doc.createElement(tableName + "_list");
        ArrayList edges = SourcePropsTools.getEdges((DBSource)this.dbSource, (String)tableName);
        while (rs.next()) {
            Element subTable = doc.createElement(tableName);
            for (int i = 1; i <= fields.getColumnCount(); ++i) {
                Element el = doc.createElement(fields.getColumnLabel(i));
                el.appendChild(doc.createTextNode(rs.getString(i)));
                subTable.appendChild(el);
            }
            for (Edge edge : edges) {
                HashMap<String, String> kv = new HashMap<String, String>();
                String[] pkeys = edge.getPKeys().split(",");
                String[] ckeys = edge.getCKeys().split(",");
                for (int i = 0; i < ckeys.length; ++i) {
                    kv.put(ckeys[i], rs.getString(pkeys[i]));
                }
                Element e = this.formSubElement(edge.getChild(), kv);
                if (!e.hasChildNodes()) continue;
                subTable.appendChild(e);
            }
            elementList.appendChild(subTable);
        }
        return elementList;
    }

    private ResultSet getDefaultTableResultSet(String table, Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        return st.executeQuery(SourcePropsTools.getSqlOfTable((DBSource)this.dbSource, (String)table));
    }

    private ResultSet getFilteredTableResultSet(String table, Connection conn, HashMap<String, String> keysValues) throws SQLException {
        Statement st = conn.createStatement();
        String sql = SourcePropsTools.getSqlOfTable((DBSource)this.dbSource, (String)table);
        if (keysValues.isEmpty()) {
            return st.executeQuery(sql);
        }
        if (sql.toLowerCase().contains(" where ")) {
            for (String key : keysValues.keySet()) {
                sql = sql + " and " + key + "='" + keysValues.get(key) + "'";
            }
        } else {
            sql = sql + " where ";
            for (String key : keysValues.keySet()) {
                sql = sql + key + "='" + keysValues.get(key) + "' and ";
            }
        }
        if (sql.endsWith(" and ")) {
            sql = sql.substring(0, sql.length() - 5);
        }
        return st.executeQuery(sql);
    }

    private Connection connectToDatabaseOrDieTrying() throws DBConnectionException {
        Connection conn = null;
        try {
            Class.forName((String)dbNameToDriverClass.get(this.dbSource.getDBType()));
            String url = "jdbc:" + this.dbSource.getDBType() + "://" + this.dbSource.getHost() + "/" + this.dbSource.getDBName();
            conn = DriverManager.getConnection(url, this.dbSource.getDBName(), this.dbSource.getDBPassword());
        }
        catch (ClassNotFoundException e) {
            throw new DBConnectionException("Could not find the jdbc connection class", (Throwable)e);
        }
        catch (SQLException e) {
            throw new DBConnectionException("Error connecting to the database through the jdbc class ", (Throwable)e);
        }
        return conn;
    }

    static {
        dbNameToDriverClass.put("mysql", "com.mysql.jdbc.Driver");
        dbNameToDriverClass.put("postgresql", "org.postgresql.Driver");
        dbNameToDriverClass.put("sqlite", "org.sqlite.JDBC");
    }
}

