/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.harvesting.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.harvesting.common.ElementGenerator;
import org.gcube.application.framework.harvesting.common.db.exceptions.DBConnectionException;
import org.gcube.application.framework.harvesting.common.db.tools.DBConstants;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.db.xmlobjects.DBProps;
import org.gcube.application.framework.harvesting.common.db.xmlobjects.DBSource;
import org.gcube.application.framework.harvesting.common.db.xmlobjects.Edge;
import org.gcube.application.framework.harvesting.common.db.xmlobjects.Table;
import org.gcube.application.framework.harvesting.db.DBDataStax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DBDataStax {
    private static final Logger logger = LoggerFactory.getLogger(DBDataStax.class);
    private Connection conn;
    private DBProps dbProps;
    private DBSource dbSource;
    private String rootTableName;
    private String scope;

    public DBDataStax(DBSource dbSource, DBProps dbProps, String scope) {
        this.dbSource = dbSource;
        this.scope = scope;
        try {
            this.dbProps = dbProps;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initiateRootTable();
    }

    public DBProps getSourceProps() {
        return this.dbProps;
    }

    public String getRootTableName() {
        return this.rootTableName;
    }

    private void initiateRootTable() {
        for (Table table : this.dbProps.getTables()) {
            boolean root = true;
            for (Edge edge : this.dbProps.getEdges()) {
                if (!table.getName().equalsIgnoreCase(edge.getChild())) continue;
                root = false;
            }
            if (!root) continue;
            this.rootTableName = table.getName();
            break;
        }
        logger.debug("root table is : " + this.rootTableName);
    }

    public StreamingOutput writeSourceData(String hostnameport) throws XMLStreamException, IOException, DBConnectionException {
        this.conn = this.connectToDatabaseOrDieTrying();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        1 outputStream = new /* Unavailable Anonymous Inner Class!! */;
        return outputStream;
    }

    public Element formSubElement(XMLStreamWriter writer, String tableName, HashMap<String, String> keysVals, String hostnameport) throws SQLException, XMLStreamException, TransformerException {
        Document doc = ElementGenerator.getDocument();
        ResultSet rs = this.getFilteredTableResultSet(tableName, this.conn, keysVals);
        ResultSetMetaData fields = rs.getMetaData();
        Element elementList = doc.createElement(tableName + "_list");
        ArrayList edges = SourcePropsTools.getEdges((DBProps)this.dbProps, (String)tableName);
        if (keysVals.size() == 0) {
            while (rs.next()) {
                writer.writeStartElement("record");
                writer.writeStartElement("id");
                String[] rootKeys = new String[1];
                for (Edge edge : this.dbProps.getEdges()) {
                    if (!edge.getParent().equals(tableName)) continue;
                    rootKeys = edge.getPKeys().split(",");
                }
                writer.writeCharacters("http://" + hostnameport + "/aslHarvestersHttpDB/HarvestDatabase");
                writer.writeCharacters("?sourcename=" + this.dbSource.getSourceName());
                String idStr = "";
                for (String key : rootKeys) {
                    idStr = idStr + rs.getString(key) + ",";
                }
                idStr = idStr.substring(0, idStr.length() - 1);
                writer.writeCharacters("&recordid=" + idStr);
                writer.writeEndElement();
                writer.writeStartElement("fields");
                writer.writeStartElement("field");
                writer.writeStartElement("name");
                writer.writeCharacters(tableName);
                writer.writeEndElement();
                writer.writeStartElement("mimetype");
                writer.writeCharacters("text/xml");
                writer.writeEndElement();
                writer.writeStartElement("payload");
                Element subTable = doc.createElement(tableName);
                for (int i = 1; i <= fields.getColumnCount(); ++i) {
                    Element el = doc.createElement(fields.getColumnLabel(i));
                    String val = rs.getString(i);
                    if (val == null) {
                        val = "";
                    }
                    el.appendChild(doc.createTextNode(val));
                    subTable.appendChild(el);
                }
                for (Edge edge : edges) {
                    HashMap<String, String> kv = new HashMap<String, String>();
                    String[] pkeys = edge.getPKeys().split(",");
                    String[] ckeys = edge.getCKeys().split(",");
                    for (int i = 0; i < ckeys.length; ++i) {
                        kv.put(ckeys[i], rs.getString(pkeys[i]));
                    }
                    Element e = this.formSubElement(writer, edge.getChild(), kv, hostnameport);
                    if (!e.hasChildNodes()) continue;
                    subTable.appendChild(e);
                }
                writer.writeCData(ElementGenerator.domToXML((Element)subTable));
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.flush();
            }
        } else {
            while (rs.next()) {
                Element subTable = doc.createElement(tableName);
                for (int i = 1; i <= fields.getColumnCount(); ++i) {
                    Element el = doc.createElement(fields.getColumnLabel(i));
                    String val = rs.getString(i);
                    if (val == null) {
                        val = "";
                    }
                    el.appendChild(doc.createTextNode(val));
                    subTable.appendChild(el);
                }
                for (Edge edge : edges) {
                    HashMap<String, String> kv = new HashMap<String, String>();
                    String[] pkeys = edge.getPKeys().split(",");
                    String[] ckeys = edge.getCKeys().split(",");
                    for (int i = 0; i < ckeys.length; ++i) {
                        kv.put(ckeys[i], rs.getString(pkeys[i]));
                    }
                    Element e = this.formSubElement(writer, edge.getChild(), kv, hostnameport);
                    if (!e.hasChildNodes()) continue;
                    subTable.appendChild(e);
                }
                elementList.appendChild(subTable);
            }
        }
        return elementList;
    }

    private ResultSet getDefaultTableResultSet(String table, Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        return st.executeQuery(SourcePropsTools.getSqlOfTable((DBProps)this.dbProps, (String)table));
    }

    private ResultSet getFilteredTableResultSet(String table, Connection conn, HashMap<String, String> keysValues) throws SQLException {
        Statement st = conn.createStatement();
        String sql = SourcePropsTools.getSqlOfTable((DBProps)this.dbProps, (String)table);
        if (keysValues.isEmpty()) {
            return st.executeQuery(sql);
        }
        if (sql.toLowerCase().contains(" where ")) {
            for (String key : keysValues.keySet()) {
                sql = sql + " and " + key + "='" + keysValues.get(key) + "'";
            }
        } else {
            sql = sql + " where ";
            for (String key : keysValues.keySet()) {
                sql = sql + key + "='" + keysValues.get(key) + "' and ";
            }
        }
        if (sql.endsWith(" and ")) {
            sql = sql.substring(0, sql.length() - 5);
        }
        return st.executeQuery(sql);
    }

    private Connection connectToDatabaseOrDieTrying() throws DBConnectionException {
        Connection conn = null;
        try {
            Class.forName(DBConstants.getDriverForName((String)this.dbSource.getDBType()));
            String url = "jdbc:" + this.dbSource.getDBType() + ":" + this.dbSource.getConnectionString();
            Properties props = new Properties();
            props.setProperty("user", this.dbSource.getUserName());
            props.setProperty("password", this.dbSource.getPassword());
            props.setProperty("tcpKeepAlive", "true");
            conn = DriverManager.getConnection(url, props);
        }
        catch (ClassNotFoundException e) {
            throw new DBConnectionException("Could not find the jdbc connection class", (Throwable)e);
        }
        catch (SQLException e) {
            throw new DBConnectionException("Error connecting to the database through the jdbc class ", (Throwable)e);
        }
        return conn;
    }

    static /* synthetic */ DBSource access$000(DBDataStax x0) {
        return x0.dbSource;
    }

    static /* synthetic */ String access$100(DBDataStax x0) {
        return x0.rootTableName;
    }

    static /* synthetic */ Connection access$200(DBDataStax x0) {
        return x0.conn;
    }
}

