/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.content.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.contentmanagement.exceptions.ContentReaderCreationException;
import org.gcube.application.framework.contentmanagement.exceptions.DocumentRetrievalException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.GCubeCollections;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;

public class Collection {
    static ISClient client;
    protected ASLSession session;
    protected String colID;
    protected static AtomicInteger cmsId;
    protected static AtomicInteger colMSId;

    public Collection(ASLSession ses, String collectionId) {
        this.session = ses;
        this.colID = collectionId;
    }

    public static String getCollectionByName(String name, ASLSession ses) {
        try {
            List collections = Collections.findByName((GCUBEScope)ses.getScope(), (String)name);
            if (collections != null && collections.size() > 0) {
                if (collections.size() > 1) {
                    System.out.println("More than one collections detected with the same name. The first one will be used");
                }
                System.out.println("Returning the ID of the collection with name --> " + name + ". The ID is --> " + ((org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection)collections.get(0)).getId());
                return ((org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection)collections.get(0)).getId();
            }
        }
        catch (Exception e) {
            System.out.println("An exception was thrown while trying to find the collection with name: " + name);
            return null;
        }
        return null;
    }

    public static String createCollection(String collectionName, ASLSession ses, Boolean userCollection) {
        String colId = null;
        boolean propagateRequest = true;
        boolean readable = true;
        boolean writable = true;
        List collectionReferences = null;
        try {
            collectionReferences = GCubeCollections.createGCubeCollection((boolean)propagateRequest, (String)collectionName, (String)"", (boolean)false, (boolean)readable, (boolean)writable, (GCUBEScope)ses.getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            System.out.println("An exception was thrown while trying to create a collection.");
            e.printStackTrace();
        }
        if (collectionReferences != null) {
            System.out.println("Collection with name: " + collectionName + " has just been created. Only one reference should have been returned.");
            if (collectionReferences.size() > 1) {
                System.out.println("More than one references have been returned. The first one will be used");
            }
            colId = ((CollectionReference)collectionReferences.get(0)).getCollectionID();
            System.out.println("The ID of the created collection is: " + colId);
        }
        return colId;
    }

    public static boolean deleteCollection(String collectionID, ASLSession ses) {
        try {
            GCubeCollections.deleteGCubeCollection((String)collectionID, (boolean)true, (GCUBEScope)ses.getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public DigitalObject addMember(InputStream content, String fileName, String mimeType) {
        DigitalObject newDO = DigitalObject.createNewDigitalObject(this.colID, content, fileName, this.session, mimeType);
        return newDO;
    }

    public void removeMember(String oid, String collectionId, ASLSession ses) {
        DocumentWriter writer = null;
        try {
            writer = new DocumentWriter(collectionId, this.session.getScope());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        GCubeDocument document = new GCubeDocument(oid);
        try {
            writer.delete(document);
        }
        catch (ManagerCall.DiscoveryException e) {
            e.printStackTrace();
        }
        catch (GCUBEException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getMemberIDs(String collectionId, ASLSession ses) {
        DocumentReader reader = null;
        try {
            reader = new DocumentReader(this.colID, this.session.getScope());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] ids = null;
        ArrayList<String> idsList = new ArrayList<String>();
        try {
            RemoteIterator docs = reader.get((Projection)Projections.document().with((Property)Projections.CREATION_TIME, (Property[])new PropertyTypes.DocumentProperty[0]));
            while (docs.hasNext()) {
                idsList.add(((GCubeDocument)docs.next()).id());
            }
            ids = new String[idsList.size()];
            for (int i = 0; i < idsList.size(); ++i) {
                ids[i] = (String)idsList.get(i);
            }
        }
        catch (ManagerCall.DiscoveryException e) {
            e.printStackTrace();
        }
        catch (GCUBEException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ids;
    }

    public ArrayList<DocumentInfos> getDocumentInfos(ASLSession session) throws ContentReaderCreationException, DocumentRetrievalException {
        DocumentReader reader = null;
        try {
            reader = new DocumentReader(this.colID, session.getScope());
        }
        catch (Exception e) {
            throw new ContentReaderCreationException(e);
        }
        ArrayList<DocumentInfos> documentInfos = new ArrayList<DocumentInfos>();
        try {
            RemoteIterator docs = reader.get((Projection)Projections.document().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.DocumentProperty[0]));
            while (docs.hasNext()) {
                DocumentInfos docInfo = new DocumentInfos();
                GCubeDocument doc = (GCubeDocument)docs.next();
                docInfo.setDocumentId(doc.id());
                docInfo.setName(doc.name());
                documentInfos.add(docInfo);
            }
        }
        catch (ManagerCall.DiscoveryException e) {
            throw new DocumentRetrievalException(e);
        }
        catch (GCUBEException e) {
            throw new DocumentRetrievalException(e);
        }
        catch (Exception e) {
            throw new DocumentRetrievalException(e);
        }
        return documentInfos;
    }

    static {
        cmsId = new AtomicInteger(0);
        colMSId = new AtomicInteger(0);
    }
}

