/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.content.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.accesslogger.model.ContentRetrievalLogEntry;
import org.gcube.application.framework.contentmanagement.cache.factories.CollectionInfoCacheEntryFactory;
import org.gcube.application.framework.contentmanagement.cache.factories.MetadataCacheEntryFactory;
import org.gcube.application.framework.contentmanagement.cache.factories.NewContentInfoCacheEntryFactory;
import org.gcube.application.framework.contentmanagement.cache.factories.ThumbnailCacheEntryFactory;
import org.gcube.application.framework.contentmanagement.content.DigitalObjectInfoI;
import org.gcube.application.framework.contentmanagement.model.CollectionInfo;
import org.gcube.application.framework.contentmanagement.model.SchemataInfos;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.exceptions.UnknownDocumentException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.AlternativeProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.AnnotationProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.MetadataProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.PartProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAlternative;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAnnotation;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubePart;

public class DigitalObject
implements DigitalObjectInfoI {
    private static final GCUBELog logger = new GCUBELog(DigitalObject.class);
    private static AtomicInteger cmsId = new AtomicInteger(0);
    private ASLSession session;
    private String elementType = new String();
    private String oid;
    private AccessLogger accessLogger = AccessLogger.getAccessLogger();
    private String uri;
    private String colID;
    private String colName;
    private CollectionInfo colInfo;
    private String html;
    private String title;
    private String schema;
    private String rank;
    private String metadataID;
    private String metaRecord;

    public String getObjectId() {
        return this.oid;
    }

    public void setObjectId(String oid) {
        this.oid = oid;
    }

    public String getCollectionID() {
        return this.colID;
    }

    public void setCollectionID(String colID) {
        this.colID = colID;
    }

    public void setMetadataID(String metadataId) {
        this.metadataID = metadataId;
    }

    public String getMetadataID() {
        return this.metadataID;
    }

    @Override
    public String getMetaRecord() {
        return this.metaRecord;
    }

    @Override
    public void setMetaRecord(String mr) {
        this.metaRecord = mr;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    @Override
    public void setCollectionName(String collectionName) {
        this.colName = collectionName;
    }

    @Override
    public String getCollectionName() {
        return this.colName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public DigitalObject(ASLSession session, String oid, String colID) {
        this.session = session;
        this.oid = oid;
        this.colID = colID;
        this.metadataID = "";
        System.out.println("The oid is: " + oid);
        if (oid != null) {
            this.uri = URIs.make((String)colID, (String[])new String[]{oid}).toString();
        }
        this.html = "";
        this.title = "";
        this.schema = "";
        this.rank = "";
    }

    public DigitalObject(ASLSession session, String uri, boolean isUri) {
        this.session = session;
        this.uri = uri.trim();
        try {
            URI theUri = new URI(uri.trim());
            this.oid = URIs.documentID((URI)theUri);
            logger.debug((Object)("The document id resolved from the constructor is: " + this.oid));
            System.out.println("The document id resolved from the constructor is: " + this.oid);
            this.colID = URIs.collectionID((URI)theUri);
            this.metadataID = "";
            this.html = "";
            this.title = "";
            this.schema = "";
            this.rank = "";
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getDocumentURI() {
        return this.uri;
    }

    @Override
    public void setDocumentURI(String dURI) {
        this.uri = dURI.trim();
    }

    @Override
    public List<String> getAvailableSchemata() {
        if (this.colInfo == null) {
            QueryString query = new QueryString();
            query.addParameter("scope", this.session.getOriginalScopeName());
            query.addParameter("colId", this.colID);
            this.colInfo = (CollectionInfo)CachesManager.getInstance().getEhcache("collections", (CacheEntryFactory)new CollectionInfoCacheEntryFactory()).get((Serializable)query).getValue();
        }
        ArrayList<String> schemata = new ArrayList<String>();
        for (int i = 0; i < this.colInfo.getMetadataSize(); ++i) {
            schemata.add(this.colInfo.getSchema(i));
        }
        return schemata;
    }

    public List<SchemataInfos> getAvailableSchemataInfos() {
        ArrayList<SchemataInfos> schemataInfos = new ArrayList<SchemataInfos>();
        if (this.colInfo == null) {
            QueryString query = new QueryString();
            query.addParameter("scope", this.session.getOriginalScopeName());
            query.addParameter("colId", this.colID);
            this.colInfo = (CollectionInfo)CachesManager.getInstance().getEhcache("collections", (CacheEntryFactory)new CollectionInfoCacheEntryFactory()).get((Serializable)query).getValue();
        }
        for (int i = 0; i < this.colInfo.getMetadataSize(); ++i) {
            SchemataInfos schemaInfos = new SchemataInfos();
            schemaInfos.setName(this.colInfo.getSchema(i));
            schemaInfos.setLanguage(this.colInfo.getLanguage(i));
            schemataInfos.add(schemaInfos);
        }
        return schemataInfos;
    }

    @Override
    public long getLength() {
        block8: {
            try {
                QueryString query = new QueryString();
                query.addParameter("vre", this.session.getOriginalScopeName());
                query.addParameter("cid", this.colID);
                String docId = null;
                if (!this.elementType.equals("") && !this.elementType.equals("mainDoc")) {
                    if (this.elementType.equals("alternative")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeAlternative docDescription = (GCubeAlternative)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.length();
                    }
                    if (this.elementType.equals("annotation")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeAnnotation docDescription = (GCubeAnnotation)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.length();
                    }
                    if (this.elementType.equals("metadata")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeMetadata docDescription = (GCubeMetadata)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.length();
                    }
                    if (this.elementType.equals("part")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeMetadata docDescription = (GCubeMetadata)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.length();
                    }
                    break block8;
                }
                docId = !this.elementType.equals("") && !this.elementType.equals("mainDoc") ? this.getDocumentIdBasedOnElementType() : this.oid;
                query.addParameter("oid", docId);
                GCubeDocument docDescription = (GCubeDocument)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                System.out.println("Asked for document description for document: " + docId);
                Long len = docDescription.length();
                if (len != null) {
                    return len;
                }
                return -1L;
            }
            catch (Exception e) {
                logger.error((Object)"An error occur while trying to retrieve document's length from cache", (Throwable)e);
            }
        }
        return -1L;
    }

    @Override
    public String getMetadata(String schema) {
        QueryString query;
        if (this.colInfo == null) {
            query = new QueryString();
            query.addParameter("scope", this.session.getOriginalScopeName());
            query.addParameter("colId", this.colID);
            this.colInfo = (CollectionInfo)CachesManager.getInstance().getEhcache("collections", (CacheEntryFactory)new CollectionInfoCacheEntryFactory()).get((Serializable)query).getValue();
        }
        try {
            query = new QueryString();
            query.addParameter("vre", this.session.getOriginalScopeName());
            query.addParameter("oid", this.oid);
            query.addParameter("metadataColID", this.colInfo.getMetadataID(this.colInfo.getIndexOfSchema(schema)));
            logger.debug((Object)("metadata collection id: " + this.colInfo.getMetadataID(this.colInfo.getIndexOfSchema(schema))));
            return (String)((Object)CachesManager.getInstance().getEhcache("metadata", (CacheEntryFactory)new MetadataCacheEntryFactory()).get((Serializable)query).getValue());
        }
        catch (Exception e) {
            logger.error((Object)"An error occured while trying to retrieve document's lmetadata from cache", (Throwable)e);
            return null;
        }
    }

    public String getMetadata(String schemaName, String language) {
        QueryString query;
        if (this.colInfo == null) {
            query = new QueryString();
            query.addParameter("scope", this.session.getOriginalScopeName());
            query.addParameter("colId", this.colID);
            this.colInfo = (CollectionInfo)CachesManager.getInstance().getEhcache("collections", (CacheEntryFactory)new CollectionInfoCacheEntryFactory()).get((Serializable)query).getValue();
        }
        try {
            query = new QueryString();
            query.addParameter("vre", this.session.getOriginalScopeName());
            query.addParameter("oid", this.oid);
            String metadataId = new String();
            for (int i = 0; i < this.colInfo.getMetadataSize(); ++i) {
                if (!this.colInfo.getSchema(i).equals(schemaName) || !this.colInfo.getLanguage(i).equals(language)) continue;
                metadataId = this.colInfo.getMetadataID(i);
                break;
            }
            query.addParameter("metadataColID", metadataId);
            logger.debug((Object)("metadata collection id: " + this.colInfo.getMetadataID(this.colInfo.getIndexOfSchema(this.schema))));
            return (String)((Object)CachesManager.getInstance().getEhcache("metadata", (CacheEntryFactory)new MetadataCacheEntryFactory()).get((Serializable)query).getValue());
        }
        catch (Exception e) {
            logger.error((Object)"An error occured while trying to retrieve document's metadata from cache", (Throwable)e);
            return null;
        }
    }

    public String getMetadataCollectionIdFromSchema(String schemaName, String schemaLanguage) {
        if (this.colInfo == null) {
            QueryString query = new QueryString();
            query.addParameter("scope", this.session.getOriginalScopeName());
            query.addParameter("colId", this.colID);
            this.colInfo = (CollectionInfo)CachesManager.getInstance().getEhcache("collections", (CacheEntryFactory)new CollectionInfoCacheEntryFactory()).get((Serializable)query).getValue();
        }
        String metadataId = new String();
        System.out.println("La the schemaName is: " + schemaName + " " + schemaLanguage);
        for (int i = 0; i < this.colInfo.getMetadataSize(); ++i) {
            System.out.println("Now it is: " + this.colInfo.getSchema(i) + " " + this.colInfo.getLanguage(i));
            if (!this.colInfo.getSchema(i).equals(schemaName) || !this.colInfo.getLanguage(i).equals(schemaLanguage)) continue;
            metadataId = this.colInfo.getMetadataID(i);
            System.out.println("The returned metadata id is: " + metadataId);
            break;
        }
        return metadataId;
    }

    public String getMetadataFromMetadataID(String mid) {
        QueryString query;
        if (this.colInfo == null) {
            query = new QueryString();
            query.addParameter("scope", this.session.getOriginalScopeName());
            query.addParameter("colId", this.colID);
            this.colInfo = (CollectionInfo)CachesManager.getInstance().getEhcache("collections", (CacheEntryFactory)new CollectionInfoCacheEntryFactory()).get((Serializable)query).getValue();
        }
        query = new QueryString();
        query.addParameter("vre", this.session.getOriginalScopeName());
        query.addParameter("oid", this.oid);
        query.addParameter("metadataColID", mid);
        return (String)((Object)CachesManager.getInstance().getEhcache("metadata", (CacheEntryFactory)new MetadataCacheEntryFactory()).get((Serializable)query).getValue());
    }

    public Vector<String> getSchemaLanguages(String schema) {
        if (this.colInfo == null) {
            QueryString query = new QueryString();
            query.addParameter("scope", this.session.getOriginalScopeName());
            query.addParameter("colId", this.colID);
            this.colInfo = (CollectionInfo)CachesManager.getInstance().getEhcache("collections", (CacheEntryFactory)new CollectionInfoCacheEntryFactory()).get((Serializable)query).getValue();
        }
        Vector<String> languages = new Vector<String>();
        for (int i = 0; i < this.colInfo.getMetadataSize(); ++i) {
            if (!this.colInfo.getSchema(i).equals(schema)) continue;
            languages.add(this.colInfo.getLanguage(i));
        }
        return languages;
    }

    @Override
    public String getMimeType() {
        block11: {
            try {
                System.out.println("Getting mime type for elementType: " + this.elementType);
                QueryString query = new QueryString();
                query.addParameter("vre", this.session.getOriginalScopeName());
                query.addParameter("cid", this.colID);
                if (!this.elementType.equals("") && !this.elementType.equals("mainDoc")) {
                    if (this.elementType.equals("alternative")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        if (CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()) == null) {
                            System.out.println("The cache is null!!");
                        } else {
                            System.out.println("The cache is not null!!");
                        }
                        if (CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query) == null) {
                            System.out.println("NUKKKKK");
                        } else {
                            System.out.println("Not NUK");
                        }
                        GCubeAlternative docDescription = (GCubeAlternative)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        System.out.println("Reaching here");
                        return docDescription.mimeType();
                    }
                    if (this.elementType.equals("annotation")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeAnnotation docDescription = (GCubeAnnotation)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.mimeType();
                    }
                    if (this.elementType.equals("metadata")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeMetadata docDescription = (GCubeMetadata)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.mimeType();
                    }
                    if (this.elementType.equals("part")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeMetadata docDescription = (GCubeMetadata)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.mimeType();
                    }
                    break block11;
                }
                String docId = null;
                docId = !this.elementType.equals("") && !this.elementType.equals("mainDoc") ? this.getDocumentIdBasedOnElementType() : this.oid;
                query.addParameter("oid", docId);
                GCubeDocument docDescription = (GCubeDocument)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                return docDescription.mimeType();
            }
            catch (Exception e) {
                logger.error((Object)"An error occured while trying to retrieve document's mime type from cache", (Throwable)e);
                e.printStackTrace();
            }
        }
        return "unknown/unknown";
    }

    @Override
    public InputStream getObject(String elementType) {
        System.setProperty("java.protocol.handler.pkgs", "org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol");
        logger.debug((Object)("Inside getObject " + this.oid + " " + this.colID));
        System.out.println("Inside getObject " + this.oid + " " + this.colID);
        String name = this.getName();
        ContentRetrievalLogEntry contentEntry = new ContentRetrievalLogEntry(this.uri, name);
        this.accessLogger.logEntry(this.session.getUsername(), this.session.getScopeName(), (AccessLogEntry)contentEntry);
        DocumentReader reader = null;
        try {
            reader = new DocumentReader(this.colID, this.session.getScope());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GCubeDocument doc = null;
        if (elementType.equals("mainDoc") || elementType.equals("")) {
            try {
                doc = reader.get(this.oid, (Projection)Projections.document().with(Projections.opt((Property)Projections.BYTESTREAM_URI), (Property[])new PropertyTypes.DocumentProperty[]{(PropertyTypes.DocumentProperty)Projections.opt((Property)Projections.BYTESTREAM)}));
            }
            catch (UnknownDocumentException e) {
                logger.error((Object)"An error occured while getting content from CM", (Throwable)e);
            }
            catch (ManagerCall.DiscoveryException e) {
                logger.error((Object)"An error occured while getting content from CM", (Throwable)e);
            }
            catch (GCUBEException e) {
                logger.error((Object)"An error occured while getting content from CM", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"An error occured while getting content from CM", (Throwable)e);
            }
            logger.debug((Object)("The oid is: " + this.oid + " and the colid is: " + this.colID));
            try {
                GCUBEScopeManager.DEFAULT.setScope(this.session.getScope());
                InputStream content = doc.resolveBytestream();
                return content;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            if (elementType.equals("alternative")) {
                AlternativeProjection alP = Projections.alternative();
                URI Uri = new URI(this.uri);
                GCubeAlternative alternative = (GCubeAlternative)reader.resolve(Uri, (Projection)alP);
                ByteArrayInputStream is = new ByteArrayInputStream(alternative.bytestream());
                return is;
            }
            if (elementType.equals("annotation")) {
                AnnotationProjection ap = Projections.annotation();
                URI Uri = new URI(this.uri);
                GCubeAnnotation annotation = (GCubeAnnotation)reader.resolve(Uri, (Projection)ap);
                ByteArrayInputStream is = new ByteArrayInputStream(annotation.bytestream());
                return is;
            }
            if (elementType.equals("part")) {
                PartProjection pp = Projections.part();
                URI Uri = new URI(this.uri);
                GCubePart part = (GCubePart)reader.resolve(Uri, (Projection)pp);
                ByteArrayInputStream is = new ByteArrayInputStream(part.bytestream());
                return is;
            }
            if (elementType.equals("metadata")) {
                MetadataProjection mp = Projections.metadata();
                URI Uri = new URI(this.uri);
                GCubeMetadata metadata = (GCubeMetadata)reader.resolve(Uri, (Projection)mp);
                ByteArrayInputStream is = new ByteArrayInputStream(metadata.bytestream());
                return is;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while retrieving content", (Throwable)e);
        }
        return null;
    }

    private String getDocumentIdBasedOnElementType() {
        DocumentReader reader = null;
        try {
            reader = new DocumentReader(this.colID, this.session.getScope());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.elementType.equals("alternative")) {
                AlternativeProjection alP = Projections.alternative();
                URI Uri = new URI(this.uri);
                GCubeAlternative alternative = (GCubeAlternative)reader.resolve(Uri, (Projection)alP);
                return alternative.id();
            }
            if (this.elementType.equals("annotation")) {
                AnnotationProjection ap = Projections.annotation();
                URI Uri = new URI(this.uri);
                GCubeAnnotation annotation = (GCubeAnnotation)reader.resolve(Uri, (Projection)ap);
                return annotation.id();
            }
            if (this.elementType.equals("part")) {
                PartProjection pp = Projections.part();
                URI Uri = new URI(this.uri);
                GCubePart part = (GCubePart)reader.resolve(Uri, (Projection)pp);
                return part.id();
            }
            if (this.elementType.equals("metadata")) {
                MetadataProjection mp = Projections.metadata();
                URI Uri = new URI(this.uri);
                GCubeMetadata metadata = (GCubeMetadata)reader.resolve(Uri, (Projection)mp);
                return metadata.id();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting document id for that element type", (Throwable)e);
        }
        return null;
    }

    @Override
    public void updateContent(ASLSession session, byte[] rawContent) {
        GCubeDocument virtualDocument = new GCubeDocument(this.oid);
        virtualDocument.setBytestream(new byte[0]);
        try {
            virtualDocument.trackChanges();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        virtualDocument.setBytestream(rawContent);
        DocumentWriter docWriter = null;
        try {
            docWriter = new DocumentWriter(this.colID, session.getScope());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            docWriter.update(virtualDocument);
        }
        catch (ManagerCall.DiscoveryException e) {
            e.printStackTrace();
        }
        catch (GCUBEException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String FindObjectByName(String name, String collectionID, ASLSession ses) {
        GCubeDocument document = null;
        try {
            DocumentReader reader = new DocumentReader(collectionID, ses.getScope());
            DocumentProjection projection = (DocumentProjection)Projections.document().withValue((Property)Projections.NAME, (Object)name);
            RemoteIterator documentIterator = reader.get((Projection)projection);
            if (!documentIterator.hasNext()) {
                logger.debug((Object)("There are no documents with the name --> " + name));
                return null;
            }
            document = (GCubeDocument)documentIterator.next();
            logger.debug((Object)("Found the document with ID: " + document.id() + " and name: " + name));
            return document.id();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to find the ID of the document with name: " + name + ". An exception was thrown"), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public InputStream getObjectByName(String name, String collectionName) {
        return null;
    }

    @Override
    public byte[] getThumbnail(int width, int height, String options) {
        System.out.println("Thumbnail asked");
        try {
            QueryString query = new QueryString();
            query.addParameter("vre", this.session.getOriginalScopeName());
            query.addParameter("oid", this.oid);
            query.addParameter("width", "" + width);
            query.addParameter("height", "" + height);
            query.addParameter("thumbOptions", options);
            return (byte[])CachesManager.getInstance().getEhcache("thumbnail", (CacheEntryFactory)new ThumbnailCacheEntryFactory()).get((Serializable)query).getValue();
        }
        catch (Exception e) {
            logger.error((Object)"an error occred while trying to retrieve the thumbnail from cache", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getName() {
        block7: {
            try {
                QueryString query = new QueryString();
                query.addParameter("vre", this.session.getOriginalScopeName());
                query.addParameter("cid", this.colID);
                String docId = null;
                if (!this.elementType.equals("") && !this.elementType.equals("mainDoc")) {
                    if (this.elementType.equals("alternative")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeAlternative docDescription = (GCubeAlternative)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.name();
                    }
                    if (this.elementType.equals("annotation")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeAnnotation docDescription = (GCubeAnnotation)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.name();
                    }
                    if (this.elementType.equals("metadata")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeMetadata docDescription = (GCubeMetadata)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.name();
                    }
                    if (this.elementType.equals("part")) {
                        query.addParameter("uri", this.uri.toString());
                        query.addParameter("elementType", this.elementType);
                        GCubeMetadata docDescription = (GCubeMetadata)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                        return docDescription.name();
                    }
                    break block7;
                }
                docId = this.oid;
                query.addParameter("oid", docId);
                GCubeDocument docDescription = (GCubeDocument)CachesManager.getInstance().getEhcache("content", (CacheEntryFactory)new NewContentInfoCacheEntryFactory()).get((Serializable)query).getObjectValue();
                return docDescription.name();
            }
            catch (Exception e) {
                logger.error((Object)"An error occured while trying to retrieve document's name from cache", (Throwable)e);
            }
        }
        return "unknown";
    }

    @Override
    public String getHTMLrepresentation() {
        return this.html;
    }

    @Override
    public void setHTMLrepresentation(String html) {
        this.html = html;
    }

    public static DigitalObject createNewDigitalObject(String collectionID, InputStream content, String fileName, ASLSession session, String mimeType) {
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        try {
            int c;
            while ((c = content.read(buffer, 0, buffer.length)) != -1) {
                temp.write(buffer, 0, c);
            }
        }
        catch (IOException e1) {
            logger.error((Object)"failed to read content to be added", (Throwable)e1);
        }
        DocumentWriter writer = null;
        try {
            writer = new DocumentWriter(collectionID, session.getScope());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        GCubeDocument document = new GCubeDocument();
        document.setCollectionID(collectionID);
        document.setName(fileName);
        document.setBytestream(buffer);
        document.setMimeType(mimeType);
        String objectID = null;
        try {
            objectID = writer.add(document);
        }
        catch (ManagerCall.DiscoveryException e) {
            e.printStackTrace();
        }
        catch (GCUBEException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DigitalObject(session, objectID, collectionID);
    }

    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String elementType) {
        this.elementType = elementType;
    }
}

