package org.gcube.application.framework.contentmanagement.util;


import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Random;

import javax.xml.rpc.ServiceException;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI.MalformedURIException;
import org.apache.log4j.Logger;
import org.gcube.application.framework.contentmanagement.cache.factories.NewContentInfoCacheEntryFactory;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.cache.factories.ApplicationCredentials;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.util.CacheEntryConstants;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.MalformedScopeExpressionException;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall.DiscoveryException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.exceptions.UnknownDocumentException;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.service.DataTransformationServiceAddressingLocator;
import org.gcube.informationsystem.cache.SrvType;
import static org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections.*;

public class ThumbnailUtils {
	private static Logger log = Logger.getLogger(ThumbnailUtils.class);
	
		
	public final static int chunkSize = 1024*1024;
	public static byte[] getContentFromCMS(String oid, String scope) throws Exception {
		URI contentURI = new URI(oid);
		String collectionId = URIs.collectionID(contentURI);
		String contentId = URIs.documentID(contentURI);
		DocumentReader reader = null;
		GCubeDocument doc = null;
		try {
			reader = new DocumentReader(collectionId, GCUBEScope.getScope(scope));
			doc = reader.get(contentId, document().with(opt(BYTESTREAM)));
		} catch (UnknownDocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (DiscoveryException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (GCUBEException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (doc.bytestream() != null) {
			byte[] bytes = doc.bytestream();
			return bytes;
		}
		return null;
//		CMSPortType1PortType cms = getCMS(scope);
//		ByteArrayOutputStream outstream = new ByteArrayOutputStream();
//		int tries=0;
//		try {
//			log.info("I will try to retrieve the object with id "+oid+".");
//			//Configuring the parameters to get the doc...
//			GetDocumentParameters getDocumentParams = new GetDocumentParameters();
//			getDocumentParams.setDocumentID(oid);
//			getDocumentParams.setTargetFileLocation(BasicInfoObjectDescription.RAW_CONTENT_IN_MESSAGE);
//			
//			for(int count=0;;count++){
//				Hint[] hints = new Hint[2];
//				hints[0] = new Hint();
//				hints[0].setName(BasicStorageHints.HINT_NAME_READING_START_OFFSET);
//				hints[0].setValue(String.valueOf(count*chunkSize));
//				hints[1] = new Hint();
//				hints[1].setName(BasicStorageHints.HINT_NAME_LIMIT_CONTENT_LENGTH_READ);
//				hints[1].setValue(String.valueOf(chunkSize));
//				getDocumentParams.setHints(hints);
//				try {
//	//				Invoking CMS to get the document description here...				
//					DocumentDescription document = cms.getDocument(getDocumentParams);
//	
//					byte[] buffer = document.getRawContent();
//					if(buffer == null)
//						break;
//					outstream.write(buffer);
//					outstream.flush();
//					if(buffer.length < chunkSize)
//						break;
//				} catch(RemoteException e) {
//					if(tries<10){
//						log.error("Caught a remote exception trying again...",e);
//						tries++;
//						count--;
//					}else{
//						log.error("Abording downloading.");
//						throw new Exception("Abording downloading tries = 10");
//					}
//				} catch(Exception e1) {
//					log.error("Undefined exception in getDataElementFromCMS()",e1);
//					throw new Exception("Undefined exception in getDataElementFromCMS()");
//				}
//				log.trace("I have retrieve the "+count+" chunk for object "+oid);
//			}
//			log.debug("The size of the outstream of object "+oid+" is "+outstream.size());
//			outstream.close();
//		} catch (IOException e) {
//			log.error("IOException in getDataElementFromCMS()",e);
//			throw new Exception("IOException in getDataElementFromCMS()");
//		} 
//		if(outstream==null || outstream.size()<1){
//			throw new Exception("Did not manage to download the content of object "+oid+" from cms");
//		}
//		log.debug("Downloading the OID "+oid+" completed successfully.");
//		return outstream.toByteArray();
	}
	
	public static String getMimeType(String oid, String scope) throws Exception {
		URI uri = new URI(oid);
		String collectionId = URIs.collectionID(uri);
		String documentId = URIs.documentID(uri);
		
		try {
			QueryString query = new QueryString();
			query.addParameter(CacheEntryConstants.vre, scope);
			query.addParameter(CacheEntryConstants.oid, oid);
			query.addParameter("cid", collectionId);
			GCubeDocument docDescription = (GCubeDocument) CachesManager.getInstance().getEhcache(org.gcube.application.framework.contentmanagement.util.CacheEntryConstants.newContentCache, new NewContentInfoCacheEntryFactory()).get(query).getObjectValue();
			return docDescription.mimeType();
		} catch (Exception e) {
			System.out.println("An error occured while trying to retrieve document's mime type from cache");
		}
		return "unknown/unknown";
	}
	
//	public static CMSPortType1PortType getCMS(String vre) throws MalformedURIException,
//	ServiceException {
//		EndpointReference[] cmsURIs = null;
//		try {
//			
//				cmsURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope(vre)).getEPRsFor("ContentManagement","ContentManagementService",SrvType.SIMPLE.name());
//		} catch (Exception e2) {
//			// TODO Auto-generated catch block
//			e2.printStackTrace();
//		}
//		boolean excep = true;
//		String cmsAddress;
//		Random random = new Random();
//		cmsAddress = cmsURIs[random.nextInt(cmsURIs.length)].getAddress().toString();
//		CMSPortType1PortType cms;
//		EndpointReferenceType endpoint = new EndpointReferenceType();
//		endpoint.setAddress(new Address(cmsAddress));
//		CMSPortType1ServiceAddressingLocator cmslocator = new CMSPortType1ServiceAddressingLocator();
//		cms = cmslocator.getCMSPortType1PortTypePort(endpoint);
//		try {
//			cms = ServiceContextManager.applySecurity(cms, GCUBEScope.getScope(vre), ApplicationCredentials.getInstance().getCredential(vre));
//		} catch (MalformedScopeExpressionException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (Exception e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		return cms; 
//	}
		
	public static DataTransformationServicePortType getDTSPortType(String scope) throws Exception {
		List<GCUBERunningInstance> result = null;
		
		EndpointReference[] dtsURIs = null;
		try {
			dtsURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope(scope)).getEPRsFor("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name());
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		String dtsAddress;
		Random random = new Random();
		dtsAddress = dtsURIs[random.nextInt(dtsURIs.length)].getAddress().toString();
		DataTransformationServicePortType dts;
		EndpointReferenceType endpoint = new EndpointReferenceType();
		endpoint.setAddress(new Address(dtsAddress));
		DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
		dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
		try {
			dts = ServiceContextManager.applySecurity(dts, GCUBEScope.getScope(scope), ApplicationCredentials.getInstance().getCredential(scope));
		} catch (MalformedScopeExpressionException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return dts;
	}
	
	public static GCubeDocument getDocumentDescription(String oid, String scope) throws Exception {
		QueryString newQuery = new QueryString();
		newQuery.addParameter(CacheEntryConstants.vre, scope);
		newQuery.addParameter(CacheEntryConstants.oid, oid);
		GCubeDocument docDescription = (GCubeDocument) CachesManager.getInstance().getEhcache(org.gcube.application.framework.contentmanagement.util.CacheEntryConstants.contentCache, new NewContentInfoCacheEntryFactory()).get(newQuery).getValue();
		return docDescription;
	}
}
