/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.cache.factories;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.contentmanagement.util.Pictures;
import org.gcube.application.framework.contentmanagement.util.ThumbnailUtils;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAlternative;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElementProperty;
import org.gcube.datatransformation.datatransformationservice.stubs.ContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.FindApplicableTransformationUnits;
import org.gcube.datatransformation.datatransformationservice.stubs.FindApplicableTransformationUnitsResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.Input;
import org.gcube.datatransformation.datatransformationservice.stubs.Output;
import org.gcube.datatransformation.datatransformationservice.stubs.Parameter;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataWithTransformationUnit;

public class ThumbnailCacheEntryFactory
implements CacheEntryFactory {
    protected final GCUBELog logger = new GCUBELog((Object)this);
    protected static AtomicInteger thumbId = new AtomicInteger(0);
    protected static final String thumbnailsRootPath = "/icons/";
    private static ContentType trgContentTypeForSearch = new ContentType();

    public Object createEntry(Object key) throws Exception {
        QueryString query = (QueryString)key;
        String vre = (String)query.get((Object)"vre");
        String oid = (String)query.get((Object)"oid");
        int width = Integer.parseInt((String)query.get((Object)"width"));
        int height = Integer.parseInt((String)query.get((Object)"height"));
        String[] thumbOptions = ((String)query.get((Object)"thumbOptions")).split(",");
        this.logger.debug((Object)("Going to get thumbnail oid: " + oid + " width: " + width + " height: " + height + " options: " + thumbOptions[0]));
        return this.getThumbnail(oid, width, height, thumbOptions, vre);
    }

    public byte[] getThumbnail(String srcObjectID, int width, int height, String[] thumbOptions, String scope) throws Exception {
        try {
            TransformationUnit transformationUnit;
            String thumbnailOID = this.searchForExistingThumbnail(srcObjectID, width, height, thumbOptions, scope);
            if (thumbnailOID != null) {
                return this.getContentFromCMS(thumbnailOID, scope);
            }
            boolean creation = this.containOption(thumbOptions, "FORCE_CREATE");
            if (!creation || (transformationUnit = this.findTransformationUnitToCreateThumbnail(this.getMimeType(srcObjectID, scope), scope)) == null) {
                return this.findStaticImageThumbnail(this.getMimeType(srcObjectID, scope));
            }
            this.createThumbnail(srcObjectID, transformationUnit, width, height, scope);
            int tries = 0;
            while (true) {
                if ((thumbnailOID = this.searchForExistingThumbnail(srcObjectID, width, height, thumbOptions, scope)) != null) {
                    return this.getContentFromCMS(thumbnailOID, scope);
                }
                if (tries != 5) {
                    ++tries;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Did not manage to search/create/get Thumbnail for object with id " + srcObjectID + ", returning static..."), (Throwable)e);
            this.logger.error((Object)"Exception:", (Throwable)e);
        }
        return this.findStaticImageThumbnail(this.getMimeType(srcObjectID, scope));
    }

    private String constructFileNameFromMT(String srcMimetype) {
        return thumbnailsRootPath + srcMimetype + ".png";
    }

    private byte[] findStaticImageThumbnail(String srcMimetype) throws Exception {
        File thumbnail;
        String srcMimetypeFormat = srcMimetype.replaceAll("/", "_").replaceAll("-", "_").replaceAll("\\.", "_");
        while (!(thumbnail = new File(this.constructFileNameFromMT(srcMimetypeFormat))).exists()) {
            if (srcMimetypeFormat.contains("_")) {
                srcMimetypeFormat = srcMimetypeFormat.substring(0, srcMimetypeFormat.lastIndexOf("_"));
                continue;
            }
            this.logger.info((Object)"About to get static thumbnail");
            ImageIcon im = new ImageIcon(DigitalObject.class.getResource("/icons/noThumbnail.gif"));
            Image image = im.getImage();
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            this.logger.info((Object)("Width: " + w + " height " + h));
            BufferedImage bi = Pictures.toBufferedImage(image);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "JPEG", baos);
            byte[] byteArray = baos.toByteArray();
            return byteArray;
        }
        return this.getBytes(thumbnail);
    }

    private byte[] getBytes(File file) throws Exception {
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            byte[] buf = new byte[(int)file.length()];
            in.readFully(buf);
            return buf;
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception:", (Throwable)e);
            throw new Exception("Could not read contents of file", e);
        }
    }

    private TransformationUnit findTransformationUnitToCreateThumbnail(String srcMimeType, String scope) throws Exception {
        FindApplicableTransformationUnitsResponse response;
        this.logger.debug((Object)("Going to find transformation unit to create thumbnail for src mimetype: " + srcMimeType));
        DataTransformationServicePortType dts = this.getDataTransformationServicePortType(scope);
        FindApplicableTransformationUnits request = new FindApplicableTransformationUnits();
        ContentType srcContentTypeForSearch = new ContentType();
        srcContentTypeForSearch.setMimeType(srcMimeType);
        request.setSourceContentType(srcContentTypeForSearch);
        request.setTargetContentType(trgContentTypeForSearch);
        try {
            response = dts.findApplicableTransformationUnits(request);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception:", (Throwable)e);
            this.logger.error((Object)"Did not manage to search for applicable transformation units", (Throwable)e);
            throw new Exception("Did not manage to search for applicable transformation units", e);
        }
        if (response == null || response.getTPAndTransformationUnitIDs() == null || response.getTPAndTransformationUnitIDs().length == 0) {
            this.logger.info((Object)("Could not find transformation unit that creates thumbnail for src contenty type " + srcMimeType));
            return null;
        }
        TransformationUnit transformationUnit = new TransformationUnit();
        transformationUnit.setTransformationProgramID(response.getTPAndTransformationUnitIDs()[0].getTransformationProgramID());
        transformationUnit.setTransformationUnitID(response.getTPAndTransformationUnitIDs()[0].getTransformationUnitID());
        if (transformationUnit.getTransformationProgramID() == null || transformationUnit.getTransformationProgramID().trim().length() == 0 || transformationUnit.getTransformationUnitID() == null || transformationUnit.getTransformationUnitID().trim().length() == 0) {
            this.logger.warn((Object)"Got empty transformation program or unti id");
            return null;
        }
        this.logger.debug((Object)("Transformation unit (" + transformationUnit.getTransformationProgramID() + "/" + transformationUnit.getTransformationUnitID() + ")" + " found to create thumbnail for src mimetype: " + srcMimeType));
        return transformationUnit;
    }

    private DataTransformationServicePortType getDataTransformationServicePortType(String scope) throws Exception {
        return ThumbnailUtils.getDTSPortType(scope);
    }

    private GCubeDocument getDocumentDescription(String oid, String scope) throws Exception {
        return ThumbnailUtils.getDocumentDescription(oid, scope);
    }

    private boolean checkAlternativeRepresentation(String alternativeRepresentationOID, int width, int height, String[] thumbOptions, String scope) throws Exception {
        GCubeDocument documentDescription = this.getDocumentDescription(alternativeRepresentationOID, scope);
        if (documentDescription.mimeType() == null || !documentDescription.mimeType().equals("image/png")) {
            return false;
        }
        Map properties = documentDescription.properties();
        int wThumb = 0;
        int hThumb = 0;
        if (properties != null && properties.size() > 0) {
            Set propertiesNames = properties.keySet();
            for (String prop : propertiesNames) {
                this.logger.debug((Object)("Property - Name: " + prop + " - Value: " + ((GCubeElementProperty)properties.get(prop)).value() + " - Type: " + ((GCubeElementProperty)properties.get(prop)).type()));
                if (!((GCubeElementProperty)properties.get(prop)).type().equals("dts:contenttypeparameters")) continue;
                if (prop.equals("width")) {
                    wThumb = Integer.parseInt(((GCubeElementProperty)properties.get(prop)).value());
                }
                if (!prop.equals("height")) continue;
                hThumb = Integer.parseInt(((GCubeElementProperty)properties.get(prop)).value());
            }
        }
        if (wThumb == 0 || hThumb == 0) {
            return false;
        }
        boolean thOption = this.containOption(thumbOptions, "EQUAL");
        return thOption ? height == hThumb || width == wThumb : ((thOption = this.containOption(thumbOptions, "FLOOR")) ? height >= hThumb && width >= wThumb : (thOption = this.containOption(thumbOptions, "CEIL")) && height <= hThumb && width <= wThumb);
    }

    public String searchForExistingThumbnail(String srcObjectURI, int width, int height, String[] thumbOptions, String scope) throws Exception {
        URI uri = new URI(srcObjectURI);
        String collectionId = URIs.collectionID((URI)uri);
        String documentId = URIs.documentID((URI)uri);
        try {
            DocumentReader reader = new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            GCubeDocument doc = reader.get(documentId, (Projection)Projections.alternative());
            for (GCubeAlternative alternative : doc.alternatives()) {
                if (!alternative.type().equals("thumbnail") || !this.checkAlternativeRepresentation(alternative.id(), width, height, thumbOptions, scope)) continue;
                return alternative.id();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception:", (Throwable)e);
        }
        return null;
    }

    private byte[] getContentFromCMS(String oid, String scope) throws Exception {
        return ThumbnailUtils.getContentFromCMS(oid, scope);
    }

    private boolean containOption(String[] thumbOptions, String option) {
        for (int i = 0; i < thumbOptions.length; ++i) {
            if (!thumbOptions[i].equals(option)) continue;
            return true;
        }
        return false;
    }

    private String getMimeType(String oid, String scope) throws Exception {
        return ThumbnailUtils.getMimeType(oid, scope);
    }

    private void createThumbnail(String srcObjectID, TransformationUnit transformationUnit, int width, int height, String scope) throws Exception {
        DataTransformationServicePortType dts = this.getDataTransformationServicePortType(scope);
        TransformDataWithTransformationUnit request = new TransformDataWithTransformationUnit();
        Input input = new Input();
        input.setInputType("CObject");
        input.setInputValue(srcObjectID);
        Input[] inputs = new Input[]{input};
        request.setInputs(inputs);
        request.setCreateReport(false);
        request.setFilterSources(false);
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("image/png");
        Parameter paramw = new Parameter("width", String.valueOf(width));
        Parameter paramh = new Parameter("height", String.valueOf(height));
        Parameter[] ctParameters = new Parameter[]{paramw, paramh};
        targetContentType.setParameters(ctParameters);
        request.setTargetContentType(targetContentType);
        Output output = new Output();
        output.setOutputType("AlternativeRepresentation");
        Parameter altRepRole = new Parameter("RepresentationRole", "thumbnail");
        Parameter[] outputParameters = new Parameter[]{altRepRole};
        output.setOutputparameters(outputParameters);
        request.setOutput(output);
        request.setTransformationUnitID(transformationUnit.getTransformationUnitID());
        request.setTPID(transformationUnit.getTransformationProgramID());
        dts.transformDataWithTransformationUnit(request);
    }

    static {
        trgContentTypeForSearch.setMimeType("image/png");
        Parameter paramw = new Parameter("width", "*");
        Parameter paramh = new Parameter("height", "*");
        Parameter[] ctParameters = new Parameter[]{paramw, paramh};
        trgContentTypeForSearch.setParameters(ctParameters);
    }

    class TransformationUnit {
        private String transformationUnitID;
        private String transformationProgramID;

        TransformationUnit() {
        }

        public String getTransformationUnitID() {
            return this.transformationUnitID;
        }

        public void setTransformationUnitID(String transformationUnitID) {
            this.transformationUnitID = transformationUnitID;
        }

        public String getTransformationProgramID() {
            return this.transformationProgramID;
        }

        public void setTransformationProgramID(String transformationProgramID) {
            this.transformationProgramID = transformationProgramID;
        }
    }
}

