/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.datatransformation.util;

import java.net.URI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.application.framework.contentmanagement.exceptions.OCRException;
import org.gcube.application.framework.contentmanagement.exceptions.ReadingRSException;
import org.gcube.application.framework.contentmanagement.exceptions.ServiceEPRRetrievalException;
import org.gcube.application.framework.contentmanagement.exceptions.TransformationException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.cache.factories.ApplicationCredentials;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.datatransformation.datatransformationservice.stubs.ContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.Input;
import org.gcube.datatransformation.datatransformationservice.stubs.Output;
import org.gcube.datatransformation.datatransformationservice.stubs.Parameter;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformData;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.service.DataTransformationServiceAddressingLocator;
import org.gcube.execution.ocrservice.stubs.InputResource;
import org.gcube.execution.ocrservice.stubs.OCRServiceFactoryPortType;
import org.gcube.execution.ocrservice.stubs.OCRServicePortType;
import org.gcube.execution.ocrservice.stubs.StatusResponseType;
import org.gcube.execution.ocrservice.stubs.Submit;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceAddressingLocator;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceFactoryServiceAddressingLocator;
import org.gcube.informationsystem.cache.SrvType;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformationUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformationUtils.class);

    public static String transformPDFDocumentsToText(String listLocation, ArrayList<String> collectionId, String collectionName, String scope) throws ServiceEPRRetrievalException, TransformationException {
        TransformData request = new TransformData();
        Input input = new Input();
        input.setInputType("URIList");
        input.setInputValue(listLocation);
        logger.info("The URI Location IS: " + listLocation);
        request.setInput(input);
        Output output = new Output();
        output.setOutputType("Collection");
        output.setOutputValue(collectionId.get(0));
        Parameter outputParam = new Parameter();
        outputParam.setName("CollectionName");
        outputParam.setValue(collectionName);
        Parameter outputParam2 = new Parameter();
        outputParam2.setName("CollectionDesc");
        outputParam2.setValue("Collection of Text documents, created from PDFs.");
        Parameter outputParam3 = new Parameter();
        outputParam3.setName("isUserCollection");
        outputParam3.setValue("false");
        Parameter[] outputParams = new Parameter[]{outputParam, outputParam2, outputParam3};
        output.setOutputparameters(outputParams);
        request.setOutput(output);
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("text/plain");
        Parameter[] contentTypeParameters = new Parameter[]{};
        targetContentType.setParameters(contentTypeParameters);
        request.setTargetContentType(targetContentType);
        request.setCreateReport(true);
        DataTransformationServicePortType dts = null;
        try {
            dts = DataTransformationUtils.getDataTransformationServicePortType(scope);
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException(e);
        }
        String rslocator = null;
        String colId = null;
        try {
            TransformDataResponse response = dts.transformData(request);
            rslocator = response.getReportEPR();
            colId = response.getOutput();
            collectionId.clear();
            collectionId.add(0, colId);
        }
        catch (GCUBERetryEquivalentFault e) {
            throw new TransformationException(e);
        }
        catch (RemoteException e) {
            throw new TransformationException(e);
        }
        logger.info("Output: " + rslocator);
        return rslocator;
    }

    public static ArrayList<DocumentInfos> getListOfFailuresFromReport(String rsLocator, ArrayList<DocumentInfos> allDocuments, ArrayList<String> collectionId) throws ReadingRSException {
        RSXMLReader reader = DataTransformationUtils.getRSClient(rsLocator);
        RSXMLIterator iterator = null;
        ArrayList<DocumentInfos> listOfFailures = new ArrayList<DocumentInfos>();
        try {
            iterator = reader.getRSIterator();
        }
        catch (Exception e) {
            throw new ReadingRSException(e);
        }
        while (iterator.hasNext()) {
            ResultElementBase res = iterator.next(ResultElementGeneric.class);
            try {
                String report = res.RS_toXML();
                RecordAttribute[] tmp = res.getRecordAttributes("DocID");
                String sourceId = tmp[0].getAttrValue();
                tmp = res.getRecordAttributes("CollID");
                String colId = tmp[0].getAttrValue();
                collectionId.add(colId);
                boolean success = DataTransformationUtils.getStatusReport(report, sourceId);
                if (!success) {
                    DocumentInfos di = new DocumentInfos();
                    di = DataTransformationUtils.findDocumentInfosFromDocumentURI(allDocuments, sourceId);
                    listOfFailures.add(di);
                }
                logger.info("The REPORT for the document: " + sourceId + "is:" + report);
            }
            catch (Exception e) {
                throw new ReadingRSException(e);
            }
        }
        return listOfFailures;
    }

    public static ArrayList<DocumentInfos> getReports(String rsLocator, ArrayList<String> collectionId) throws ReadingRSException {
        RSXMLReader reader = DataTransformationUtils.getRSClient(rsLocator);
        RSXMLIterator iterator = null;
        ArrayList<DocumentInfos> listOfFailures = new ArrayList<DocumentInfos>();
        try {
            iterator = reader.getRSIterator();
        }
        catch (Exception e) {
            throw new ReadingRSException(e);
        }
        logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        logger.info("ITERATE RESULTSET");
        logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        int i = 0;
        while (iterator.hasNext()) {
            ++i;
            logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            logger.info("BEGINNING");
            logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            long startTime = System.currentTimeMillis();
            ResultElementBase res = iterator.next(ResultElementGeneric.class);
            long endTime = System.currentTimeMillis();
            long diff = endTime - startTime;
            logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            logger.info("THE DIFFERENCE IS: " + diff + " " + i);
            logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            try {
                String report = res.RS_toXML();
                RecordAttribute[] tmp = res.getRecordAttributes("DocID");
                String sourceId = tmp[0].getAttrValue();
                tmp = res.getRecordAttributes("CollID");
                String colId = tmp[0].getAttrValue();
                collectionId.add(colId);
                boolean success = DataTransformationUtils.getStatusReport(report, sourceId);
                if (!success) {
                    DocumentInfos di = new DocumentInfos();
                    di.setPdfURI(sourceId);
                    UUID uuid = UUID.randomUUID();
                    String randomUUIDString = uuid.toString();
                    di.setDocumentId(randomUUIDString);
                    listOfFailures.add(di);
                }
                logger.info("The REPORT for the document: " + sourceId + "is:" + report);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
                throw new ReadingRSException(e);
            }
        }
        logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        logger.info("FINISHED");
        logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        return listOfFailures;
    }

    private static DocumentInfos findDocumentInfosFromDocumentURI(ArrayList<DocumentInfos> allDocuments, String documentURI) {
        for (int i = 0; i < allDocuments.size(); ++i) {
            logger.info("Comparing: " + allDocuments.get(i).getPdfURI() + " with " + documentURI);
            if (!allDocuments.get(i).getPdfURI().equals(documentURI)) continue;
            return allDocuments.get(i);
        }
        return null;
    }

    private static boolean getStatusReport(String report, String sourceId) {
        logger.info("Getting report for document: " + sourceId);
        return !report.contains("<STATUS>FAILED</STATUS>");
    }

    protected static RSXMLReader getRSClient(String epr) throws ReadingRSException {
        RSXMLReader client = null;
        try {
            client = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(epr)).makeLocal((RSResourceType)new RSResourceLocalType());
        }
        catch (Exception e) {
            throw new ReadingRSException(e);
        }
        return client;
    }

    private static DataTransformationServicePortType getDataTransformationServicePortType(String scope) throws Exception {
        EndpointReference[] dtsURIs = null;
        try {
            dtsURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name());
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException(e);
        }
        Random random = new Random();
        String dtsAddress = dtsURIs[random.nextInt(dtsURIs.length)].getAddress().toString();
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress((AttributedURI)new Address(dtsAddress));
        DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
        DataTransformationServicePortType dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
        try {
            dts = (DataTransformationServicePortType)ServiceContextManager.applySecurity((Remote)dts, (GCUBEScope)GCUBEScope.getScope((String)scope), (GSSCredential)ApplicationCredentials.getInstance().getCredential(scope));
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            throw new ServiceEPRRetrievalException(e);
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException(e);
        }
        return dts;
    }

    public static ArrayList<String> performOCRtoPDF_HTTPInput(ArrayList<DocumentInfos> documents, String outputCollectionId, ASLSession session) throws ServiceEPRRetrievalException, OCRException {
        ArrayList<String> HocrOutputSSIDs = new ArrayList<String>();
        String ocrEPR = DataTransformationUtils.getOCRServiceEPR(session);
        EndpointReferenceType factoryEPR = new EndpointReferenceType();
        try {
            factoryEPR.setAddress((AttributedURI)new Address(ocrEPR));
        }
        catch (URI.MalformedURIException e) {
            logger.error("Exception:", (Throwable)e);
            throw new ServiceEPRRetrievalException(e);
        }
        OCRServiceFactoryPortType stub = null;
        try {
            stub = new OCRServiceFactoryServiceAddressingLocator().getOCRServiceFactoryPortTypePort(factoryEPR);
            stub = (OCRServiceFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)stub, (GCUBEScope)session.getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (ServiceException e) {
            logger.error("Exception:", (Throwable)e);
            throw new ServiceEPRRetrievalException(e);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new ServiceEPRRetrievalException(e);
        }
        int numDocs = 0;
        for (int i = 0; i < documents.size(); ++i) {
            OCRServicePortType stub2;
            InputResource input = new InputResource();
            logger.info("Printing...");
            if (documents.get(i) == null) {
                logger.info("IT IS NULL " + documents.size());
            }
            logger.info("The document id is: " + documents.get(i).getDocumentId() + " " + documents.get(i).getPdfURI());
            String documentId = documents.get(i).getDocumentId().trim();
            logger.info("Setting as name: " + documentId);
            String dirtyDID = documentId.replaceAll("/", "__");
            logger.info("Setting as name: " + dirtyDID);
            input.setResourceKey(dirtyDID);
            input.setResourceAccess("Reference");
            input.setResourceReference(documents.get(i).getPdfURI().trim());
            Submit sub = new Submit();
            sub.setInputResource(input);
            EndpointReferenceType resourceEPR = null;
            try {
                resourceEPR = stub.submit(sub).getEndpointReference();
            }
            catch (GCUBEUnrecoverableFault e) {
                logger.error("Exception:", (Throwable)e);
                throw new ServiceEPRRetrievalException(e);
            }
            catch (RemoteException e) {
                logger.error("Exception:", (Throwable)e);
                throw new ServiceEPRRetrievalException(e);
            }
            try {
                stub2 = new OCRServiceAddressingLocator().getOCRServicePortTypePort(resourceEPR);
                stub2 = (OCRServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)stub2, (GCUBEScope)session.getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            }
            catch (ServiceException e) {
                logger.error("Exception:", (Throwable)e);
                throw new ServiceEPRRetrievalException(e);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
                throw new ServiceEPRRetrievalException(e);
            }
            StatusResponseType status = null;
            int timeCounter = 0;
            do {
                try {
                    status = stub2.status(new VOID());
                    timeCounter += 10000;
                    Thread.sleep(10000L);
                }
                catch (GCUBEUnrecoverableFault e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (RemoteException e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.error("Exception:", (Throwable)e);
                }
            } while (!status.isCompleted() && timeCounter < 9000000);
            if (status.isCompleted()) {
                logger.info("Number of documents transformed: " + ++numDocs);
                HocrOutputSSIDs.add(status.getHocrOutputSSID());
                String error = status.getJoberrSSID();
                logger.info("The JOBERRSSID is: " + error);
                continue;
            }
            logger.info("Omitted transformation of document: " + documents.get(i).getPdfURI());
        }
        DocumentWriter cmWriter = null;
        DocumentReader cmReader = null;
        GCubeDocument doc = null;
        try {
            boolean first = true;
            cmWriter = new DocumentWriter(outputCollectionId, session.getScope());
            logger.info(String.valueOf(HocrOutputSSIDs.size()));
            for (int i = 0; i < HocrOutputSSIDs.size(); ++i) {
                if (HocrOutputSSIDs.get(i) == null) {
                    logger.info("CRY");
                } else {
                    logger.info("CRY NOT");
                }
                URI theUri = new URI(HocrOutputSSIDs.get(i).trim());
                String oid = URIs.documentID((URI)theUri);
                String colID = URIs.collectionID((URI)theUri);
                if (!first) continue;
                try {
                    cmReader = new DocumentReader(colID, session.getScope());
                    cmWriter = new DocumentWriter(outputCollectionId, session.getScope());
                }
                catch (Exception e) {
                    logger.error("Exception:", (Throwable)e);
                }
                doc = cmReader.get(oid, (Projection)Projections.document());
                GCubeDocument newDoc = new GCubeDocument();
                if (doc.bytestream() != null) {
                    newDoc.setBytestream(doc.bytestream());
                }
                if (doc.bytestreamURI() != null) {
                    newDoc.setBytestreamURI(doc.bytestreamURI());
                }
                if (doc.length() != null) {
                    newDoc.setLenght(doc.length());
                }
                if (doc.mimeType() != null) {
                    newDoc.setMimeType(doc.mimeType());
                }
                if (doc.name() != null) {
                    newDoc.setName(doc.name());
                }
                if (doc.type() != null) {
                    newDoc.setType(doc.type());
                }
                String myNewDocumentId = cmWriter.add(newDoc);
            }
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new OCRException(e);
        }
        return HocrOutputSSIDs;
    }

    private static String getOCRServiceEPR(ASLSession session) {
        EndpointReference[] ocrService = null;
        logger.info("Looking for an OCRService epr");
        try {
            ocrService = RIsManager.getInstance().getISCache(session.getScope()).getEPRsFor("Execution", "OCRService", SrvType.FACTORY.name());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (ocrService != null && ocrService.length > 0) {
            logger.info("The ocrService epr is: " + ocrService[0]);
            return ocrService[0].getAddress().toString();
        }
        logger.info("The ocrService epr is NULL");
        return null;
    }
}

