/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.content.impl;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Collection {
    static ISClient client;
    protected ASLSession session;
    protected String colID;
    protected static AtomicInteger cmsId;
    protected static AtomicInteger colMSId;
    private static final Logger logger;

    public Collection(ASLSession ses, String collectionId) {
        this.session = ses;
        this.colID = collectionId;
    }

    public static String getCollectionByName(String name, ASLSession ses) {
        ScopeProvider.instance.set(ses.getScope().toString());
        StatefulQuery query = TServiceFactory.readSource().withName(name).build();
        TReader treader = (TReader)TServiceFactory.reader().matching((Query)query).build();
        Stream treesReader = treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        if (!treesReader.hasNext()) {
            logger.info("Couldn't find collection with name: " + name);
            return null;
        }
        Tree t = (Tree)treesReader.next();
        String[] str = t.uri().toString().split("/");
        return str[2];
    }

    public static String createCollection(String collectionName, ASLSession ses, Boolean userCollection) {
        return null;
    }

    public static boolean deleteCollection(String collectionID, ASLSession ses) {
        return true;
    }

    public DigitalObject addMember(InputStream content, String objectID, String mimeType) {
        try {
            DigitalObject newDO = DigitalObject.createNewDigitalObject(this.colID, content, objectID, this.session, mimeType);
            return newDO;
        }
        catch (IOException e) {
            logger.info("Couldn't create a new instance of DigitalObjectTM!");
            return null;
        }
    }

    public void removeMember(String oid, String collectionId, ASLSession ses) {
    }

    public String[] getMemberIDs(String collectionId, ASLSession ses) {
        ScopeProvider.instance.set(ses.getScope().toString());
        StatefulQuery query = TServiceFactory.readSource().withId(this.colID).build();
        TReader treader = (TReader)TServiceFactory.reader().matching((Query)query).build();
        Stream treesReader = treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        ArrayList<String> idsList = new ArrayList<String>();
        while (treesReader.hasNext()) {
            idsList.add(((Tree)treesReader.next()).sourceId());
        }
        return (String[])idsList.toArray();
    }

    public ArrayList<DocumentInfos> getDocumentInfos(ASLSession session) {
        ScopeProvider.instance.set(session.getScope().toString());
        StatefulQuery query = TServiceFactory.readSource().withId(this.colID).build();
        TReader treader = (TReader)TServiceFactory.reader().matching((Query)query).build();
        Stream treesReader = treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        ArrayList<DocumentInfos> documentInfos = new ArrayList<DocumentInfos>();
        while (treesReader.hasNext()) {
            DocumentInfos docInfo = new DocumentInfos();
            Tree tree = (Tree)treesReader.next();
            docInfo.setDocumentId(tree.sourceId());
            documentInfos.add(docInfo);
        }
        return documentInfos;
    }

    public static String getCollectionName(String collectionID) {
        XQuery _query = ICFactory.queryFor(ServiceInstance.class);
        _query.addNamespace("tm", URI.create("http://gcube-system.org/namespaces/data/tm")).addCondition("$resource/Data/gcube:ServiceClass/text() eq 'DataAccess'").addCondition("$resource/Data/gcube:ServiceName/text() eq 'tree-manager-service'").addCondition("$resource/Data/tm:SourceId/text() eq '" + collectionID + "'").setResult("$resource/Data/tm:Name/text()");
        DiscoveryClient client = ICFactory.client();
        HashSet props = new HashSet(client.submit((org.gcube.resources.discovery.client.queries.api.Query)_query));
        return (String)props.iterator().next();
    }

    public static String getCollectionNameByID(String id) throws ResourceRegistryException {
        DataCollection colData = new DataCollection();
        colData.setID(id);
        colData.load(true);
        String colName = colData.getName();
        return colName;
    }

    public static String getCollectionName(String collectionID, String session) {
        ScopeProvider.instance.set(session);
        XQuery _query = ICFactory.queryFor(ServiceInstance.class);
        _query.addNamespace("tm", URI.create("http://gcube-system.org/namespaces/data/tm")).addCondition("$resource/Data/gcube:ServiceClass/text() eq 'DataAccess'").addCondition("$resource/Data/gcube:ServiceName/text() eq 'tree-manager-service'").addCondition("$resource/Data/tm:SourceId/text() eq '" + collectionID + "'").setResult("$resource/Data/tm:Name/text()");
        DiscoveryClient client = ICFactory.client();
        HashSet props = new HashSet(client.submit((org.gcube.resources.discovery.client.queries.api.Query)_query));
        return (String)props.iterator().next();
    }

    static {
        cmsId = new AtomicInteger(0);
        colMSId = new AtomicInteger(0);
        logger = LoggerFactory.getLogger(Collection.class);
    }
}

