/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.gcube.application.framework.contentmanagement.model.CollectionInfo;
import org.gcube.application.framework.core.util.SearchField;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEMCollectionQuery;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.scope.GCUBEScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindInfo {
    private static final Logger logger = LoggerFactory.getLogger(FindInfo.class);
    public static final String ALL = "ALL";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";

    public static CollectionInfo findCollectionInfo(String colID, List<CollectionInfo>[] collections) {
        if (collections != null) {
            for (int counter = 0; counter < collections.length; ++counter) {
                for (int c2 = 0; c2 < collections[counter].size(); ++c2) {
                    logger.info("compare: " + collections[counter].get(c2).getId() + " with: " + colID);
                    if (!collections[counter].get(c2).getId().equals(colID)) continue;
                    logger.info("equal!!");
                    return collections[counter].get(c2);
                }
            }
        } else {
            logger.info("No collections!!");
            return null;
        }
        logger.info("Null!!");
        return null;
    }

    public static CollectionInfo findCollectionInfoFromMetadata(String metadataColID, List<CollectionInfo>[] collections) {
        for (int counter = 0; counter < collections.length; ++counter) {
            for (int c2 = 1; c2 < collections[counter].size(); ++c2) {
                for (int c3 = 0; c3 < collections[counter].get(c2).getMetadataSize(); ++c3) {
                    if (!collections[counter].get(c2).getMetadataID(c3).equals(metadataColID)) continue;
                    return collections[counter].get(c2);
                }
            }
        }
        return null;
    }

    public static String getMCOIDFromISID(String MCISID, GCUBEScope scope) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEMCollectionQuery mcolQuery = (GCUBEMCollectionQuery)client.getQuery(GCUBEMCollectionQuery.class);
        AtomicCondition mcIDAtomicCondition = new AtomicCondition("/ID", MCISID);
        mcolQuery.addAtomicConditions(new AtomicCondition[]{mcIDAtomicCondition});
        logger.info("The query expression is: << " + mcolQuery.getExpression() + " >>");
        List results = client.execute((ISQuery)mcolQuery, scope);
        if (results != null && results.size() > 0) {
            return ((GCUBEMCollection)results.get(0)).getOID();
        }
        return null;
    }

    public static List<CollectionInfo> searchCollectionInfo(String term, String whereToSearch, List<CollectionInfo>[] collections) {
        term = (term = term.trim().toLowerCase()).startsWith("*") ? term.substring(1) : "(\\s|\\p{Punct})" + term;
        term = term.endsWith("*") ? term.substring(0, term.length() - 1) : term + "(\\s|\\p{Punct})";
        term = term.replaceAll("\\x2A", ".*");
        term = term.replaceAll("\\x3F", ".");
        Pattern pattern = Pattern.compile(term);
        boolean name = false;
        boolean descr = false;
        if (whereToSearch.equals(ALL)) {
            name = true;
            descr = true;
        } else if (whereToSearch.equals(NAME)) {
            name = true;
        } else if (whereToSearch.equals(DESCRIPTION)) {
            descr = true;
        }
        ArrayList<CollectionInfo> res = new ArrayList<CollectionInfo>();
        for (int counter = 0; counter < collections.length; ++counter) {
            for (int c2 = 0; c2 < collections[counter].size(); ++c2) {
                if (name && pattern.matcher(" " + collections[counter].get(c2).getName().toLowerCase() + " ").find()) {
                    res.add(collections[counter].get(c2));
                    continue;
                }
                if (!descr || !pattern.matcher(" " + collections[counter].get(c2).getDescription().toLowerCase() + " ").find()) continue;
                res.add(collections[counter].get(c2));
            }
        }
        return res;
    }

    public static int findCollectionSchema(String schemaName, CollectionInfo collection) {
        for (int counter = 0; counter < collection.getMetadataSize(); ++counter) {
            if (!collection.getSchema(counter).equals(schemaName)) continue;
            return counter;
        }
        return -1;
    }

    public static int findCollectionSchema(String schemaName, String schemaLanguage, CollectionInfo collection) {
        for (int counter = 0; counter < collection.getMetadataSize(); ++counter) {
            if (!collection.getSchema(counter).equals(schemaName) || !collection.getLanguage(counter).equals(schemaLanguage)) continue;
            return counter;
        }
        return -1;
    }

    public static int findCriterion(String name, String schemaName, HashMap<String, List<SearchField>> SchemaHashMap) {
        List<SearchField> schemaCriteria = SchemaHashMap.get(schemaName);
        for (int counter = 0; counter < schemaCriteria.size(); ++counter) {
            if (!schemaCriteria.get((int)counter).name.equals(name)) continue;
            return counter;
        }
        return -1;
    }

    public static HashMap<String, String> getCollectionNames(List<CollectionInfo>[] collections) {
        HashMap<String, String> collectionMap = new HashMap<String, String>();
        collectionMap = new HashMap();
        if (collections == null) {
            return collectionMap;
        }
        for (int i = 0; i < collections.length; ++i) {
            for (int k = 0; k < collections[i].size(); ++k) {
                for (int j = 0; j < collections[i].get(k).getMetadataSize(); ++j) {
                    collectionMap.put(collections[i].get(k).getMetadataID(j), collections[i].get(k).getName());
                }
                collectionMap.put(collections[i].get(k).getId(), collections[i].get(k).getName());
            }
        }
        return collectionMap;
    }
}

