/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.datatransformation.util;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.contentmanagement.exceptions.OCRException;
import org.gcube.application.framework.contentmanagement.exceptions.ReadingRSException;
import org.gcube.application.framework.contentmanagement.exceptions.ServiceEPRRetrievalException;
import org.gcube.application.framework.contentmanagement.exceptions.TransformationException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.ServiceType;
import org.gcube.application.framework.core.util.ServiceUtils;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.datatransformation.datatransformationservice.stubs.ContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.Input;
import org.gcube.datatransformation.datatransformationservice.stubs.Output;
import org.gcube.datatransformation.datatransformationservice.stubs.Parameter;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformData;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.service.DataTransformationServiceAddressingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformationUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformationUtils.class);

    public static String transformPDFDocumentsToText(String listLocation, ArrayList<String> collectionId, String collectionName, String scope) throws ServiceEPRRetrievalException, TransformationException {
        TransformData request = new TransformData();
        Input input = new Input();
        input.setInputType("URIList");
        input.setInputValue(listLocation);
        logger.info("The URI Location IS: " + listLocation);
        request.setInput(input);
        Output output = new Output();
        output.setOutputType("Collection");
        output.setOutputValue(collectionId.get(0));
        Parameter outputParam = new Parameter();
        outputParam.setName("CollectionName");
        outputParam.setValue(collectionName);
        Parameter outputParam2 = new Parameter();
        outputParam2.setName("CollectionDesc");
        outputParam2.setValue("Collection of Text documents, created from PDFs.");
        Parameter outputParam3 = new Parameter();
        outputParam3.setName("isUserCollection");
        outputParam3.setValue("false");
        Parameter[] outputParams = new Parameter[]{outputParam, outputParam2, outputParam3};
        output.setOutputparameters(outputParams);
        request.setOutput(output);
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("text/plain");
        Parameter[] contentTypeParameters = new Parameter[]{};
        targetContentType.setParameters(contentTypeParameters);
        request.setTargetContentType(targetContentType);
        request.setCreateReport(true);
        DataTransformationServicePortType dts = null;
        try {
            dts = DataTransformationUtils.getDataTransformationServicePortType(scope);
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException(e);
        }
        String rslocator = null;
        String colId = null;
        TransformDataResponse response = new TransformDataResponse();
        rslocator = response.getReportEPR();
        colId = response.getOutput();
        collectionId.clear();
        collectionId.add(0, colId);
        logger.info("Output: " + rslocator);
        return rslocator;
    }

    public static ArrayList<DocumentInfos> getListOfFailuresFromReport(String rsLocator, ArrayList<DocumentInfos> allDocuments, ArrayList<String> collectionId) throws ReadingRSException {
        RSXMLReader reader = DataTransformationUtils.getRSClient(rsLocator);
        RSXMLIterator iterator = null;
        ArrayList<DocumentInfos> listOfFailures = new ArrayList<DocumentInfos>();
        try {
            iterator = reader.getRSIterator();
        }
        catch (Exception e) {
            throw new ReadingRSException(e);
        }
        while (iterator.hasNext()) {
            ResultElementBase res = iterator.next(ResultElementGeneric.class);
            try {
                String report = res.RS_toXML();
                RecordAttribute[] tmp = res.getRecordAttributes("DocID");
                String sourceId = tmp[0].getAttrValue();
                tmp = res.getRecordAttributes("CollID");
                String colId = tmp[0].getAttrValue();
                collectionId.add(colId);
                boolean success = DataTransformationUtils.getStatusReport(report, sourceId);
                if (!success) {
                    DocumentInfos di = new DocumentInfos();
                    di = DataTransformationUtils.findDocumentInfosFromDocumentURI(allDocuments, sourceId);
                    listOfFailures.add(di);
                }
                logger.info("The REPORT for the document: " + sourceId + "is:" + report);
            }
            catch (Exception e) {
                throw new ReadingRSException(e);
            }
        }
        return listOfFailures;
    }

    public static ArrayList<DocumentInfos> getReports(String rsLocator, ArrayList<String> collectionId) throws ReadingRSException {
        RSXMLReader reader = DataTransformationUtils.getRSClient(rsLocator);
        RSXMLIterator iterator = null;
        ArrayList<DocumentInfos> listOfFailures = new ArrayList<DocumentInfos>();
        try {
            iterator = reader.getRSIterator();
        }
        catch (Exception e) {
            throw new ReadingRSException(e);
        }
        logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        logger.info("ITERATE RESULTSET");
        logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        int i = 0;
        while (iterator.hasNext()) {
            ++i;
            logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            logger.info("BEGINNING");
            logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            long startTime = System.currentTimeMillis();
            ResultElementBase res = iterator.next(ResultElementGeneric.class);
            long endTime = System.currentTimeMillis();
            long diff = endTime - startTime;
            logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            logger.info("THE DIFFERENCE IS: " + diff + " " + i);
            logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            try {
                String report = res.RS_toXML();
                RecordAttribute[] tmp = res.getRecordAttributes("DocID");
                String sourceId = tmp[0].getAttrValue();
                tmp = res.getRecordAttributes("CollID");
                String colId = tmp[0].getAttrValue();
                collectionId.add(colId);
                boolean success = DataTransformationUtils.getStatusReport(report, sourceId);
                if (!success) {
                    DocumentInfos di = new DocumentInfos();
                    di.setPdfURI(sourceId);
                    UUID uuid = UUID.randomUUID();
                    String randomUUIDString = uuid.toString();
                    di.setDocumentId(randomUUIDString);
                    listOfFailures.add(di);
                }
                logger.info("The REPORT for the document: " + sourceId + "is:" + report);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
                throw new ReadingRSException(e);
            }
        }
        logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        logger.info("FINISHED");
        logger.info("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        return listOfFailures;
    }

    private static DocumentInfos findDocumentInfosFromDocumentURI(ArrayList<DocumentInfos> allDocuments, String documentURI) {
        for (int i = 0; i < allDocuments.size(); ++i) {
            logger.info("Comparing: " + allDocuments.get(i).getPdfURI() + " with " + documentURI);
            if (!allDocuments.get(i).getPdfURI().equals(documentURI)) continue;
            return allDocuments.get(i);
        }
        return null;
    }

    private static boolean getStatusReport(String report, String sourceId) {
        logger.info("Getting report for document: " + sourceId);
        return !report.contains("<STATUS>FAILED</STATUS>");
    }

    protected static RSXMLReader getRSClient(String epr) throws ReadingRSException {
        RSXMLReader client = null;
        try {
            client = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(epr)).makeLocal((RSResourceType)new RSResourceLocalType());
        }
        catch (Exception e) {
            throw new ReadingRSException(e);
        }
        return client;
    }

    private static DataTransformationServicePortType getDataTransformationServicePortType(String scope) throws Exception {
        String dtsAddress;
        try {
            dtsAddress = ServiceUtils.getEprAddressOfService((String)"DataTransformation", (String)"DataTransformationService", (String)ServiceType.SIMPLE.name(), (String)scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress((AttributedURI)new Address(dtsAddress));
        DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
        DataTransformationServicePortType dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
        return dts;
    }

    public static ArrayList<String> performOCRtoPDF_HTTPInput(ArrayList<DocumentInfos> documents, String outputCollectionId, ASLSession session) throws ServiceEPRRetrievalException, OCRException {
        return new ArrayList<String>();
    }

    private static String getOCRServiceEPR(ASLSession session) {
        String ocrService = null;
        logger.info("Looking for an OCRService epr");
        try {
            ocrService = ServiceUtils.getEprAddressOfService((String)"Execution", (String)"OCRService", (String)ServiceType.FACTORY.name(), (String)session.getScope());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (ocrService == null || ocrService.isEmpty()) {
            logger.info("The ocrService epr is NULL");
            return null;
        }
        logger.info("The ocrService epr is: " + ocrService);
        return ocrService;
    }
}

