/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.util;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.apache.xpath.XPathAPI;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.cache.factories.GenericResourceCacheEntryFactory;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.PresentableFieldInfo;
import org.gcube.application.framework.search.library.model.SearchableFieldInfo;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FindFieldsInfo {
    public static final String ALL = "ALL";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    protected static final GCUBELog logger = new GCUBELog(FindFieldsInfo.class);
    public static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();

    public static HashMap<CollectionInfo, ArrayList<CollectionInfo>> joinDynamicAndStaticConfiguration(String scope, boolean refresh) {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> collectionHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
        ArrayList<CollectionInfo> allCollections = FindFieldsInfo.retrieveCollectionsFieldsInfos(scope);
        if (allCollections == null || allCollections.size() == 0) {
            logger.debug((Object)"No available collections returned from Registry!");
            return collectionHierarchy;
        }
        try {
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = FindFieldsInfo.retrieveCollectionsInformation(scope, allCollections, refresh);
            return colHierarchy;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<CollectionInfo> retrieveCollectionsFieldsInfos(String scope) {
        try {
            ResourceRegistry.startBridging();
        }
        catch (ResourceRegistryException e1) {
            e1.printStackTrace();
        }
        List flds = null;
        try {
            flds = DataCollection.getCollectionsOfScope((boolean)true, (String)scope);
        }
        catch (ResourceRegistryException e1) {
            e1.printStackTrace();
        }
        ArrayList<CollectionInfo> colInfos = new ArrayList<CollectionInfo>();
        logger.debug((Object)("Finding collection infos - number of collections: " + flds.size()));
        for (int c = 0; c < flds.size(); ++c) {
            block26: {
                DataCollection myCollection = (DataCollection)flds.get(c);
                boolean fts = false;
                boolean geospatial = false;
                boolean searchable = true;
                boolean language = false;
                boolean sortable = false;
                String ftsId = new String();
                Vector languages = new Vector();
                logger.debug((Object)("******************************************** START PROCEDURE *******************************" + c));
                logger.debug((Object)("Name of collection: " + myCollection.getName() + " id: " + myCollection.getID()));
                try {
                    HashSet<String> capabilities = new HashSet<String>();
                    capabilities.add("=");
                    capabilities.add("=");
                    logger.debug((Object)("Trying to find searchable fields- id: " + myCollection.getID()));
                    List fs = Field.getSearchableFieldsOfCollectionByCapabilities((boolean)true, (String)myCollection.getID(), capabilities);
                    logger.debug((Object)("Finding Field Infos - number of searchable fields: " + fs.size()));
                    ArrayList<org.gcube.application.framework.search.library.model.Field> fields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                    for (int i = 0; i < fs.size(); ++i) {
                        sortable = false;
                        logger.debug((Object)("Name of Field: " + ((Field)fs.get(i)).getName()));
                        org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                        inField.setDescription(((Field)fs.get(i)).getDescription());
                        inField.setId(((Field)fs.get(i)).getID());
                        inField.setLabel(((Field)fs.get(i)).getName());
                        inField.setName(((Field)fs.get(i)).getName());
                        if (((Field)fs.get(i)).getName().equals("allIndexes")) {
                            ftsId = ((Field)fs.get(i)).getID();
                            logger.debug((Object)("Found allFields: " + ((Field)fs.get(i)).getID()));
                            inField.setName("Any");
                            fts = true;
                        }
                        Set searchables = ((Field)fs.get(i)).getSearchables();
                        for (Searchable se : searchables) {
                            SearchableFieldInfo sfi = new SearchableFieldInfo();
                            sfi.setCollectionId(se.getCollection());
                            sfi.setFieldName(se.getField());
                            sfi.setId(se.getID());
                            sfi.setSortable(se.isOrder());
                            Set caps = se.getCapabilities();
                            sfi.setIndexCapabilities(caps);
                            inField.addSearchable(sfi);
                            if (!sfi.getCollectionId().equals(((Field)fs.get(i)).getID()) || !sfi.isSortable()) continue;
                            sortable = true;
                        }
                        Set presentables = ((Field)fs.get(i)).getPresentables();
                        for (Presentable pr : presentables) {
                            PresentableFieldInfo pfi = new PresentableFieldInfo();
                            pfi.setCollectionId(pr.getCollection());
                            pfi.setFieldName(pr.getField());
                            pfi.setId(pr.getID());
                            pfi.setSortable(pr.isOrder());
                            Set pres = pr.getPresentationInfo();
                            pfi.setPresentationInfo(pres);
                            inField.addPresentable(pfi);
                        }
                        inField.setSearchable(searchable);
                        inField.setSortable(sortable);
                        ArrayList<String> commonCaps = new ArrayList<String>();
                        if (inField.getSearchableFields() != null && inField.getSearchableFields().size() > 0) {
                            commonCaps.addAll(inField.getSearchableFields().get(0).getIndexCapabilities());
                        }
                        ArrayList<String> duplicated = commonCaps;
                        for (int s = 1; s < inField.getSearchableFields().size(); ++s) {
                            for (int cc = 0; cc < commonCaps.size(); ++cc) {
                                if (inField.getSearchableFields().get(s).getIndexCapabilities().contains(commonCaps.get(cc)) || !duplicated.contains(commonCaps.get(cc))) continue;
                                int ind = commonCaps.indexOf(commonCaps.get(cc));
                                duplicated.remove(ind);
                            }
                        }
                        commonCaps = duplicated;
                        inField.setIndexCapabilities(commonCaps);
                        fields.add(inField);
                    }
                    capabilities = new HashSet();
                    capabilities.add("geosearch");
                    logger.debug((Object)("Trying to find Geo relation- id: " + myCollection.getID()));
                    List geoF = Field.getSearchableFieldsOfCollectionByCapabilities((boolean)true, (String)myCollection.getID(), capabilities);
                    org.gcube.application.framework.search.library.model.Field geoField = new org.gcube.application.framework.search.library.model.Field();
                    if (geoF != null && geoF.size() != 0) {
                        language = true;
                        geospatial = true;
                        geoField.setId(((Field)geoF.get(0)).getID());
                        geoField.setDescription(((Field)geoF.get(0)).getDescription());
                        geoField.setLabel(((Field)geoF.get(0)).getName());
                        geoField.setName(((Field)geoF.get(0)).getName());
                    } else {
                        logger.debug((Object)("No geo!- id: " + myCollection.getID()));
                    }
                    ArrayList<String> allLanguages = new ArrayList<String>();
                    logger.debug((Object)("getting languages - id: " + myCollection.getID()));
                    logger.debug((Object)myCollection.getID());
                    DataLanguage dataLanguage = DataLanguage.getLanguages((String)myCollection.getID());
                    if (dataLanguage != null) {
                        logger.debug((Object)("dataLangs " + myCollection.getName()));
                        HashMap fieldLanguages = dataLanguage.getFieldLanguages();
                        logger.debug((Object)("Number of languages: " + fieldLanguages.size() + " " + myCollection.getName() + " " + fields.size()));
                        for (String fl : fieldLanguages.keySet()) {
                            logger.debug((Object)("KeyIs: " + fl + " " + myCollection.getName()));
                        }
                        for (int i = 0; i < fields.size(); ++i) {
                            Set langs = (Set)fieldLanguages.get(((org.gcube.application.framework.search.library.model.Field)fields.get(i)).getId());
                            if (langs != null) {
                                logger.debug((Object)("field langs: " + langs.size() + " " + ((org.gcube.application.framework.search.library.model.Field)fields.get(i)).getId() + myCollection.getName()));
                                for (String lang : langs) {
                                    ((org.gcube.application.framework.search.library.model.Field)fields.get(i)).addLanguage(lang);
                                    if (allLanguages.contains(lang)) continue;
                                    allLanguages.add(lang);
                                }
                                continue;
                            }
                            logger.debug((Object)("field langs NO " + ((org.gcube.application.framework.search.library.model.Field)fields.get(i)).getId() + myCollection.getName()));
                        }
                        Set langs = (Set)fieldLanguages.get(geoField.getId());
                        if (langs != null) {
                            for (String lang : langs) {
                                geoField.addLanguage(lang);
                                if (allLanguages.contains(lang)) continue;
                                allLanguages.add(lang);
                            }
                        }
                        language = true;
                    } else {
                        logger.debug((Object)("DataLanguages map is null! " + myCollection.getID()));
                    }
                    logger.debug((Object)("Trying to find Presentation Fields - id: " + myCollection.getID()));
                    List prFs = Field.getPresentableFieldsOfCollection((boolean)true, (String)myCollection.getID());
                    logger.debug((Object)("Finding Presentation Field infor - number of presentation fields: " + prFs.size()));
                    ArrayList<org.gcube.application.framework.search.library.model.Field> prFields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                    for (int i = 0; i < prFs.size(); ++i) {
                        logger.debug((Object)("Name of presentation field: " + ((Field)prFs.get(i)).getName()));
                        org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                        inField.setDescription(((Field)prFs.get(i)).getDescription());
                        inField.setId(((Field)prFs.get(i)).getID());
                        inField.setLabel(((Field)prFs.get(i)).getName());
                        inField.setName(((Field)prFs.get(i)).getName());
                        prFields.add(inField);
                    }
                    logger.debug((Object)("Trying to find browsable fields - id: " + myCollection.getID()));
                    List brFs = Field.getBrowsableFieldsOfCollection((boolean)true, (String)myCollection.getID());
                    logger.debug((Object)("Finding Browasable Fields - number of browsable fields: " + brFs.size()));
                    ArrayList<org.gcube.application.framework.search.library.model.Field> brFields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                    for (int i = 0; i < brFs.size(); ++i) {
                        logger.debug((Object)("Name of browsable field: " + ((Field)brFs.get(i)).getName()));
                        org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                        inField.setDescription(((Field)brFs.get(i)).getDescription());
                        inField.setId(((Field)brFs.get(i)).getID());
                        inField.setLabel(((Field)brFs.get(i)).getName());
                        inField.setName(((Field)brFs.get(i)).getName());
                        language = true;
                        brFields.add(inField);
                    }
                    if (!language) break block26;
                    CollectionInfo colInfo = new CollectionInfo();
                    colInfo.setCollectionGroup(false);
                    colInfo.setDescription(myCollection.getDescription());
                    colInfo.setName(myCollection.getName());
                    logger.debug((Object)("Item name: " + myCollection.getName()));
                    colInfo.setId(myCollection.getID());
                    logger.debug((Object)("Item id: " + myCollection.getID()));
                    colInfo.setIndices(fields);
                    colInfo.setFts(fts);
                    colInfo.setGeospatial(geospatial);
                    colInfo.setLanguages(allLanguages);
                    colInfo.setPresentationFields(prFields);
                    colInfo.setBrowsableFields(brFields);
                    colInfo.setFtsId(ftsId);
                    colInfo.setGeospatialField(geoField);
                    logger.debug((Object)("Set fts id: " + ftsId));
                    logger.debug((Object)("Adding COLLECTION: " + colInfo.getName()));
                    colInfos.add(colInfo);
                }
                catch (ResourceRegistryException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            logger.debug((Object)"******************************************** END PROCEDURE *******************************");
        }
        logger.debug((Object)("Number of colINFOS: " + colInfos.size()));
        return colInfos;
    }

    protected static HashMap<CollectionInfo, ArrayList<CollectionInfo>> retrieveCollectionsInformation(String vre, List<CollectionInfo> collections, boolean refresh) throws Exception {
        List scenarioSchemaInfo;
        logger.debug((Object)"About to retrieve the static configuration");
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)vre);
        query.put((Object)"name", (Object)"ScenarioCollectionInfo");
        if (refresh) {
            CachesManager.getInstance().getEhcache("genericResources", (CacheEntryFactory)new GenericResourceCacheEntryFactory()).get((Serializable)query).setTimeToLive(-1);
        }
        if ((scenarioSchemaInfo = (List)((Object)CachesManager.getInstance().getEhcache("genericResources", (CacheEntryFactory)new GenericResourceCacheEntryFactory()).get((Serializable)query).getValue())) == null || scenarioSchemaInfo.size() == 0) {
            logger.debug((Object)"The scenarioCollectionInfo is null");
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
            return colHierarchy;
        }
        logger.debug((Object)"Printing the static configuration");
        logger.debug((Object)((ISGenericResource)scenarioSchemaInfo.get(0)).getBody());
        InputSource in = new InputSource(new StringReader(((ISGenericResource)scenarioSchemaInfo.get(0)).getBody()));
        Document doc = dfactory.newDocumentBuilder().parse(in);
        FindFieldsInfo.retrieveCollections(doc, collections);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = FindFieldsInfo.retrieveCollectionHierarchy(vre, doc, collections);
        return colHierarchy;
    }

    public static String findCollectionName(String id, String scope) {
        try {
            List collections = DataCollection.getCollectionsOfScope((boolean)true, (String)scope);
            for (int i = 0; i < collections.size(); ++i) {
                if (!((DataCollection)collections.get(i)).getID().equals(id)) continue;
                return ((DataCollection)collections.get(i)).getName();
            }
        }
        catch (ResourceRegistryException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static void retrieveCollections(Document doc, List<CollectionInfo> collections) {
        CollectionInfo colInfo;
        String val;
        int i;
        ArrayList<CollectionInfo> availableCollections = new ArrayList<CollectionInfo>();
        NodeList res = doc.getElementsByTagName("collection");
        int n = res.getLength();
        logger.debug((Object)("Retrieving Static Configuration: The number of collections is: " + n));
        for (i = 0; i < n; ++i) {
            val = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
            logger.debug((Object)("The id of the collection read is: " + val));
            colInfo = null;
            colInfo = FindFieldsInfo.getCollectionInfoById(val, collections);
            if (colInfo == null) {
                logger.debug((Object)"Not available collection - omitting it");
                continue;
            }
            logger.debug((Object)"Printing collection Information gathered: ");
            logger.debug((Object)colInfo.getName());
            logger.debug((Object)colInfo.getId());
            if (colInfo.getIndices() != null) {
                logger.debug((Object)colInfo.getIndices().size());
            }
            if (colInfo.getLanguages() != null) {
                logger.debug((Object)colInfo.getLanguages().size());
            }
            logger.debug((Object)"end");
            val = res.item(i).getAttributes().getNamedItem("description").getNodeValue();
            colInfo.setDescription(val);
            val = res.item(i).getAttributes().getNamedItem("recno").getNodeValue();
            colInfo.setRecno(val);
            val = res.item(i).getAttributes().getNamedItem("creationDate").getNodeValue();
            colInfo.setCreationDate(val);
            availableCollections.add(colInfo);
        }
        collections.clear();
        for (CollectionInfo col : availableCollections) {
            collections.add(col);
        }
        res = doc.getElementsByTagName("collectionsGroup");
        logger.debug((Object)("CollectionsGroup size: " + n));
        n = res.getLength();
        for (i = 0; i < n; ++i) {
            colInfo = new CollectionInfo();
            try {
                val = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
                colInfo.setId(val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                val = res.item(i).getAttributes().getNamedItem("name").getNodeValue();
                colInfo.setName(val);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                val = res.item(i).getAttributes().getNamedItem("description").getNodeValue();
                colInfo.setDescription(val);
            }
            catch (Exception e) {
                // empty catch block
            }
            colInfo.setCollectionGroup(true);
            collections.add(colInfo);
        }
        logger.debug((Object)("***Number of collections:" + collections.size()));
    }

    protected static HashMap<CollectionInfo, ArrayList<CollectionInfo>> retrieveCollectionHierarchy(String VREname, Document doc, List<CollectionInfo> collections) throws Exception {
        NodeList res = XPathAPI.selectNodeList((Node)doc, (String)"//VRE");
        res = XPathAPI.selectNodeList((Node)doc, (String)"//collectionsGroup");
        int n = res.getLength();
        logger.debug((Object)("***** number of collection groups:" + n + "*******"));
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
        HashMap<String, ArrayList<CollectionInfo>> groupIDsCollections = new HashMap<String, ArrayList<CollectionInfo>>();
        for (int i = 0; i < n; ++i) {
            String val = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
            NodeList res2 = XPathAPI.selectNodeList((Node)doc, (String)("//collectionsGroup[@id=\"" + val + "\"]/collection"));
            CollectionInfo colInfoGroup = FindFieldsInfo.getCollectionInfoById(val, collections);
            if (colInfoGroup != null) {
                for (int j = 0; j < res2.getLength(); ++j) {
                    CollectionInfo colInfo = FindFieldsInfo.getCollectionInfoById(res2.item(j).getAttributes().getNamedItem("id").getNodeValue(), collections);
                    if (colInfo == null) continue;
                    ArrayList<CollectionInfo> groupCollections = (ArrayList<CollectionInfo>)groupIDsCollections.get(colInfoGroup.getId());
                    if (groupCollections == null) {
                        groupCollections = new ArrayList<CollectionInfo>();
                    }
                    groupCollections.add(colInfo);
                    groupIDsCollections.put(colInfoGroup.getId(), groupCollections);
                }
                if (groupIDsCollections.get(colInfoGroup.getId()) != null) {
                    colHierarchy.put(colInfoGroup, (ArrayList<CollectionInfo>)groupIDsCollections.get(colInfoGroup.getId()));
                }
            }
            if (groupIDsCollections != null && colInfoGroup != null) {
                if (groupIDsCollections.get(colInfoGroup.getId()) == null) continue;
                logger.debug((Object)("***collection group " + i + " contains " + ((ArrayList)groupIDsCollections.get(colInfoGroup.getId())).size() + " collections***"));
                continue;
            }
            logger.debug((Object)"No Available Collections Returned from Registry.");
        }
        return colHierarchy;
    }

    protected static CollectionInfo getCollectionInfoById(String colId, List<CollectionInfo> collections) {
        CollectionInfo colInfo = null;
        int n = collections.size();
        for (int i = 0; i < n; ++i) {
            logger.debug((Object)("*******" + collections.get(i).getId() + " vs. " + colId));
            if (!collections.get(i).getId().equals(colId)) continue;
            colInfo = collections.get(i);
            logger.debug((Object)"***collection found****");
            break;
        }
        return colInfo;
    }

    public static ArrayList<org.gcube.application.framework.search.library.model.Field> getCollectionPresentationFields(String colId, ASLSession session) {
        SearchHelper sh = new SearchHelper(session);
        CollectionInfo colI = sh.findCollectionInfo(colId);
        ArrayList<org.gcube.application.framework.search.library.model.Field> fields = colI.getPresentationFields();
        return fields;
    }

    public static CollectionInfo findCollectionInfo(String colID, HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections) {
        if (collections != null) {
            for (CollectionInfo colInfo : collections.keySet()) {
                for (int c2 = 0; c2 < collections.get(colInfo).size(); ++c2) {
                    System.out.println("compare: " + collections.get(colInfo).get(c2).getId() + " with: " + colID);
                    if (!collections.get(colInfo).get(c2).getId().equals(colID)) continue;
                    System.out.println("equal!!");
                    return collections.get(colInfo).get(c2);
                }
            }
        } else {
            System.out.println("No collections!!");
            return null;
        }
        System.out.println("Null!!");
        return null;
    }

    public static List<CollectionInfo> searchCollectionInfo(String term, String whereToSearch, HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections) {
        term = (term = term.trim().toLowerCase()).startsWith("*") ? term.substring(1) : "(\\s|\\p{Punct})" + term;
        term = term.endsWith("*") ? term.substring(0, term.length() - 1) : term + "(\\s|\\p{Punct})";
        term = term.replaceAll("\\x2A", ".*");
        term = term.replaceAll("\\x3F", ".");
        Pattern pattern = Pattern.compile(term);
        boolean name = false;
        boolean descr = false;
        if (whereToSearch.equals(ALL)) {
            name = true;
            descr = true;
        } else if (whereToSearch.equals(NAME)) {
            name = true;
        } else if (whereToSearch.equals(DESCRIPTION)) {
            descr = true;
        }
        ArrayList<CollectionInfo> res = new ArrayList<CollectionInfo>();
        for (CollectionInfo colInfo : collections.keySet()) {
            for (int c2 = 0; c2 < collections.get(colInfo).size(); ++c2) {
                if (name && pattern.matcher(" " + collections.get(colInfo).get(c2).getName().toLowerCase() + " ").find()) {
                    res.add(collections.get(colInfo).get(c2));
                    continue;
                }
                if (!descr || !pattern.matcher(" " + collections.get(colInfo).get(c2).getDescription().toLowerCase() + " ").find()) continue;
                res.add(collections.get(colInfo).get(c2));
            }
        }
        return res;
    }
}

