/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.cache;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.util.FindFieldsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsFieldsCache {
    private static final Logger logger = LoggerFactory.getLogger(CollectionsFieldsCache.class);
    protected static Thread thread = new CleanCacheThread();
    protected static CollectionsFieldsCache collectionsFieldsCache = new CollectionsFieldsCache();
    protected HashMap<String, HashMap<CollectionInfo, ArrayList<CollectionInfo>>> scopesInfosCache = new HashMap();

    protected CollectionsFieldsCache() {
        thread.setDaemon(true);
        thread.start();
    }

    public static CollectionsFieldsCache getInstance() {
        return collectionsFieldsCache;
    }

    public HashMap<CollectionInfo, ArrayList<CollectionInfo>> getCollectionsInfoForScope(String scope, boolean refresh) throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> info = this.scopesInfosCache.get(scope);
        if (info == null || info.size() == 0) {
            info = FindFieldsInfo.joinDynamicAndStaticConfiguration(scope, refresh);
            this.scopesInfosCache.put(scope, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<CollectionInfo, ArrayList<CollectionInfo>> refreshCollectionInfoForScope(String scope, boolean refresh) throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> info = FindFieldsInfo.joinDynamicAndStaticConfiguration(scope, refresh);
        CollectionsFieldsCache collectionsFieldsCache = this;
        synchronized (collectionsFieldsCache) {
            CollectionsFieldsCache.collectionsFieldsCache.scopesInfosCache.put(scope, info);
        }
        return info;
    }

    protected void finalize() throws Throwable {
        thread.interrupt();
        logger.info(new Date(System.currentTimeMillis()) + " clean thread was interrupted");
        thread.join();
        logger.info(new Date(System.currentTimeMillis()) + " clean thread was joint");
        super.finalize();
    }

    protected static class CleanCacheThread
    extends Thread {
        protected CleanCacheThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(3600000L);
                }
                catch (InterruptedException e) {
                    logger.error("Exception:", (Throwable)e);
                    logger.info(new Date(System.currentTimeMillis()) + " clean thread was interrupted (in clean thread)");
                    break;
                }
                Set<String> keys = CollectionsFieldsCache.collectionsFieldsCache.scopesInfosCache.keySet();
                HashMap<String, HashMap<CollectionInfo, ArrayList<CollectionInfo>>> tempMap = new HashMap<String, HashMap<CollectionInfo, ArrayList<CollectionInfo>>>();
                for (String scope : keys) {
                    try {
                        HashMap<CollectionInfo, ArrayList<CollectionInfo>> info = FindFieldsInfo.joinDynamicAndStaticConfiguration(scope, false);
                        tempMap.put(scope, info);
                    }
                    catch (InitialBridgingNotCompleteException e) {
                        logger.error("Exception: ", (Throwable)e);
                    }
                    catch (InternalErrorException e) {
                        logger.error("Exception: ", (Throwable)e);
                    }
                }
                CleanCacheThread cleanCacheThread = this;
                synchronized (cleanCacheThread) {
                    CollectionsFieldsCache.collectionsFieldsCache.scopesInfosCache = tempMap;
                }
            }
            logger.info(new Date(System.currentTimeMillis()) + " clean thread was terminated");
        }
    }
}

