/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.impl;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.search.library.cache.CollectionsFieldsCache;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.NoAvailableCollectionsFoundException;
import org.gcube.application.framework.search.library.interfaces.SearchInfoI;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Query;
import org.gcube.application.framework.search.library.model.QueryGroup;
import org.gcube.application.framework.search.library.util.FindFieldsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchHelper
implements SearchInfoI {
    ASLSession session;
    private static final Logger logger = LoggerFactory.getLogger(SearchHelper.class);
    public static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();

    public SearchHelper(String username, String extSessionID) {
        this.session = SessionManager.getInstance().getASLSession(extSessionID, username);
        if (this.session.getAttribute("Queries") == null) {
            ArrayList<QueryGroup> qGroup = new ArrayList<QueryGroup>();
            ArrayList<Query> queries = new ArrayList<Query>();
            queries.add(new Query());
            qGroup.add(new QueryGroup(queries));
            this.session.setAttribute("Queries", qGroup);
        }
    }

    public SearchHelper(ASLSession session) {
        this.session = session;
        if (session.getAttribute("Queries") == null) {
            ArrayList<QueryGroup> qGroup = new ArrayList<QueryGroup>();
            ArrayList<Query> queries = new ArrayList<Query>();
            queries.add(new Query());
            qGroup.add(new QueryGroup(queries));
            session.setAttribute("Queries", qGroup);
        }
    }

    public List<QueryGroup> getAllQueries() {
        return (List)this.session.getAttribute("Queries");
    }

    public HashMap<CollectionInfo, ArrayList<CollectionInfo>> getAvailableCollections() throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = (HashMap<CollectionInfo, ArrayList<CollectionInfo>>)this.session.getAttribute("collectionsHierarchy" + this.session.getScopeName());
        if (collections == null) {
            logger.debug("The collections in session are null - get them from the cache");
            collections = CollectionsFieldsCache.getInstance().getCollectionsInfoForScope(this.session.getScopeName(), false);
            this.session.setAttribute("collectionsHierarchy" + this.session.getScopeName(), collections);
        } else {
            logger.debug("The collections in session are NOT null");
        }
        return collections;
    }

    public ArrayList<String> getExternalCollections() throws InitialBridgingNotCompleteException, InternalErrorException {
        ArrayList<String> externals = new ArrayList<String>();
        try {
            Set collections = QueryHelper.getExternalCollectionsOfScope((String)this.session.getScopeName());
            for (DataCollection col : collections) {
                CollectionInfo colInfo = this.findCollectionInfo(col.getID());
                if (colInfo == null) continue;
                externals.add(col.getID());
            }
        }
        catch (ResourceRegistryException e) {
            logger.error("An error occured while retrieving external collections from Registry", (Throwable)e);
            throw new InternalErrorException(e.getCause());
        }
        return externals;
    }

    public ArrayList<CollectionInfo> getExternalCollectionInfos() throws InitialBridgingNotCompleteException, InternalErrorException {
        ArrayList<CollectionInfo> externals = new ArrayList<CollectionInfo>();
        try {
            Set collections = QueryHelper.getExternalCollectionsOfScope((String)this.session.getScopeName());
            for (DataCollection col : collections) {
                CollectionInfo colInfo = this.findCollectionInfo(col.getID());
                if (colInfo == null) continue;
                externals.add(colInfo);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error("An error occured while retrieving external collections from Registry", (Throwable)e);
            throw new InternalErrorException(e.getCause());
        }
        return externals;
    }

    public QueryGroup getQuery(int qid) {
        return (QueryGroup)((List)this.session.getAttribute("Queries")).get(qid);
    }

    public int addQuery(QueryGroup query) {
        ((List)this.session.getAttribute("Queries")).add(query);
        return ((List)this.session.getAttribute("Queries")).size() - 1;
    }

    public void removeQuery(int qid) {
        ((List)this.session.getAttribute("Queries")).remove(qid);
    }

    public int createQuery(int qid, boolean ... previous) {
        List<Query> queries = this.getQuery(qid).getQueries();
        ArrayList<Query> queries2 = new ArrayList<Query>(queries.size());
        boolean pre = previous != null && previous.length > 0 ? previous[0] : false;
        Query query = null;
        try {
            query = queries.get(0).clone(pre);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            query = new Query();
        }
        if (queries.size() > 1) {
            ArrayList<String> newCollections = new ArrayList<String>();
            for (int i = 0; i < queries.size(); ++i) {
                for (String x : queries.get(i).getSelectedCollections()) {
                    String y = new String(x);
                    newCollections.add(y);
                }
            }
            query.selectCollections(newCollections, true, this.session);
        }
        queries2.add(query);
        QueryGroup newQuery = new QueryGroup(queries2);
        return this.addQuery(newQuery);
    }

    public int getNumberOfQueryGroups() {
        List<QueryGroup> queries = this.getAllQueries();
        if (queries != null) {
            return queries.size();
        }
        return 0;
    }

    public QueryGroup getActiveQueryGroup() {
        List<QueryGroup> queries = this.getAllQueries();
        Integer no = (Integer)this.session.getAttribute("activeQueryNo");
        int i = no == null ? 0 : no;
        return queries.get(i);
    }

    public int getActiveQueryGroupNo() {
        Integer no = (Integer)this.session.getAttribute("activeQueryNo");
        int i = no == null ? 0 : no;
        return i;
    }

    public void setActiveQueryGroup(int i) {
        this.session.setAttribute("activeQueryNo", (Object)new Integer(i));
    }

    public HashMap<CollectionInfo, ArrayList<CollectionInfo>> refreshAvailableCollections() throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = CollectionsFieldsCache.getInstance().refreshCollectionInfoForScope(this.session.getScopeName(), true);
        this.session.setAttribute("collectionsHierarchy", collections);
        return collections;
    }

    public CollectionInfo findCollectionInfo(String collectionId) throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = this.getAvailableCollections();
        if (collections != null) {
            Set<CollectionInfo> groups = collections.keySet();
            for (CollectionInfo group : groups) {
                if (group.getId().equals(collectionId)) {
                    return group;
                }
                ArrayList<CollectionInfo> realCols = collections.get(group);
                for (int i = 0; i < realCols.size(); ++i) {
                    if (!realCols.get(i).getId().equals(collectionId)) continue;
                    return realCols.get(i);
                }
            }
            return null;
        }
        try {
            throw new NoAvailableCollectionsFoundException();
        }
        catch (NoAvailableCollectionsFoundException e) {
            logger.debug("No Available collections were found.");
            return null;
        }
    }

    public List<CollectionInfo> searchCollections(String term, String whereToSearch) throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> colH = this.getAvailableCollections();
        return FindFieldsInfo.searchCollectionInfo(term, whereToSearch, colH);
    }
}

