/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsToStringHelper {
    private static final Logger logger = LoggerFactory.getLogger(CollectionsToStringHelper.class);

    public static void logHashMap(HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections) {
        for (CollectionInfo colinfo : collections.keySet()) {
            logger.info("Collection name: " + colinfo.getName());
            logger.info("Collection id: " + colinfo.getId());
            logger.info("Collection browsable fields:");
            for (Field browsableField : colinfo.getBrowsableFields()) {
                logger.info("Name: " + browsableField.getName() + " ID: " + browsableField.getId() + " toString(): " + browsableField.toString());
            }
            logger.info("Collection presentable fields:");
            for (Field presentableField : colinfo.getPresentationFields()) {
                logger.info("Name: " + presentableField.getName() + " ID: " + presentableField.getId() + " toString(): " + presentableField.toString());
            }
            ArrayList<CollectionInfo> subcollections = collections.get(colinfo);
            for (CollectionInfo subcolinfo : subcollections) {
                logger.info("SubCollection name: " + subcolinfo.getName());
                logger.info("SubCollection id: " + subcolinfo.getId());
                logger.info("SubCollection browsable fields:");
                for (Field browsableField : subcolinfo.getBrowsableFields()) {
                    logger.info("Name: " + browsableField.getName() + " ID: " + browsableField.getId() + " toString(): " + browsableField.toString());
                }
                logger.info("Collection presentable fields:");
                for (Field presentableField : subcolinfo.getPresentationFields()) {
                    logger.info("Name: " + presentableField.getName() + " ID: " + presentableField.getId() + " toString(): " + presentableField.toString());
                }
            }
        }
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }
}

