package org.gcube.applicationsupportlayer.social;


/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 * @version 0.1 Dec 2012
 *
 */
public interface NewsManager {
	/**
	 * use to share an update from your application
	 * 
	 * @param applicationClass your servlet class name will be used ad unique identifier for your application
	 * @param description add a description for the update you are sharing
	 * @param uri the link to which the subject of this update is available
	 * @return true if the update is correctly delivered, false otherwise
	 */
	boolean shareApplicationUpdate(Class<?> applicationClass, String description, String uri);
	/**
	 * use to share an update from your application with a link preview
	 * 
	 * @param applicationClass your servlet class name will be used ad unique identifier for your application with a link preview
	 * @param description add a description for the update you are sharing
	 * @param uri the link to which the subject of this update is available
	 * @param previewTitle the title to show in the preview
	 * @param previewDescription the description to show in the preview
	 * @param previewThumbnailUrl the image url to show in the preview
	 * @return true if the update is correctly delivered, false otherwise
	 */
	boolean shareApplicationUpdate(Class<?> applicationClass, String description, String uri, String previewTitle, String previewDescription, String previewThumbnailUrl);
}
