/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.userprofiles.cache.factories;

import java.io.ByteArrayInputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.gcube.application.framework.core.cache.factories.ApplicationCredentials;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.userprofiles.commons.ProfileService;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessPortType;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ProfileCacheEntryFactory
implements CacheEntryFactory {
    protected static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
    protected static AtomicInteger profileId = new AtomicInteger(0);
    protected final GCUBELog logger = new GCUBELog((Object)this);

    public Object createEntry(Object key) throws Exception {
        QueryString query = (QueryString)key;
        String profile = "";
        if (query.containsKey((Object)"vre") && query.containsKey((Object)"username")) {
            ProfileService profileService = new ProfileService((String)query.get((Object)"username"), GCUBEScope.getScope((String)((String)query.get((Object)"vre"))));
            ExtendedGSSCredential cred = ApplicationCredentials.getInstance().getCredential((String)query.get((Object)"vre"));
            UserProfileAccessPortType port = profileService.getUserProfileAccess(cred);
            profile = port.getUserProfile(new VOID());
            this.logger.debug((Object)profile);
            InputSource profileIn = new InputSource(new ByteArrayInputStream(profile.getBytes()));
            Document profileDoc = dfactory.newDocumentBuilder().parse(profileIn);
            return profileDoc;
        }
        return null;
    }
}

