/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.userprofiles.commons;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.personalization.profileadministration.stubs.ProfileAdministrationPortType;
import org.gcube.personalization.profileadministration.stubs.service.ProfileAdministrationServiceAddressingLocator;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessFactoryPortType;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessPortType;
import org.gcube.personalization.userprofileaccess.stubs.service.UserProfileAccessFactoryServiceAddressingLocator;
import org.gcube.personalization.userprofileaccess.stubs.service.UserProfileAccessServiceAddressingLocator;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileService {
    protected static AtomicInteger profileId = new AtomicInteger(0);
    protected String username;
    protected GCUBEScope scope;
    private static final Logger logger = LoggerFactory.getLogger(ProfileService.class);

    public ProfileService(String username, GCUBEScope scope) {
        this.username = username;
        this.scope = scope;
    }

    public UserProfileAccessFactoryPortType getUserProfileAccessFactory() {
        EndpointReference[] profileURIs;
        try {
            profileURIs = RIsManager.getInstance().getISCache(this.scope).getEPRsFor("Personalisation", "UserProfileAccess", SrvType.FACTORY.name());
        }
        catch (Exception e1) {
            logger.error("Exception:", (Throwable)e1);
            return null;
        }
        logger.info("getUserProfileAccessFactory: " + profileURIs.length);
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        UserProfileAccessFactoryPortType upa = null;
        try {
            serviceEPR.setAddress((AttributedURI)new Address(profileURIs[profileId.getAndIncrement() % profileURIs.length].getAddress().toString()));
            UserProfileAccessFactoryServiceAddressingLocator upalocator = new UserProfileAccessFactoryServiceAddressingLocator();
            upa = upalocator.getUserProfileAccessFactoryPortTypePort(serviceEPR);
            return upa;
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            return null;
        }
    }

    public UserProfileAccessPortType getUserProfileAccess(ExtendedGSSCredential cred) {
        UserProfileAccessFactoryPortType upa = this.getUserProfileAccessFactory();
        try {
            upa = (UserProfileAccessFactoryPortType)ServiceContextManager.applySecurity((Remote)upa, (GCUBEScope)this.scope, (GSSCredential)cred);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        EndpointReferenceType epr = null;
        try {
            logger.info("\n\n\n\n" + this.username + " scope= " + this.scope + "\n\n\n\n");
            epr = upa.createResource(this.username);
        }
        catch (GCUBEFault e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (epr != null) {
            try {
                return this.getUserProfileAccessServicePortType(epr, this.scope, (GSSCredential)cred);
            }
            catch (RemoteException e) {
                logger.error("Exception:", (Throwable)e);
            }
        }
        return null;
    }

    public UserProfileAccessPortType getUserProfileAccess(UserProfileAccessFactoryPortType upa, ExtendedGSSCredential cred) {
        try {
            upa = (UserProfileAccessFactoryPortType)ServiceContextManager.applySecurity((Remote)upa, (GCUBEScope)this.scope, (GSSCredential)cred);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        EndpointReferenceType epr = null;
        try {
            epr = upa.createResource(this.username);
        }
        catch (GCUBEFault e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (epr != null) {
            try {
                return this.getUserProfileAccessServicePortType(epr, this.scope, (GSSCredential)cred);
            }
            catch (RemoteException e) {
                logger.error("Exception:", (Throwable)e);
            }
        }
        return null;
    }

    private UserProfileAccessPortType getUserProfileAccessServicePortType(EndpointReferenceType epr, GCUBEScope scope, GSSCredential cred) throws RemoteException {
        UserProfileAccessServiceAddressingLocator instanceLocator = new UserProfileAccessServiceAddressingLocator();
        UserProfileAccessPortType port = null;
        try {
            port = instanceLocator.getUserProfileAccessPortTypePort(epr);
            try {
                port = (UserProfileAccessPortType)ServiceContextManager.applySecurity((Remote)port, (GCUBEScope)scope, (GSSCredential)cred);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RemoteException("A service exception was thrown. Failed to get the port type of the service user profile access");
        }
        return port;
    }

    public ProfileAdministrationPortType getProfileAdministration(GSSCredential cred) {
        EndpointReference[] profileURIs;
        try {
            profileURIs = RIsManager.getInstance().getISCache(this.scope).getEPRsFor("Personalisation", "ProfileAdministration", SrvType.SIMPLE.name());
        }
        catch (Exception e1) {
            logger.error("Exception:", (Throwable)e1);
            return null;
        }
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        ProfileAdministrationPortType pa = null;
        logger.info("profile administration services: " + profileURIs.length);
        try {
            serviceEPR.setAddress((AttributedURI)new Address(profileURIs[profileId.getAndIncrement() % profileURIs.length].getAddress().toString()));
            ProfileAdministrationServiceAddressingLocator palocator = new ProfileAdministrationServiceAddressingLocator();
            pa = palocator.getProfileAdministrationPortTypePort(serviceEPR);
            pa = (ProfileAdministrationPortType)ServiceContextManager.applySecurity((Remote)pa, (GCUBEScope)this.scope, (GSSCredential)cred);
            return pa;
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            return null;
        }
    }
}

