/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.userprofiles.library.impl;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.apache.xpath.XPathAPI;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.userprofiles.cache.UserProfileCache;
import org.gcube.application.framework.userprofiles.cache.factories.ProfileCacheEntryFactory;
import org.gcube.application.framework.userprofiles.library.UserProfileInfoI;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.personalization.profileadministration.client.library.exceptions.ProfileAdministrationException;
import org.gcube.personalization.profileadministration.client.library.proxies.ProfileAdministrationCLProxyI;
import org.gcube.personalization.profileadministration.client.library.proxies.ProfileAdministrationDSL;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types;
import org.gcube.personalization.userprofileaccess.client.library.exceptions.UserProfileAccessException;
import org.gcube.personalization.userprofileaccess.client.library.proxies.UserProfileAccessCLProxyI;
import org.gcube.personalization.userprofileaccess.client.library.proxies.UserProfileAccessDSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UserProfile
implements UserProfileInfoI {
    protected ASLSession session;
    private static final Logger logger = LoggerFactory.getLogger(UserProfile.class);
    protected static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
    protected static ProfileAdministrationCLProxyI profileProxy = (ProfileAdministrationCLProxyI)ProfileAdministrationDSL.getSearchProxyBuilder().build();

    public UserProfile(String extrenalSessionID, String username) {
        this.session = SessionManager.getInstance().getASLSession(extrenalSessionID, username);
    }

    public UserProfile(ASLSession session) {
        this.session = session;
    }

    @Override
    public HashMap<String, String> getMetadataXSLTs(String username) {
        HashMap<String, String> metaXSLTs = new HashMap<String, String>();
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("user_profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        try {
            NodeList nodes = XPathAPI.selectNodeList((Node)profile, (String)"//xslts/metadataxslt/xslt");
            for (int i = 0; i < nodes.getLength(); ++i) {
                String name = "";
                String id = "";
                NodeList children = nodes.item(i).getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    if (children.item(j).getNodeType() != 1) continue;
                    if (children.item(j).getNodeName().equals("name")) {
                        name = children.item(j).getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!children.item(j).getNodeName().equals("id")) continue;
                    id = children.item(j).getFirstChild().getNodeValue();
                }
                logger.info("Inside GetMetadataXslts - initial name is: " + name);
                int a = name.lastIndexOf("-|-");
                name = name.substring(0, a);
                logger.info("After: " + name + " " + id);
                metaXSLTs.put(name, id);
            }
        }
        catch (TransformerException e) {
            logger.error("Failed to create a transformer", (Throwable)e);
        }
        return metaXSLTs;
    }

    @Override
    public HashMap<String, ArrayList<String>> getPresentationFields(String username) {
        HashMap<String, ArrayList<String>> collectionsFields = new HashMap<String, ArrayList<String>>();
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("user_profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        logger.debug("The user profile is: ");
        try {
            DOMSource domSource = new DOMSource(profile);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            logger.debug(sw.toString());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        try {
            NodeList nodes = XPathAPI.selectNodeList((Node)profile, (String)"//collections/collection");
            logger.debug("Number of collection nodes is: " + nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                String id = "";
                String colId = "";
                NamedNodeMap attrs = nodes.item(i).getAttributes();
                Node colIdNode = attrs.getNamedItem("id");
                colId = colIdNode.getNodeValue();
                logger.debug("IDS: " + colId + " " + colIdNode.getTextContent());
                NodeList children = nodes.item(i).getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    id = children.item(j).getTextContent();
                    logger.debug("Field id: " + id);
                    ArrayList<String> fieldIds = collectionsFields.get(colId);
                    if (fieldIds == null) {
                        fieldIds = new ArrayList();
                    }
                    fieldIds.add(id);
                    logger.debug("Putting field: " + id);
                    logger.debug("For Collection Putting: " + colId);
                    collectionsFields.put(colId, fieldIds);
                }
            }
        }
        catch (TransformerException e) {
            logger.error("Failed to create a transformer", (Throwable)e);
        }
        return collectionsFields;
    }

    @Override
    public String getUserProfile(String username) {
        String scope = this.session.getScope();
        String scopeLeaf = scope.substring(scope.lastIndexOf("/") + 1);
        String profile = null;
        profile = UserProfileCache.getProfile(username, scopeLeaf);
        if (profile != null && profile.length() > 0) {
            return profile;
        }
        StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
        List eprs = q.fire();
        if (eprs.size() > 0) {
            try {
                UserProfileAccessCLProxyI proxyRandom = (UserProfileAccessCLProxyI)UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
                profile = proxyRandom.getUserProfile();
                UserProfileCache.addProfile(username, scopeLeaf, profile);
                return profile;
            }
            catch (UserProfileAccessException e) {
                logger.debug("Could not retrieve user profile from IS", (Throwable)e);
            }
        } else {
            logger.debug("Could not find any EPRs to get the user profile");
        }
        return "";
    }

    private String createStringFromDomTree(Node tree) throws Exception {
        String nodeString = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(tree);
        transformer.transform(source, result);
        nodeString = sw.getBuffer().toString();
        return nodeString;
    }

    @Override
    public boolean setUserProfile(String username, String profile) {
        String scope = this.session.getScope();
        String scopeLeaf = scope.substring(scope.lastIndexOf("/") + 1);
        StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
        List eprs = q.fire();
        if (eprs.size() > 0) {
            try {
                UserProfileAccessCLProxyI proxyRandom = (UserProfileAccessCLProxyI)UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
                proxyRandom.updateUserProfile(profile);
                UserProfileCache.addProfile(username, scopeLeaf, profile);
                return true;
            }
            catch (Exception e) {
                logger.debug("Error contacting IS to set profile. Profile was not set on IS");
                return false;
            }
        }
        logger.debug("Could not find any EPRs to set the profile on IS");
        return false;
    }

    @Override
    public void createUserProfile(String username) {
        try {
            ScopeProvider.instance.set(this.session.getScope());
            profileProxy.createUserProfile(username);
        }
        catch (Exception e) {
            logger.debug("Could not create user profile");
        }
    }

    @Override
    public void dropUserProfile(String username) {
        String scope = this.session.getScope();
        String scopeLeaf = scope.substring(scope.lastIndexOf("/") + 1);
        UserProfileCache.removeProfile(username, scopeLeaf);
        ScopeProvider.instance.set(this.session.getScope());
        try {
            profileProxy.dropUserProfile(username);
        }
        catch (ProfileAdministrationException e) {
            logger.debug("Could not remove user profile from IS", (Throwable)e);
        }
    }

    @Override
    public String[] getElement(String username, String element) {
        String scope = this.session.getScope();
        String scopeLeaf = scope.substring(scope.lastIndexOf("/") + 1);
        String profile = this.getUserProfile(username);
        InputSource profileIn = new InputSource(new ByteArrayInputStream(profile.getBytes()));
        try {
            Document profileDoc = dfactory.newDocumentBuilder().parse(profileIn);
            ArrayList<String> nodesStr = new ArrayList<String>();
            NodeList nodes = XPathAPI.selectNodeList((Node)profileDoc, (String)element);
            for (int i = 0; i < nodes.getLength(); ++i) {
                try {
                    nodesStr.add(this.createStringFromDomTree(nodes.item(i)));
                    continue;
                }
                catch (Exception e) {
                    logger.error("Failed to serialize a profile's node", (Throwable)e);
                }
            }
            String[] res = new String[nodesStr.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (String)nodesStr.get(i);
            }
            return res;
        }
        catch (Exception e) {
            logger.debug("Could not parse the element value from User profile stored in cache", (Throwable)e);
            StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
            List eprs = q.fire();
            Types.GetElementResponse elementValue = new Types.GetElementResponse();
            if (eprs.size() > 0) {
                try {
                    UserProfileAccessCLProxyI proxyRandom = (UserProfileAccessCLProxyI)UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
                    elementValue = proxyRandom.getElement(element);
                }
                catch (UserProfileAccessException e2) {
                    logger.debug("Could not get profile element from IS", (Throwable)e2);
                }
            } else {
                logger.debug("Could not find any EPRs to get the element value");
            }
            String[] results = new String[elementValue.array.size()];
            for (int i = 0; i < elementValue.array.size(); ++i) {
                results[i] = (String)elementValue.array.get(i);
            }
            return results;
        }
    }

    @Override
    public String getElementValue(String username, String element) {
        String profile = this.getUserProfile(username);
        InputSource profileIn = new InputSource(new ByteArrayInputStream(profile.getBytes()));
        try {
            Document profileDoc = dfactory.newDocumentBuilder().parse(profileIn);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String result = (String)xpath.evaluate(element + "/text()", profileDoc, XPathConstants.STRING);
            if (result != null && result.length() > 0) {
                return result;
            }
        }
        catch (Exception e) {
            logger.debug("Could not parse the element value from User profile stored in cache", (Throwable)e);
        }
        String scope = this.session.getScope();
        String scopeLeaf = scope.substring(scope.lastIndexOf("/") + 1);
        StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
        List eprs = q.fire();
        String elementValue = null;
        if (eprs.size() > 0) {
            try {
                UserProfileAccessCLProxyI proxyRandom = (UserProfileAccessCLProxyI)UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
                elementValue = proxyRandom.getElementValue(element);
            }
            catch (UserProfileAccessException e) {
                logger.debug("Could not get element value from IS", (Throwable)e);
            }
        } else {
            logger.debug("Could not find any EPRs to get the element value");
        }
        return elementValue;
    }

    @Override
    public void setDefaultProfile(String defaultProfile) {
        ScopeProvider.instance.set(this.session.getScope());
        try {
            profileProxy.setDefaultProfile(defaultProfile);
        }
        catch (ProfileAdministrationException e) {
            logger.debug("Could not set default profile value on IS", (Throwable)e);
        }
    }

    @Override
    public void setElementValue(String username, String element, String value) {
        String scope = this.session.getScope();
        String scopeLeaf = scope.substring(scope.lastIndexOf("/") + 1);
        StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
        List eprs = q.fire();
        if (eprs.size() > 0) {
            try {
                Types.SetElementValue el = new Types.SetElementValue();
                el.elementName = element;
                el.value = value;
                UserProfileAccessCLProxyI proxyRandom = (UserProfileAccessCLProxyI)UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
                proxyRandom.setElementValue(el);
                String newISProfile = proxyRandom.getUserProfile();
                UserProfileCache.addProfile(username, scopeLeaf, newISProfile);
            }
            catch (UserProfileAccessException e) {
                logger.debug("Could not set profile's element value on IS", (Throwable)e);
            }
        } else {
            logger.debug("Could not find any EPRs to set the element value");
        }
    }

    public boolean deleteElement(String username, String elementName) {
        String scope = this.session.getScope();
        String scopeLeaf = scope.substring(scope.lastIndexOf("/") + 1);
        StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
        List eprs = q.fire();
        if (eprs.size() > 0) {
            try {
                UserProfileAccessCLProxyI proxyRandom = (UserProfileAccessCLProxyI)UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
                proxyRandom.deleteElement(elementName);
                String newISProfile = proxyRandom.getUserProfile();
                UserProfileCache.addProfile(username, scopeLeaf, newISProfile);
                return true;
            }
            catch (UserProfileAccessException e) {
                logger.debug("Could not delete profile element from IS", (Throwable)e);
                return false;
            }
        }
        logger.debug("Could not find any EPRs to get profile and remove the element value");
        return false;
    }

    public void setElement(String username, String path, String elementName, String elementValue) {
        String scope = this.session.getScope();
        String scopeLeaf = scope.substring(scope.lastIndexOf("/") + 1);
        StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
        List eprs = q.fire();
        if (eprs.size() > 0) {
            try {
                Types.SetElement el = new Types.SetElement();
                el.path = path;
                el.elementName = elementName;
                el.value = elementValue;
                UserProfileAccessCLProxyI proxyRandom = (UserProfileAccessCLProxyI)UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
                proxyRandom.setElement(el);
                String newISProfile = proxyRandom.getUserProfile();
                UserProfileCache.addProfile(username, scopeLeaf, newISProfile);
            }
            catch (UserProfileAccessException e) {
                logger.debug("Could not set profile element on IS", (Throwable)e);
            }
        } else {
            logger.debug("Could not find any EPRs to set the element value");
        }
    }

    protected void createElementToService(String path, String username, String name, String value) {
    }

    protected void setElementToService(String username, String element, String value) {
    }

    protected void deleteElementToService(String username, String elementName) {
    }
}

