package org.gcube.application.framework.userprofiles.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.userprofiles.cache.factories.ProfileCacheEntryFactory;
import org.gcube.application.framework.userprofiles.util.CacheConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileCache {

	/** Object logger. */
	private static Logger logger = LoggerFactory.getLogger(UserProfileCache.class);
	
	private static Cache userprofiles;
	
//	private static CacheManager manager = CacheManager.create();//.addCache(new Cache("CachedSearchEPRs", 100, false, true, 60, 60))
	
//	private static CacheManager manager
	
	
//	public void enableEPRCache(){
//		if(CacheManager.getInstance().getCache("CachedSearchEPRs") == null){
//			logger.debug("Creating a cache for the EPRs");
//			CacheManager.getInstance().addCache(new Cache("CachedSearchEPRs", 100, false, true, 60, 60));			
//		}
//	}
	static {
		logger.debug("Creating the cache for the User Profiles");
		userprofiles = new Cache(CacheConstants.PROFILE_CACHE_NAME, 100, false, true, 60, 60);
		CacheManager.getInstance().addCache(userprofiles);
	}
	
	/**
	 * 
	 * @param username the username as in IS
	 * @param vre the vre from Scope. eg. for scope '/gcube/devNext/NextNext' the vre is 'NextNext'
	 * @param profile the serialized XML profile
	 * @return the status of the addition. true if successful, false otherwise
	 */
	public static boolean addProfile(String username, String vre, String profile){
		QueryString query = new QueryString();
		query.addParameter("username", username);
		query.addParameter("vre", vre);
		try{
			userprofiles.put(new Element(query, profile));
		}catch (Exception e){
			logger.debug("An exception occured while adding the profile to cache!",e);
			return false;
		}
		return true;
	}
	
	
	/**
	 * 
	 * @param username the username as in IS
	 * @param vre the vre from Scope. eg. for scope '/gcube/devNext/NextNext' the vre is 'NextNext'
	 * @return the status of the removal. true if successful, false otherwise
	 */
	public static boolean removeProfile(String username, String vre){
		QueryString query = new QueryString();
		query.addParameter("username", username);
		query.addParameter("vre", vre);
		boolean status;
		try{
			status = userprofiles.remove(query);
		}catch (Exception e){
			logger.debug("An exception occured while adding the profile to cache!",e);
			return false;
		}
		return status;
	}
	
	
	/**
	 * 
	 * @param username the username as in IS
	 * @param vre the vre from Scope. eg. for scope '/gcube/devNext/NextNext' the vre is 'NextNext'
	 * @return the serialized XML profile
	 */
	public static String getProfile(String username, String vre){
		QueryString query = new QueryString();
		query.addParameter("username", username);
		query.addParameter("vre", vre);
		try{
			String profile = (String) userprofiles.get(query).getObjectValue();
			return profile;
		}catch (Exception e){
			logger.debug("An exception occured while adding the profile to cache!",e);
			return null;
		}
	}
	
	
	
	
	
	
	
}
