/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.userprofiles.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.gcube.application.framework.core.util.QueryString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileCache {
    private static Logger logger = LoggerFactory.getLogger(UserProfileCache.class);
    private static Cache userprofiles;

    public static boolean addProfile(String username, String vre, String profile) {
        QueryString query = new QueryString();
        query.addParameter("username", username);
        query.addParameter("vre", vre);
        try {
            userprofiles.put(new Element((Serializable)query, (Serializable)((Object)profile)));
        }
        catch (Exception e) {
            logger.debug("An exception occured while adding the profile to cache!", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean removeProfile(String username, String vre) {
        boolean status;
        QueryString query = new QueryString();
        query.addParameter("username", username);
        query.addParameter("vre", vre);
        try {
            status = userprofiles.remove((Serializable)query);
        }
        catch (Exception e) {
            logger.debug("An exception occured while adding the profile to cache!", (Throwable)e);
            return false;
        }
        return status;
    }

    public static String getProfile(String username, String vre) {
        QueryString query = new QueryString();
        query.addParameter("username", username);
        query.addParameter("vre", vre);
        try {
            String profile = (String)userprofiles.get((Serializable)query).getObjectValue();
            return profile;
        }
        catch (Exception e) {
            logger.debug("An exception occured while adding the profile to cache!", (Throwable)e);
            return null;
        }
    }

    static {
        logger.debug("Creating the cache for the User Profiles");
        userprofiles = new Cache("user_profiles", 100, false, true, 60L, 60L);
        CacheManager.getInstance().addCache(userprofiles);
    }
}

