package org.gcube.application.framework.vremanagement.vremanagement.impl;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.core.security.PortalSecurityManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.vremanagement.vremanagement.ISInfoI;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBECollectionQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEMCollectionQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.resources.GCUBECollection;
import org.gcube.common.core.resources.GCUBEExternalRunningInstance;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.ghnmanager.stubs.AddScopeInputParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.GHNManagerPortType;
import org.gcube.common.vremanagement.ghnmanager.stubs.ScopeRIParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.service.GHNManagerServiceAddressingLocator;

/**
 * @author Valia Tsaqgkalidou (NKUA)
 */
public class ISInfo implements ISInfoI {
	
	/**
	 * ASLSession to be used
	 */
	protected ASLSession session;
	/**
	 *  is client in order to query IS
	 */
	protected static ISClient client = null;

	protected static ISPublisher publisher = null;
	
	/**
	 * Constructs a ISInfo object
	 * @param session the D4Science session to be used for retrieving information needed
	 */
	public ISInfo(ASLSession session)
	{
		this.session = session;
		try {
			publisher = GHNContext.getImplementation(ISPublisher.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(client == null)
		{
			try {
				client = GHNContext.getImplementation(ISClient.class);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				client = null;
			}
		}
	}

	/** {@inheritDoc}*/
	public List<XMLResult> queryIS(String query) {
		try {
			GCUBEGenericQuery queryMan = client.getQuery(GCUBEGenericQuery.class);
			
			queryMan.setExpression(query);
			System.out.println(session.getOriginalScopeName());
			return client.execute(queryMan, session.getScope());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new ArrayList<XMLResult>();
	}

	/** {@inheritDoc}*/
	public List<RPDocument> getWS(String type)
	{
		WSResourceQuery query = null;
		try {
			query = client.getQuery(WSResourceQuery.class);
			query.addAtomicConditions(new AtomicCondition("/gc:ServiceClass", type));
			return client.execute(query, session.getScope());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return new ArrayList<RPDocument>();
		
	}
	

	/** {@inheritDoc}*/
	public void addGHNToScope(String url) {
		//TODO: this will probably change...
		
		EndpointReferenceType endpoint = new EndpointReferenceType();
		try {
			url = "http://" + url + "/wsrf/services/gcube/common/vremanagement/GHNManager";
			String[] vos = session.getOriginalScopeName().split("/");
			System.out.println("querying for vo: /" + vos[1]);
			
			endpoint.setAddress(new Address(url));
			GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
			GHNManagerPortType pt = locator.getGHNManagerPortTypePort(endpoint);
			pt = (GHNManagerPortType) ServiceContextManager.applySecurity(pt, GCUBEScope.getScope("/" + vos[1]), session.getCredential());
			AddScopeInputParams params = new AddScopeInputParams();
			params.setScope(session.getOriginalScopeName());
			params.setMap(""); //eventually, set here the new Service Map
			pt.addScope(params);	
			
		} catch (Exception e) {
			e.printStackTrace();
		}				
	}

	/** {@inheritDoc}*/
	public void removeGHNToScope(String url) {
		//TODO: this will probably change...
		
		EndpointReferenceType endpoint = new EndpointReferenceType();
		try {
			url = "http://" + url + "/wsrf/services/gcube/common/vremanagement/GHNManager";

			String[] vos = session.getOriginalScopeName().split("/");
			System.out.println("querying for vo: /" + vos[1]);
			
			endpoint.setAddress(new Address(url));
			GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
			GHNManagerPortType pt = locator.getGHNManagerPortTypePort(endpoint);
			pt = (GHNManagerPortType) ServiceContextManager.applySecurity(pt, GCUBEScope.getScope("/" + vos[1]), session.getCredential());
			pt.removeScope(session.getOriginalScopeName());	
			
		} catch (Exception e) {
			e.printStackTrace();
		}				
	}

	/** {@inheritDoc}*/
	public void addRIToScope(String url, String className, String name) {	
		//TODO: this will probably change...
		
		EndpointReferenceType endpoint = new EndpointReferenceType();
		try {
			endpoint.setAddress(new Address(url));
			GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
			GHNManagerPortType pt = locator.getGHNManagerPortTypePort(endpoint);
			pt = (GHNManagerPortType) ServiceContextManager.applySecurity(pt, session);				
			ScopeRIParams params = new ScopeRIParams();			
			params.setClazz(className);
			params.setName(name);
			params.setScope(session.getOriginalScopeName());
			pt.addRIToScope(params);	
			
		} catch (Exception e) {
			e.printStackTrace();
		}				
	}

	/** {@inheritDoc}*/
	public void addExternalRIToVRE(File file)
	{
		GCUBEExternalRunningInstance ri = null;
		try {
			ri = GHNContext.getImplementation(GCUBEExternalRunningInstance.class);
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		String ret = "";
		if(file.exists()){
			try {
				ri.load(new FileReader(file));
			} catch (Exception e) {
				String message = "Error while loading profile for the External Running Instance with id=" + ri.getID() + "\n";
				System.out.println(message);
				e.printStackTrace();
				ret  += message;
			}
		}else{
			String message = "An error occur during the approval of the External Running Instance with id=" + ri.getID() + "\n";
			System.out.println(message);
			ret += message;
		}
		
		
    	
		try {
			// TODO Change this
			
			publisher.registerGCUBEResource(ri, session.getScope(), new PortalSecurityManager(session));
		} catch (ISPublisherException e) {
			String message = "Registration error for the External Running Instance with id=" + ri.getID() + "\n";
			System.out.println(message);
			e.printStackTrace();
			ret += message;
		}

	}

	/** {@inheritDoc}*/
	public void removeExternalRIToVRE(String id)
	{    	
		try {
			// TODO Change this
			
			publisher.removeGCUBEResource(id, GCUBEExternalRunningInstance.TYPE, session.getScope(), new PortalSecurityManager(session));
		} catch (ISPublisherException e) {
			String message = "Registration error for the External Running Instance with id=" +id + "\n";
			System.out.println(message);
			e.printStackTrace();
		}

	}

	/** {@inheritDoc}*/
	public boolean existsGHN(String namePort)
	{
		GCUBEGenericQuery query;
		try {
			System.out.println("GHN: " + namePort);
			query = client.getQuery(GCUBEGenericQuery.class);query.setExpression("for $ghn in collection(\"/db/Profiles/GHN\")//Document/Data/child::*[local-name()='Profile']/Resource where $ghn/Profile/GHNDescription/Name/string() eq '" + namePort + "' return $ghn");
			String[] vos = session.getOriginalScopeName().split("/");
			System.out.println("querying for vo: /" + vos[1]);
			List<XMLResult> resources = client.execute(query, GCUBEScope.getScope("/" + vos[1]));
			if(resources == null || resources.size() == 0)
			{
				System.out.println("Resources are null or empty");
				return false;
			}
			else
			{
				System.out.println("Found resources!!!!");
				return true;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		return false;
	}
	
	
	/**
	 * Returns all profiles of collections present in the given scope.
	 * @param scope the scope of the collections.
	 * @return a list of collections profile.
	 * @throws Exception when an error occurs.
	 */
	 public List<GCUBECollection> getCollections(GCUBEScope scope) throws Exception
	 {
	
	
	      try {
	               GCUBECollectionQuery collectionquery = client.getQuery(GCUBECollectionQuery.class);
	
	               return client.execute(collectionquery,scope);
	
	           } catch (Exception e) {
 	                System.out.println("Error during Collections retrieving in scope "+scope.getName());
 	                e.printStackTrace();
 	                throw new Exception("Error during Collections retrieving in scope "+scope.getName(), e);
	           }
	 }
	        
	        
	 /**
	   * Return all metadata-collections associated with the given collection.
	   * @param scope the scope of the metadata collections.
	   * @param collectionID the associated collection.
	   * @return a list of metadata collections profile.
	   * @throws Exception
	   */
	   public List<GCUBEMCollection> getMCollections(GCUBEScope scope, String collectionID) throws Exception
	   {
	         	
	         try {
	         	      GCUBEMCollectionQuery mcolQuery = client.getQuery(GCUBEMCollectionQuery.class);
	         	
	         	      mcolQuery.addGenericCondition("$result/child::*[local-name()='Profile']/RelatedCollection/CollectionID/string() eq '"+collectionID+"'");
	         	
	         	      return client.execute(mcolQuery,scope);
	         	
	         } catch (Exception e) {
	         	      System.out.println("Error during MCollections retrieving in scope "+scope.getName());
	         	      e.printStackTrace();
	         	      throw new Exception("Error during MCollections retrieving in scope "+scope.getName(), e);
	         }
	         	
	   }
	         	        
	         	        
	   /**
	    * Return all XML indices associated with the given metadata collection.
	    * @param scope the indices scope.
	    * @param mcollectionID the metadata collection id.
	    * @return a list of Resource document.
	    * @throws Exception
	   */
	   public List<RPDocument> getXMLIndices(GCUBEScope scope, String mcollectionID) throws Exception
	   {
	         try {
	         	       	
	         	    WSResourceQuery queryXMLIndices = client.getQuery(WSResourceQuery.class);
	         	        	
	         	    queryXMLIndices.addAtomicConditions(new AtomicCondition("//gc:ServiceClass", "MetadataManagement"),
	         	    		new AtomicCondition("//gc:ServiceName","XMLIndexer"),
	         	    		new AtomicCondition("/child::*[local-name()='Id']", mcollectionID),
	         	    		new AtomicCondition("/child::*[local-name()='AccessType']", "GCUBEDaix"));
	         	        	
	         	        	
	         	    return  client.execute(queryXMLIndices, scope);
	         	        	
	         } catch (Exception e) {
	         	     System.out.println("Error during Indices retrieving in scope "+scope.getName());
	         	     e.printStackTrace();
	         	     throw new Exception("Error during Indices retrieving in scope "+scope.getName(), e);
	         }
	         	        	
	   }
	         	        	        
	   /**
	   * Return all indices associated with a given metadata collection.
	   * @param scope the indices scope.
	   * @param mcollectionID the metadata collection id.
	   * @return a list of Resource document.
	   * @throws Exception
	   */
	   public List<RPDocument> getIndices(GCUBEScope scope, String mcollectionID) throws Exception
	   {
	         	        	       	
	         try {
	         	        	        	
	         	 WSResourceQuery queryXMLIndices = client.getQuery(WSResourceQuery.class);
	         	        	        	
	         	 queryXMLIndices.addAtomicConditions(new AtomicCondition("//gc:ServiceClass", "Index"),
	         			 new AtomicCondition("/child::*[local-name()='CollectionID']",mcollectionID));
	         	        	        	
	         	 return client.execute(queryXMLIndices, scope);
	         	        	        	
	         } catch (Exception e) {
	         	     System.out.println("Error during Indices retrieving in scope "+scope.getName());
	         	     e.printStackTrace();
	         	     throw new Exception("Error during Indices retrieving in scope "+scope.getName(), e);
	         }
	         	        	        	
	   }
	   
	   
	   /**
	    * Return all indices associated with a given collection.
	    * @param scope the indices scope.
	    * @param collectionID the collection id.
	    * @return a list of Resource document.
	    * @throws Exception
	    */
	    public List<RPDocument> getCollectionIndices(GCUBEScope scope, String collectionID) throws Exception
	    {
	    	   try {
	   	
	    	       WSResourceQuery queryXMLIndices = client.getQuery(WSResourceQuery.class);
	    	
	    	       queryXMLIndices.addAtomicConditions(new AtomicCondition("//gc:ServiceClass", "Index"),
	    	                    new AtomicCondition("/child::*[local-name()='CollectionID']",collectionID));
	    	
	    	       return client.execute(queryXMLIndices, scope);
	    	
	    	   } catch (Exception e) {
	    	                        System.out.println("Error during collection Indices retrieving in scope "+scope.getName());
	    	                        e.printStackTrace();
	    	                        throw new Exception("Error during collection Indices retrieving  in scope "+scope.getName(), e);
	    	                }
	    	
	    }
	    
	    
	    
	    /**
	     * Return a collection profile.
	     * @param scope the collection scope.
	     * @param collectionID the collection id.
	     * @return a collection profile.
	     * @throws Exception
	    */
	     public GCUBECollection getCollection(GCUBEScope scope, String collectionID) throws Exception
	     {
	     	     try {
	     	              GCUBECollectionQuery Collectionquery = client.getQuery(GCUBECollectionQuery.class);
	     	              Collectionquery.addAtomicConditions(new AtomicCondition("//ID",collectionID));
	     	              return client.execute(Collectionquery,scope).get(0);
	     	
	     	      } catch (Exception e) {
	     	             System.out.println("Error during Collection (by ID "+collectionID+") retrieving in scope "+scope.getName());
	     	             e.printStackTrace();
	     	             throw new Exception("Error during Collection (by ID "+collectionID+") retrieving in scope "+scope.getName(), e);
	     	      }
	     	
	     }
}

