/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.control;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.authorization.library.exception.AuthorizationException;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AuthorizationAspect {
    Logger log = LoggerFactory.getLogger(AuthorizationAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ AuthorizationAspect ajc$perSingletonInstance;

    @Pointcut(value="@annotation(org.gcube.common.authorization.control.annotations.AuthorizationControl)")
    public /* synthetic */ void authorizationEntryPoint() {
    }

    @Pointcut(value="execution(* *.*(..))")
    public /* synthetic */ void anyCall() {
    }

    @Before(value="authorizationEntryPoint() && anyCall()")
    public void before(JoinPoint joinPoint) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        AuthorizationControl authAnn = method.getAnnotation(AuthorizationControl.class);
        this.log.info("aspect before with annotation {} with action {}, allowed {} in method {}", new Object[]{authAnn.annotationType(), authAnn.actions(), authAnn.allowedRoles(), authAnn.allowedUsers(), method.getName()});
        String userId = AuthorizationProvider.instance.get().getClient().getId();
        List userRoles = AuthorizationProvider.instance.get().getClient().getRoles();
        this.log.info("user role is {} and user {}", (Object)userRoles, (Object)userId);
        if (authAnn.allowedUsers().length != 0 && !Arrays.asList(authAnn.allowedUsers()).contains(userId)) {
            RuntimeException ex = authAnn.exception().getConstructor(Throwable.class).newInstance(new AuthorizationException(String.format("user %s not allowed to call method %s", userId, method.getName())));
            throw ex;
        }
        List<String> allowedRoles = Arrays.asList(authAnn.allowedRoles());
        if (authAnn.allowedRoles().length != 0 && userRoles.stream().filter(i -> allowedRoles.contains(i)).collect(Collectors.toList()).isEmpty()) {
            RuntimeException ex = authAnn.exception().getConstructor(Throwable.class).newInstance(new AuthorizationException(String.format("user %s not allowed to call method %s (role not valid)", userId, method.getName())));
            throw ex;
        }
    }

    public static AuthorizationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.gcube.common.authorization.control.AuthorizationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            AuthorizationAspect.ajc$perSingletonInstance = new AuthorizationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

