/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice;

import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="generate")
public class Generator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);
    @Inject
    TokenPersistence tokenPersistence;

    @Path(value="/{user}")
    @POST
    public String generateToken(@NotNull @PathParam(value="user") String userName, @QueryParam(value="roles") List<String> roles) {
        try {
            log.info("generator called with user {} and roles {} in scope {} ", new Object[]{userName, roles, ScopeProvider.instance.get()});
            AuthorizationEntry info = new AuthorizationEntry(userName, roles, ScopeProvider.instance.get());
            String token = this.tokenPersistence.getExistingToken(info);
            if (token == null) {
                token = UUID.randomUUID().toString();
                this.tokenPersistence.saveAuthorizationEntry(token, info);
            }
            return token;
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Generating Token: " + e.getMessage())).type("text/plain").build());
        }
    }
}

