/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice;

import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="retrieve/{token}")
public class Retriever {
    private static final Logger log = LoggerFactory.getLogger(Retriever.class);
    ApplicationContext context = ContextProvider.get();
    @Inject
    TokenPersistence tokenPersistence;

    @GET
    @Produces(value={"application/xml"})
    public AuthorizationEntry retrieveToken(@NotNull @PathParam(value="token") String token) {
        log.info("token retreiver called with token {}", (Object)token);
        AuthorizationEntry info = null;
        try {
            info = this.tokenPersistence.getAuthorizationEntry(token);
            info.setBannedServices(this.tokenPersistence.getBannedServices(info.getUserName(), info.getScope()));
        }
        catch (Exception e) {
            log.error("error getting token ", (Throwable)e);
        }
        log.debug("getting info " + info);
        if (info == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Token " + token + " not found")).type("text/plain").build());
        }
        return info;
    }
}

