/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.configuration;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorizationservice.configuration.AllowedEntity;

@XmlRootElement(name="Rule")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AuthorizationRule {
    @XmlAttribute(name="path")
    private String servletPath;
    @XmlAttribute(name="requiresToken")
    private boolean requiresToken = true;
    @XmlElement(name="Entity")
    private List<AllowedEntity> entities = new ArrayList();

    protected AuthorizationRule() {
    }

    public AuthorizationRule(String servletPath, List<AllowedEntity> entities, boolean requiresToken) {
        this.servletPath = servletPath;
        this.entities = entities;
        this.requiresToken = requiresToken;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public List<AllowedEntity> getEntities() {
        return this.entities;
    }

    public boolean isTokenRequired() {
        return this.requiresToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entities == null ? 0 : this.entities.hashCode());
        result = 31 * result + (this.servletPath == null ? 0 : this.servletPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationRule other = (AuthorizationRule)obj;
        if (this.entities == null ? other.entities != null : !this.entities.equals(other.entities)) {
            return false;
        }
        return !(this.servletPath == null ? other.servletPath != null : !this.servletPath.equals(other.servletPath));
    }

    public String toString() {
        return "AuthorizationRule [servletPath=" + this.servletPath + ", entities=" + this.entities + " requiresToken= " + this.requiresToken + "]";
    }
}

