/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.configuration;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorizationservice.configuration.AllowedEntity;
import org.gcube.common.authorizationservice.configuration.AuthorizationRule;

public class RuleBuilder {
    private String servletPath;
    private List<AllowedEntity> entities = new ArrayList();
    private boolean requiresToken = true;

    public RuleBuilder path(String servletPath) {
        this.servletPath = servletPath;
        return this;
    }

    public RuleBuilder entity(AllowedEntity entity) {
        this.entities.add(entity);
        return this;
    }

    public RuleBuilder needsToken(boolean needsToken) {
        this.requiresToken = needsToken;
        return this;
    }

    protected String getServletPath() {
        return this.servletPath;
    }

    protected List<AllowedEntity> getEntities() {
        return this.entities;
    }

    protected boolean isRequiresToken() {
        return this.requiresToken;
    }

    public AuthorizationRule build() {
        return new AuthorizationRule(this.servletPath, this.entities, this.requiresToken);
    }
}

