/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice;

import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.ExternalServiceList;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.ContainerInfo;
import org.gcube.common.authorization.library.provider.ExternalServiceInfo;
import org.gcube.common.authorization.library.provider.ServiceInfo;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="token")
public class TokenManager {
    private static final Logger log = LoggerFactory.getLogger(TokenManager.class);
    @Inject
    TokenPersistence persistence;

    @GET
    @Path(value="{token}")
    @Produces(value={"application/xml"})
    public AuthorizationEntry retrieveToken(@NotNull @PathParam(value="token") String token) {
        log.info("token retreiver called with token {}", (Object)token);
        AuthorizationEntry info = this.persistence.getAuthorizationEntry(token);
        log.info("info retrieved {}", (Object)info);
        if (info == null) {
            log.error("token {} not found ", (Object)token);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("token " + token + " not found")).type("text/plain").build());
        }
        log.debug("returning info {}", (Object)info);
        return info;
    }

    @GET
    @Path(value="resolve/{user}")
    public String getTokenByUserAndContext(@NotNull @PathParam(value="user") String user, @QueryParam(value="context") String context) {
        log.info("resolving token for user {} in context {}", (Object)user, (Object)context);
        if (context == null) {
            log.error("null context found");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"null context found").type("text/plain").build());
        }
        String token = this.persistence.getExistingToken(user, context, "TOKEN");
        if (token == null) {
            log.error("token {} not found ", (Object)token);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("token for user " + user + " in context " + context + " not found")).type("text/plain").build());
        }
        return token;
    }

    @Path(value="user")
    @PUT
    @Consumes(value={"application/xml"})
    public String generateUserToken(UserInfo clientId, @NotNull @QueryParam(value="context") String context) {
        try {
            log.info("generator called with user {} in context {} ", (Object)clientId, (Object)context);
            if (clientId.getId().split(":").length > 1) {
                throw new Exception("invalid user id: " + clientId.getId());
            }
            String token = this.persistence.getExistingToken(clientId.getId(), context, "TOKEN");
            if (token == null) {
                token = UUID.randomUUID().toString();
                this.persistence.saveAuthorizationEntry(token, context, (ClientInfo)clientId, "TOKEN", null);
            }
            return token;
        }
        catch (Exception e) {
            log.error("error generating token ", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Generating Token: " + e.getMessage())).type("text/plain").build());
        }
    }

    @Path(value="user")
    @DELETE
    @Consumes(value={"application/xml"})
    public void removeUserToken(UserInfo clientId, @NotNull @QueryParam(value="context") String context) {
        try {
            log.info("generator called with user {} in context {} ", (Object)clientId, (Object)context);
            if (clientId.getId().split(":").length > 1) {
                throw new Exception("invalid user id: " + clientId.getId());
            }
            this.persistence.removeAllAuthorizationsEntryFroClientId(context, (ClientInfo)clientId);
        }
        catch (Exception e) {
            log.error("error generating token ", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error removing Token: " + e.getMessage())).type("text/plain").build());
        }
    }

    @Path(value="service")
    @PUT
    @Consumes(value={"application/xml"})
    public String generateServiceToken(ServiceInfo serviceInfo, @Context HttpServletRequest req) {
        try {
            AuthorizationEntry authInfo = (AuthorizationEntry)req.getAttribute("authorizationInfo");
            log.info("generator called with service {} in context {} ", (Object)serviceInfo.getId(), (Object)authInfo.getContext());
            return this.generateTokenForServiceInfo(serviceInfo, authInfo);
        }
        catch (Exception e) {
            log.error("error generating token ", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Generating Token: " + e.getMessage())).type("text/plain").build());
        }
    }

    @Path(value="external/{serviceId}")
    @PUT
    @Consumes(value={"application/xml"})
    public String generateExternalServiceToken(@PathParam(value="serviceId") String serviceId, @Context HttpServletRequest req) {
        try {
            AuthorizationEntry info = (AuthorizationEntry)req.getAttribute("authorizationInfo");
            log.info("generator called for external service {} in context {} ", (Object)serviceId, (Object)info.getContext());
            if (serviceId.split(":").length > 1) {
                throw new Exception("invalid external service id: " + serviceId);
            }
            String token = this.persistence.getExistingToken(serviceId, info.getContext(), "TOKEN");
            if (token == null) {
                token = UUID.randomUUID().toString();
                this.persistence.saveAuthorizationEntry(token, info.getContext(), (ClientInfo)new ExternalServiceInfo(serviceId, info.getClientInfo().getId()), "TOKEN", info.getClientInfo().getId());
            }
            return token;
        }
        catch (Exception e) {
            log.error("error generating token ", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Generating Token: " + e.getMessage())).type("text/plain").build());
        }
    }

    @Path(value="external")
    @GET
    @Consumes(value={"application/xml"})
    public ExternalServiceList getExternalServiceCreated(@Context HttpServletRequest req) {
        try {
            AuthorizationEntry info = (AuthorizationEntry)req.getAttribute("authorizationInfo");
            log.info("get External Service called in context {} by {} ", (Object)info.getContext(), (Object)info.getClientInfo().getId());
            ExternalServiceList toReturn = new ExternalServiceList(this.persistence.getExistingExternalServices(info.getClientInfo().getId(), info.getContext()));
            return toReturn;
        }
        catch (Exception e) {
            log.error("error generating token ", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Generating Token: " + e.getMessage())).type("text/plain").build());
        }
    }

    @Path(value="node")
    @PUT
    @Consumes(value={"application/xml"})
    public String generateContainerToken(@NotNull ContainerInfo containerInfo, @QueryParam(value="context") String context, @Context HttpServletRequest req) {
        try {
            AuthorizationEntry info = (AuthorizationEntry)req.getAttribute("authorizationInfo");
            if (context != null) {
                return this.generateTokenForContainerInfo(containerInfo, context);
            }
            if (info != null) {
                log.info("generator called for node {} in context {} ", (Object)containerInfo.getId(), (Object)info.getContext());
                return this.generateTokenForContainerInfo(containerInfo, info);
            }
            throw new Exception("error trying to activate node (token and context are empty)");
        }
        catch (Exception e) {
            log.error("error generating token ", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Generating Token: " + e.getMessage())).type("text/plain").build());
        }
    }

    private String generateTokenForContainerInfo(ContainerInfo containerInfo, String context) throws Exception {
        if (containerInfo.getId().split(":").length != 2) {
            throw new Exception("invalid container id: " + containerInfo.getId());
        }
        String token = this.persistence.getExistingToken(containerInfo.getId(), context, "TOKEN");
        if (token == null) {
            token = UUID.randomUUID().toString();
            this.persistence.saveAuthorizationEntry(token, context, (ClientInfo)containerInfo, "TOKEN", null);
        }
        return token;
    }

    private String generateTokenForContainerInfo(ContainerInfo containerInfo, AuthorizationEntry authInfo) throws Exception {
        if (containerInfo.getId().split(":").length != 2) {
            throw new Exception("invalid container id: " + containerInfo.getId());
        }
        String token = this.persistence.getExistingToken(containerInfo.getId(), authInfo.getContext(), "TOKEN");
        if (token == null) {
            token = UUID.randomUUID().toString();
            this.persistence.saveAuthorizationEntry(token, authInfo.getContext(), (ClientInfo)containerInfo, "TOKEN", authInfo.getClientInfo().getId());
        }
        return token;
    }

    private String generateTokenForServiceInfo(ServiceInfo serviceInfo, AuthorizationEntry authInfo) throws Exception {
        if (serviceInfo.getId().split(":").length != 3) {
            throw new Exception("invalid service id: " + serviceInfo.getId());
        }
        String token = this.persistence.getExistingToken(serviceInfo.getId(), authInfo.getContext(), "TOKEN");
        if (token == null) {
            token = UUID.randomUUID().toString();
            this.persistence.saveAuthorizationEntry(token, authInfo.getContext(), (ClientInfo)serviceInfo, "TOKEN", authInfo.getClientInfo().getId());
        }
        return token;
    }
}

