/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.persistence.entities;

import java.util.Calendar;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.ContainerInfo;
import org.gcube.common.authorization.library.provider.ExternalServiceInfo;
import org.gcube.common.authorization.library.provider.ServiceIdentifier;
import org.gcube.common.authorization.library.provider.ServiceInfo;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.authorizationservice.persistence.entities.AuthorizationEntity;
import org.gcube.common.authorizationservice.persistence.entities.AuthorizationId;
import org.jboss.weld.exceptions.IllegalArgumentException;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Inheritance
@DiscriminatorColumn(name="EntryType")
@Table(name="Authorizations")
@NamedQueries(value={@NamedQuery(name="Authz.get", query="SELECT DISTINCT info FROM AuthorizationEntity info WHERE   info.token=:token"), @NamedQuery(name="Authz.getQualifiers", query="SELECT DISTINCT info FROM AuthorizationEntity info WHERE   info.id.qualifier!='TOKEN' AND info.id.clientId=:clientId AND info.id.context=:context"), @NamedQuery(name="Authz.getByToken", query="SELECT DISTINCT info FROM AuthorizationEntity info WHERE   info.token=:token"), @NamedQuery(name="Authz.getByClientId", query="SELECT DISTINCT info FROM AuthorizationEntity info WHERE   info.info_identifier=:clientid")})
public abstract class AuthorizationEntity {
    private static final String DEFAULT_GENERATOR = "default";
    @EmbeddedId
    AuthorizationId id;
    @Column(unique=true)
    String token;
    @Column
    String generatedBy = "default";
    @Transient
    ClientInfo info;
    @Embedded
    private ClientInfoEntity internalInfo;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column
    Calendar creationTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=true)
    Calendar lastTimeUsed;
    @Column(name="EntryType")
    String entryType;

    protected AuthorizationEntity() {
    }

    public AuthorizationEntity(String token, String context, ClientInfo clientInfo, String qualifier, String entryType) {
        this.id = new AuthorizationId(context, clientInfo.getId(), qualifier);
        this.token = token;
        this.entryType = entryType;
        this.creationTime = Calendar.getInstance();
        this.info = clientInfo;
        this.internalInfo = this.retriveInternalInfo(this.info);
    }

    public AuthorizationEntity(String token, String context, ClientInfo clientInfo, String qualifier, String entryType, String generatedBy) {
        this(token, context, clientInfo, qualifier, entryType);
        this.generatedBy = generatedBy;
    }

    public String getToken() {
        return this.token;
    }

    public String getContext() {
        return this.id.context;
    }

    public String getClientId() {
        return this.id.clientId;
    }

    public ClientInfo getInfo() {
        if (this.info == null) {
            this.info = this.retieveInfo();
        }
        return this.info;
    }

    public String getEntryType() {
        return this.entryType;
    }

    public String getGeneratedBy() {
        return this.generatedBy;
    }

    public void setGeneratedBy(String generatedBy) {
        this.generatedBy = generatedBy;
    }

    public String getQualifier() {
        return this.id.qualifier;
    }

    public Calendar getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public void setLastTimeUsed(Calendar lastTimeUsed) {
        this.lastTimeUsed = lastTimeUsed;
    }

    private ClientInfo retieveInfo() {
        switch (this.entryType) {
            case "UserInfo": {
                return new UserInfo(ClientInfoEntity.access$000((ClientInfoEntity)this.internalInfo), ClientInfoEntity.access$100((ClientInfoEntity)this.internalInfo));
            }
            case "ServiceInfo": {
                return new ServiceInfo(new ServiceIdentifier(ClientInfoEntity.access$200((ClientInfoEntity)this.internalInfo).clientServiceClass, ClientInfoEntity.access$200((ClientInfoEntity)this.internalInfo).clientServiceName, ClientInfoEntity.access$200((ClientInfoEntity)this.internalInfo).clientServiceIdentifier));
            }
            case "ExternalServiceInfo": {
                return new ExternalServiceInfo(ClientInfoEntity.access$000((ClientInfoEntity)this.internalInfo), ClientInfoEntity.access$300((ClientInfoEntity)this.internalInfo));
            }
            case "ContainerServiceInfo": {
                return new ContainerInfo(ClientInfoEntity.access$400((ClientInfoEntity)this.internalInfo), ClientInfoEntity.access$500((ClientInfoEntity)this.internalInfo));
            }
        }
        throw new IllegalArgumentException("invalid entity type");
    }

    private ClientInfoEntity retriveInternalInfo(ClientInfo info2) {
        switch (this.entryType) {
            case "UserInfo": {
                return ClientInfoEntity.forUser((String)this.info.getId(), (List)this.info.getRoles());
            }
            case "ServiceInfo": {
                ServiceIdentifier identifier = ((ServiceInfo)this.info).getServiceIdentifier();
                return ClientInfoEntity.forService((String)identifier.getServiceClass(), (String)identifier.getServiceName(), (String)identifier.getServiceId());
            }
            case "ExternalServiceInfo": {
                ExternalServiceInfo externalServiceInfo = (ExternalServiceInfo)this.info;
                return ClientInfoEntity.forExternalService((String)externalServiceInfo.getId(), (String)externalServiceInfo.getGeneratedBy());
            }
            case "ContainerServiceInfo": {
                ContainerInfo containerInfo = (ContainerInfo)this.info;
                return ClientInfoEntity.forContainer((String)containerInfo.getHost(), (int)containerInfo.getPort());
            }
        }
        throw new IllegalArgumentException("invalid entity type");
    }

    public String toString() {
        return "AuthorizationEntity [id=" + this.id + ", token=" + this.token + ", creationTime=" + this.creationTime + ", entryType=" + this.entryType + "]";
    }
}

