package org.gcube.common.authorization.utils.provider;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.secret.GCubeSecret;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class GCubeSecretProvider implements SecretProvider {

	@Override
	public Secret getSecret() {
		String token = SecurityTokenProvider.instance.get();
		if(token!=null) {
			return new GCubeSecret(token);
		}
		return null; 
	}
	
}
