package org.gcube.common.authorization.utils.clientid;

import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ClientIDManager implements RenewalProvider {

	protected final String clientID;
	protected final String clientSecret;
	
	public ClientIDManager(String clientID, String clientSecret) {
		this.clientID = clientID;
		this.clientSecret = clientSecret;
	}
	
	public Secret getSecret() throws Exception {
		TokenResponse tokenResponse = KeycloakClientFactory.newInstance().queryUMAToken(clientID, clientSecret, null);
		
		JWTSecret jwtSecret = new JWTSecret(tokenResponse.getAccessToken());
		jwtSecret.setRenewalProvider(this);
		
		jwtSecret.setTokenResponse(tokenResponse);
		
		return jwtSecret;
	}
	
	public Secret getSecret(String context) throws Exception {
		TokenResponse tokenResponse = KeycloakClientFactory.newInstance().queryUMAToken(clientID, clientSecret, context, null);
		
		JWTSecret jwtSecret = new JWTSecret(tokenResponse.getAccessToken());
		jwtSecret.setRenewalProvider(this);
		
		jwtSecret.setTokenResponse(tokenResponse);
		
		return jwtSecret;
	}
	
	@Override
	public Secret renew() throws Exception {
		return getSecret();
	}
	
}
