/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security;

public class ContextBean {
    protected static String separator = "/";
    private String name;
    private Type type;
    private ContextBean enclosingScope;

    public String name() {
        return this.name;
    }

    public boolean is(Type type) {
        return this.type.equals(type);
    }

    public Type type() {
        return this.type;
    }

    public ContextBean enclosingScope() {
        return this.enclosingScope;
    }

    public ContextBean(String scope) throws IllegalArgumentException {
        String[] components = scope.split(separator);
        if (components.length < 2 || components.length > 4) {
            throw new IllegalArgumentException("scope " + scope + " is malformed");
        }
        if (components.length > 3) {
            this.name = components[3];
            this.enclosingScope = new ContextBean(separator + components[1] + separator + components[2]);
            this.type = Type.VRE;
        } else if (components.length > 2) {
            this.name = components[2];
            this.enclosingScope = new ContextBean(separator + components[1]);
            this.type = Type.VO;
        } else {
            this.name = components[1];
            this.type = Type.INFRASTRUCTURE;
        }
    }

    public String toString() {
        return this.is(Type.INFRASTRUCTURE) ? separator + this.name() : this.enclosingScope().toString() + separator + this.name();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enclosingScope == null ? 0 : this.enclosingScope.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextBean other = (ContextBean)obj;
        if (this.enclosingScope == null ? other.enclosingScope != null : !this.enclosingScope.equals(other.enclosingScope)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Type implements Comparable<Type>
    {
        VRE,
        VO,
        INFRASTRUCTURE;

    }
}

