/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.uri;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScopedURIBean {
    private static final Pattern scopePattern = Pattern.compile("scope=(.*)");
    private final URI uri;
    private final List<String> elements;
    private final String scope;

    public ScopedURIBean(URI uri) throws IllegalArgumentException {
        this.uri = uri;
        String path = uri.getPath();
        List<String> temporary = Arrays.asList(path.split("/"));
        this.elements = temporary.subList(1, temporary.size());
        String query = uri.getQuery();
        if (query == null) {
            throw new IllegalArgumentException(uri + " is unscoped");
        }
        Matcher m = scopePattern.matcher(query);
        if (!m.matches()) {
            throw new IllegalArgumentException(uri + " is unscoped");
        }
        this.scope = m.group(1);
    }

    public List<String> elements() {
        return new ArrayList<String>(this.elements);
    }

    public String scope() {
        return this.scope;
    }

    public URI uri() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }
}

