/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.context.authorization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.resourcemanagement.support.server.managers.context.ContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokensUtil {
    private static final Logger logger = LoggerFactory.getLogger(TokensUtil.class);

    public static Map<String, String> getTokenForContexts(String username, String serviceName) throws Exception {
        HashMap<String, String> contextTokenMap = new HashMap<String, String>();
        LinkedHashMap contexts = ContextManager.readContextsWithUUIDs();
        for (String context : contexts.keySet()) {
            try {
                System.out.println("Going to generate Token for Context " + context);
                logger.info("Going to generate Token for Context {}", (Object)context);
                UserInfo userInfo = new UserInfo(username, new ArrayList());
                String userToken = Constants.authorizationService().generateUserToken(userInfo, context);
                SecurityTokenProvider.instance.set(userToken);
                String generatedToken = Constants.authorizationService().generateExternalServiceToken(serviceName);
                contextTokenMap.put(context, generatedToken);
                logger.info("Token for Context {} is {}", (Object)context, (Object)generatedToken);
            }
            catch (Exception e) {
                logger.error("Error while elaborating {}", (Object)context, (Object)e);
                throw e;
            }
            finally {
                SecurityTokenProvider.instance.reset();
            }
        }
        return contextTokenMap;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Please provide 'vo file path' as first argument 'username' as second and 'external application name' as third");
            return;
        }
        TokensUtil.getTokenForContexts(args[1], args[2]);
    }
}

