/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csv4j;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.sf.csv4j.CSVParser;
import net.sf.csv4j.ParseException;

public class CSVReader {
    private final Reader reader;
    private final CSVParser parser;
    private final String comment;
    private final char commentChar;
    private int lineNumber = 0;
    private String currentLine;
    private final char[] buf = new char[100];
    private int bufLen = 0;
    private int bufPos = 0;
    private States state = States.Appending;

    public CSVReader(Reader reader) {
        this(reader, '#');
    }

    public CSVReader(Reader reader, char comment) {
        this(reader, ',', comment);
    }

    public CSVReader(Reader reader, char delimiter, char comment) {
        this.reader = reader;
        this.parser = new CSVParser(delimiter, true);
        this.comment = comment + "";
        this.commentChar = comment;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getCurrentLine() {
        return this.currentLine;
    }

    public List<String> readLine() throws IOException, ParseException {
        return this.readLine(false);
    }

    public List<String> readLine(boolean includeComment) throws IOException, ParseException {
        block2: {
            do {
                this.currentLine = this.readCSVLine();
                if (this.currentLine == null) {
                    return null;
                }
                if (!this.currentLine.startsWith(this.comment) && !this.currentLine.trim().startsWith(this.comment)) break block2;
            } while (!includeComment);
            String line = this.currentLine.substring(this.comment.length());
            return this.parser.tokenize(line);
        }
        return this.parser.tokenize(this.currentLine);
    }

    public long countFields() throws IOException, ParseException {
        do {
            this.currentLine = this.readCSVLine();
            if (this.currentLine != null) continue;
            return -1L;
        } while (this.currentLine.startsWith(this.comment) || this.currentLine.trim().startsWith(this.comment));
        return this.parser.countFields(this.currentLine);
    }

    public String readJSonLine() throws IOException, ParseException {
        do {
            this.currentLine = this.readCSVLine();
            if (this.currentLine != null) continue;
            return null;
        } while (this.currentLine.startsWith(this.comment) || this.currentLine.trim().startsWith(this.comment));
        return this.parser.toJSon(this.currentLine, this.getLineNumber());
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public String readCSVLine() throws IOException {
        if (this.state == States.EOF) {
            return null;
        }
        StringBuilder line = new StringBuilder();
        block16: while (true) {
            if (this.bufPos >= this.bufLen) {
                this.bufPos = 0;
                this.bufLen = this.reader.read(this.buf);
                if (this.bufLen < 0) {
                    this.state = States.EOF;
                    if (line.length() != 0) {
                        ++this.lineNumber;
                        return line.toString();
                    }
                    return null;
                }
            }
            while (true) {
                if (this.bufPos >= this.bufLen) continue block16;
                char ch = this.buf[this.bufPos];
                block0 : switch (this.state) {
                    case Appending: {
                        switch (ch) {
                            case '\r': {
                                this.state = States.CarriageReturn;
                                break block0;
                            }
                            case '\n': {
                                ++this.lineNumber;
                                ++this.bufPos;
                                this.state = States.Appending;
                                return line.toString();
                            }
                            case '\"': {
                                this.state = States.InsideDoubleQuote;
                                line.append(ch);
                                break block0;
                            }
                        }
                        if (ch == this.commentChar) {
                            this.state = States.InsideComment;
                        }
                        line.append(ch);
                        break;
                    }
                    case InsideDoubleQuote: {
                        if (ch == '\"') {
                            this.state = States.EndingDoubleQuote;
                        }
                        line.append(ch);
                        break;
                    }
                    case EndingDoubleQuote: {
                        if (ch == '\"') {
                            this.state = States.InsideDoubleQuote;
                            line.append(ch);
                            break;
                        }
                        this.state = States.Appending;
                        --this.bufPos;
                        break;
                    }
                    case CarriageReturn: {
                        if (ch == '\n') {
                            ++this.bufPos;
                        }
                        ++this.lineNumber;
                        this.state = States.Appending;
                        return line.toString();
                    }
                    case InsideComment: {
                        switch (ch) {
                            case '\n': 
                            case '\r': {
                                --this.bufPos;
                                this.state = States.Appending;
                                break block0;
                            }
                        }
                        line.append(ch);
                        break;
                    }
                    case EOF: {
                        return null;
                    }
                }
                ++this.bufPos;
            }
            break;
        }
    }

    static enum States {
        Appending,
        InsideDoubleQuote,
        EndingDoubleQuote,
        CarriageReturn,
        InsideComment,
        EOF;

    }
}

