/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csv4j;

import java.util.List;
import java.util.Map;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.ParseException;

abstract class AbstractLineToFieldMapAdapter
implements CSVLineProcessor {
    protected List<String> header;

    @Override
    public void processHeaderLine(int linenumber, List<String> fieldNames) {
        if (this.header != null) {
            throw new ParseException("second header line at line #" + linenumber);
        }
        this.header = fieldNames;
    }

    @Override
    public void processDataLine(int linenumber, List<String> fieldValues) {
        if (this.header == null) {
            throw new ParseException("missing header line");
        }
        Map<String, String> fields = this.createMap();
        if (this.header.size() > fieldValues.size()) {
            AbstractLineToFieldMapAdapter.padList(fieldValues, this.header.size(), "");
        } else if (this.header.size() < fieldValues.size()) {
            throw new ParseException("Line #" + linenumber + ": # of field values (" + this.header.size() + ") > header size (" + fieldValues.size() + ")");
        }
        for (int ii = 0; ii < this.header.size(); ++ii) {
            fields.put(this.header.get(ii), fieldValues.get(ii));
        }
        this.processDataLine(linenumber, fields);
    }

    protected abstract Map<String, String> createMap();

    protected abstract void processDataLine(int var1, Map<String, String> var2);

    @Override
    public abstract boolean continueProcessing();

    private static void padList(List<String> list, int desiredLength, String fill) {
        int numToPad = desiredLength - list.size();
        for (int ii = 0; ii < numToPad; ++ii) {
            list.add(fill);
        }
    }
}

