/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.database.engine;

import java.util.HashMap;
import java.util.Map;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.common.database.engine.HostingNode;
import org.gcube.common.database.engine.Platform;

public class DatabaseInstance {
    private String id;
    private Map<String, DatabaseEndpoint> endpoints = new HashMap<String, DatabaseEndpoint>();
    private Platform platform;
    private HostingNode node;

    public DatabaseInstance() {
    }

    public DatabaseInstance(String id, Map<String, DatabaseEndpoint> endpoints, Platform platform, HostingNode node) {
        this.id = id;
        this.endpoints = endpoints;
        this.platform = platform;
        this.node = node;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, DatabaseEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public HostingNode getNode() {
        return this.node;
    }

    public void setEndpoints(Map<String, DatabaseEndpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public void setNode(HostingNode node) {
        this.node = node;
    }

    public String getName() {
        return this.platform.getName();
    }

    public Short getVersion() {
        return this.platform.getVersion();
    }

    public Short getMinorVersion() {
        return this.platform.getMinorVersion();
    }

    public Short getRevisionVersion() {
        return this.platform.getRevisionVersion();
    }

    public Short getBuildVersion() {
        return this.platform.getBuildVersion();
    }

    public String getHostingURL() {
        return this.node.getHostingURL();
    }

    public String getGhnUniqueId() {
        return this.node.getGhnUniqueId();
    }

    public String getStatus() {
        return this.node.getStatus();
    }

    public DatabaseEndpoint getEndpoint(String endpointId) {
        return this.endpoints.get(endpointId);
    }

    public void addEndpoint(DatabaseEndpoint endpoint) {
        this.endpoints.put(endpoint.getId(), endpoint);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DatabaseInstance [id=");
        builder.append(this.id);
        builder.append(", endpoints=");
        builder.append(this.endpoints);
        builder.append(", platform=");
        builder.append(this.platform);
        builder.append(", node=");
        builder.append(this.node);
        builder.append("]");
        return builder.toString();
    }
}

