/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.tables;

import java.sql.ResultSet;
import java.util.LinkedHashMap;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.GetMetadata;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTable
extends Table {
    private static final long serialVersionUID = 1874819829226263856L;
    private LinkedHashMap<String, Type> fieldsMapping = null;
    private int count = -1;
    private static final Logger logger = LoggerFactory.getLogger(SimpleTable.class);

    public SimpleTable(String tableName) {
        super(tableName);
    }

    public SimpleTable(String tableName, String tableAlias) {
        super(tableName, tableAlias);
    }

    public void initializeFieldMapping(DBSession session) throws Exception {
        GetMetadata metadata = DBSession.getImplementation(GetMetadata.class);
        metadata.setTable(this.getTableName());
        this.fieldsMapping = metadata.getResults(session);
    }

    public void initializeFieldMapping() throws Exception {
        DBSession session = DBSession.connect();
        try {
            this.initializeFieldMapping(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() throws Exception {
        if (this.count == -1) {
            this.initializeCount();
        }
        return this.count;
    }

    public void initializeCount(DBSession session) throws Exception {
        Select select = DBSession.getImplementation(Select.class);
        select.setTables(new Table(this.getTableName()));
        select.setAttributes(new AggregatedAttribute("*", AggregationFunctions.COUNT));
        ResultSet rs = select.getResults(session, new boolean[0]);
        rs.next();
        this.count = rs.getInt(1);
        logger.trace("initialized count for table " + this.getTable() + ", it is " + this.count);
    }

    public void initializeCount() throws Exception {
        DBSession session = DBSession.connect();
        try {
            this.initializeCount(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public LinkedHashMap<String, Type> getFieldsMapping() throws Exception {
        if (this.fieldsMapping != null) {
            return this.fieldsMapping;
        }
        logger.debug("initializing table mapping");
        this.initializeFieldMapping();
        return this.fieldsMapping;
    }

    public void setFieldsMapping(LinkedHashMap<String, Type> fieldsMapping) {
        this.fieldsMapping = fieldsMapping;
    }
}

