/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventSender;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPEventSender
implements EventSender {
    protected static final Logger log = LoggerFactory.getLogger(HTTPEventSender.class);
    private URL baseEnndpointURL;
    private String clientId;
    private String clientSecret;
    private URL tokenURL;

    public HTTPEventSender(URL baseEnndpointURL, String clientId, String clientSecret, URL tokenURL) {
        this.baseEnndpointURL = baseEnndpointURL;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenURL = tokenURL;
    }

    @Override
    public void send(Event event) {
        if (log.isDebugEnabled()) {
            log.debug("Starting HTTP POST thread to: " + this.baseEnndpointURL);
        }
        try {
            URL eventEndpoint = new URL(this.baseEnndpointURL, event.getName());
            new Thread(new HTTPost(eventEndpoint, event.toJSONString())).start();
        }
        catch (MalformedURLException e) {
            log.error("Cannot compute event endpoint URL. Event name: " + event.getName() + ", base endpoint: " + this.baseEnndpointURL, (Throwable)e);
        }
    }

    public class HTTPost
    implements Runnable {
        private static final int CONNECTION_TIMEOUT = 10000;
        private static final int READ_TIMEOUT = 5000;
        private URL endpoint;
        private String jsonString;

        public HTTPost(URL endpoint, String jsonString) {
            this.endpoint = endpoint;
            this.jsonString = jsonString;
        }

        @Override
        public void run() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Getting OIDC token for client: " + HTTPEventSender.this.clientId);
                }
                JWTToken token = null;
                if (HTTPEventSender.this.clientId != null && HTTPEventSender.this.clientSecret != null && HTTPEventSender.this.tokenURL != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Getting OIDC token for clientId '" + HTTPEventSender.this.clientId + "' from: " + HTTPEventSender.this.tokenURL);
                    }
                    token = OpenIdConnectRESTHelper.queryClientToken((String)HTTPEventSender.this.clientId, (String)HTTPEventSender.this.clientSecret, (URL)HTTPEventSender.this.tokenURL);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Performing HTTP POST to: " + this.endpoint);
                }
                HttpURLConnection connection = (HttpURLConnection)this.endpoint.openConnection();
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(10000);
                if (log.isTraceEnabled()) {
                    log.trace("HTTP connection timeout set to: " + connection.getConnectTimeout());
                }
                connection.setReadTimeout(5000);
                if (log.isTraceEnabled()) {
                    log.trace("HTTP connection Read timeout set to: " + connection.getReadTimeout());
                }
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                if (token != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting authorization header as: " + token.getAsBearer());
                    }
                    connection.setRequestProperty("Authorization", token.getAsBearer());
                } else if (log.isDebugEnabled()) {
                    log.debug("Sending request without authorization header");
                }
                OutputStream os = connection.getOutputStream();
                if (log.isTraceEnabled()) {
                    log.trace("Sending event JSON: " + this.jsonString);
                }
                os.write(this.jsonString.getBytes("UTF-8"));
                os.flush();
                os.close();
                StringBuilder sb = new StringBuilder();
                int httpResultCode = connection.getResponseCode();
                if (log.isTraceEnabled()) {
                    log.trace("HTTP Response code: " + httpResultCode);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Reading response");
                }
                boolean ok = true;
                InputStreamReader isr = null;
                if (httpResultCode == 200) {
                    isr = new InputStreamReader(connection.getInputStream(), "UTF-8");
                } else {
                    ok = false;
                    isr = new InputStreamReader(connection.getErrorStream(), "UTF-8");
                }
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                isr.close();
                if (ok) {
                    if (log.isDebugEnabled()) {
                        log.debug("[" + httpResultCode + "] Event publish OK. Results: " + sb.toString());
                    }
                } else {
                    log.warn("[" + httpResultCode + "] Event publish is not OK. Results: " + sb.toString());
                }
            }
            catch (Exception e) {
                log.error("POSTing JSON to: " + this.endpoint, (Throwable)e);
            }
        }
    }
}

