package org.gcube.event.publisher;

import org.json.simple.JSONObject;

public class EventStatus {

    public enum Status {
        RUNNING, COMPLETED, FAILED, TIMED_OUT, TERMINATED, PAUSED, NOT_FOUND;
    }

    public static EventStatus RUNNING(JSONObject input) {
        return new EventStatus(Status.RUNNING, input);
    }

    public static EventStatus COMPLETED(JSONObject input, JSONObject output) {
        return new EventStatus(Status.COMPLETED, input, output);
    }

    public static EventStatus FAILED(JSONObject input, JSONObject output) {
        return new EventStatus(Status.FAILED, input, output);
    }

    public static EventStatus TIMED_OUT(JSONObject input) {
        return new EventStatus(Status.TIMED_OUT, input);
    }

    public static EventStatus TERMINATED(JSONObject input, JSONObject output) {
        return new EventStatus(Status.TERMINATED, input, output);
    }

    public static EventStatus PAUSED(JSONObject input) {
        return new EventStatus(Status.PAUSED, input);
    }

    public static EventStatus NOT_FOUND() {
        return new EventStatus(Status.NOT_FOUND);
    }

    private Status status;
    private JSONObject input;
    private JSONObject output;

    private EventStatus(Status status) {
        this(status, null);
    }

    private EventStatus(Status status, JSONObject input) {
        this(status, input, null);
    }

    private EventStatus(Status status, JSONObject input, JSONObject output) {
        setStatus(status);
        setInput(input);
        setOutput(output);
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return status;
    }

    public void setInput(JSONObject input) {
        this.input = input;
    }

    public JSONObject getInput() {
        return input;
    }

    public void setOutput(JSONObject output) {
        this.output = output;
    }

    public JSONObject getOutput() {
        return output;
    }

    @Override
    public String toString() {
        return String.format("[%s]\ninput: %s\noutput: %s", status, input != null ? input.toJSONString() : "<No input>",
                output != null ? output.toJSONString() : "<No output>");
    }

}