/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventSender;
import org.gcube.event.publisher.HTTPWithOIDCAuthEventSender;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelperException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTTPWithJWTTokenAuthEventSender
implements EventSender {
    protected static final Logger log = LoggerFactory.getLogger(HTTPWithOIDCAuthEventSender.class);
    protected URL baseEndpointURL;
    protected String clientId;
    protected String clientSecret;
    protected URL tokenURL;
    protected int connectionTimeout;
    protected int readTimeout;
    protected HTTPPost lastHTTPPost;
    protected HTTPGet lastHTTPGet;

    public AbstractHTTPWithJWTTokenAuthEventSender(URL baseEndpointURL, String clientId, String clientSecret, URL tokenURL) {
        this.baseEndpointURL = baseEndpointURL;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenURL = tokenURL;
        this.connectionTimeout = this.getDefaultConnectionTimeout();
        this.readTimeout = this.getDefaultReadTimeout();
    }

    protected int getDefaultReadTimeout() {
        return 5000;
    }

    protected int getDefaultConnectionTimeout() {
        return 10000;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void send(Event event) {
        log.debug("Starting HTTP POST thread with base URL: {}", (Object)this.baseEndpointURL);
        this.lastHTTPPost = new HTTPPost(this.baseEndpointURL, event);
        new Thread(this.lastHTTPPost).start();
    }

    @Override
    public int getLastSendHTTPResponseCode() {
        return this.lastHTTPPost != null ? this.lastHTTPPost.gethttpResponseCode() : -1;
    }

    @Override
    public String sendAndGetResult(Event event) {
        log.debug("Starting HTTP POST thread to: {}", (Object)this.baseEndpointURL);
        this.lastHTTPPost = new HTTPPost(this.baseEndpointURL, event);
        Thread postThread = new Thread(this.lastHTTPPost);
        postThread.start();
        try {
            postThread.join();
            return this.lastHTTPPost.getResult();
        }
        catch (InterruptedException e) {
            log.error("While waiting for HTTP Post thread termination", (Throwable)e);
            return null;
        }
    }

    @Override
    public JSONObject retrive(String id) {
        this.lastHTTPGet = new HTTPGet(this.baseEndpointURL, id);
        return this.lastHTTPGet.readJSON();
    }

    @Override
    public int getLastRetrieveHTTPResponseCode() {
        return this.lastHTTPGet != null ? this.lastHTTPGet.gethttpResponseCode() : -1;
    }

    protected URL getTokenURL() {
        return this.tokenURL;
    }

    protected abstract JWTToken getAuthorizationToken() throws OpenIdConnectRESTHelperException;

    public class HTTPGet
    extends HTTPVerb {
        private String id;

        public HTTPGet(URL baseEndpoint, String id) {
            super(baseEndpoint);
            this.id = id;
        }

        public JSONObject readJSON() {
            URL endpoint = null;
            JSONObject results = null;
            try {
                String baseEndpointString = this.baseEndpoint.toString();
                endpoint = baseEndpointString.endsWith("/") ? new URL(baseEndpointString + this.id) : new URL(baseEndpointString + "/" + this.id);
            }
            catch (MalformedURLException e) {
                log.error("Cannot compute retrieve endpoint URL. ID: " + this.id + ", base endpoint: " + AbstractHTTPWithJWTTokenAuthEventSender.this.baseEndpointURL, (Throwable)e);
                return null;
            }
            try {
                log.debug("Getting auth token for client '{}' if needed", (Object)AbstractHTTPWithJWTTokenAuthEventSender.this.clientId);
                JWTToken token = AbstractHTTPWithJWTTokenAuthEventSender.this.getAuthorizationToken();
                log.debug("Performing HTTP GET to: {}", (Object)endpoint);
                HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(AbstractHTTPWithJWTTokenAuthEventSender.this.connectionTimeout);
                log.trace("HTTP connection timeout set to: {}", (Object)connection.getConnectTimeout());
                connection.setReadTimeout(AbstractHTTPWithJWTTokenAuthEventSender.this.readTimeout);
                log.trace("HTTP connection Read timeout set to: {}", (Object)connection.getReadTimeout());
                if (token != null) {
                    log.debug("Setting authorization header as: {}", (Object)token.getAccessTokenAsBearer());
                    connection.setRequestProperty("Authorization", token.getAccessTokenAsBearer());
                } else {
                    log.debug("Sending request without authorization header");
                }
                StringBuilder sb = new StringBuilder();
                this.httpResponseCode = connection.getResponseCode();
                log.trace("HTTP Response code: {}", (Object)this.httpResponseCode);
                this.httpContentType = connection.getContentType();
                log.trace("HTTP Response content type is: {}", (Object)this.httpContentType);
                log.trace("Reading response");
                InputStreamReader isr = null;
                isr = this.httpResponseCode == 200 ? new InputStreamReader(connection.getInputStream(), "UTF-8") : new InputStreamReader(connection.getErrorStream(), "UTF-8");
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                isr.close();
                if (this.httpResponseCode == 200) {
                    log.debug("[{}] Got results for {}", (Object)this.httpResponseCode, (Object)this.id);
                    if (this.httpContentType.equals("application/json")) {
                        try {
                            results = (JSONObject)new JSONParser().parse(sb.toString());
                        }
                        catch (ParseException e) {
                            log.warn("Error parsing results string as JSON: {}", (Object)sb.toString());
                        }
                    } else {
                        log.warn("Received a non JSON reponse: {}", (Object)sb.toString());
                    }
                } else {
                    log.warn("[{}] Error getting results for ID {}", (Object)this.httpResponseCode, (Object)this.id);
                }
            }
            catch (IOException | OpenIdConnectRESTHelperException e) {
                log.error("Getting results from: " + endpoint, e);
            }
            return results;
        }
    }

    public class HTTPPost
    extends HTTPVerb
    implements Runnable {
        private static final int PAUSE_INCREMENT_FACTOR = 2;
        private static final long MAX_RETRYINGS = 2L;
        private final int[] RETRY_CODES;
        private Event event;
        private String result;
        private long actualPause;
        private long retryings;

        public HTTPPost(URL baseEndpoint, Event event) {
            super(baseEndpoint);
            this.RETRY_CODES = new int[]{502, 408, 504, 500};
            this.actualPause = 1L;
            this.retryings = 0L;
            this.event = event;
        }

        @Override
        public void run() {
            try {
                URL eventEndpoint = null;
                if (this.baseEndpoint.toString().endsWith("/")) {
                    try {
                        log.debug("Removing trailing slash from base URL since the endpoint computation API changed");
                        eventEndpoint = new URL(this.baseEndpoint.toString().substring(0, this.baseEndpoint.toString().length() - 1));
                    }
                    catch (MalformedURLException e) {
                        log.error("Cannot remove trailing slash from base endpoint URL", (Throwable)e);
                        return;
                    }
                } else {
                    eventEndpoint = this.baseEndpoint;
                }
                boolean OK = false;
                do {
                    try {
                        log.debug("Getting auth token for client '{}' if needed", (Object)AbstractHTTPWithJWTTokenAuthEventSender.this.clientId);
                        JWTToken token = AbstractHTTPWithJWTTokenAuthEventSender.this.getAuthorizationToken();
                        log.debug("Performing HTTP POST to: {}", (Object)eventEndpoint);
                        HttpURLConnection connection = (HttpURLConnection)eventEndpoint.openConnection();
                        connection.setRequestMethod("POST");
                        connection.setConnectTimeout(AbstractHTTPWithJWTTokenAuthEventSender.this.connectionTimeout);
                        log.trace("HTTP connection timeout set to: {}", (Object)connection.getConnectTimeout());
                        connection.setReadTimeout(AbstractHTTPWithJWTTokenAuthEventSender.this.readTimeout);
                        log.trace("HTTP connection Read timeout set to: {}", (Object)connection.getReadTimeout());
                        connection.setRequestProperty("Content-Type", "application/json");
                        connection.setRequestProperty("Accept", "text/plain");
                        connection.setDoOutput(true);
                        if (token != null) {
                            log.debug("Setting authorization header as: {}", (Object)token.getAccessTokenAsBearer());
                            connection.setRequestProperty("Authorization", token.getAccessTokenAsBearer());
                        } else {
                            log.debug("Sending request without authorization header");
                        }
                        OutputStream os = connection.getOutputStream();
                        String jsonString = this.event.toJSONString();
                        log.trace("Sending event JSON: {}", (Object)jsonString);
                        os.write(jsonString.getBytes("UTF-8"));
                        os.flush();
                        os.close();
                        StringBuilder sb = new StringBuilder();
                        this.httpResponseCode = connection.getResponseCode();
                        log.trace("HTTP Response code: {}", (Object)this.httpResponseCode);
                        this.httpContentType = connection.getContentType();
                        log.trace("HTTP Response content type is: {}", (Object)this.httpContentType);
                        log.trace("Reading response");
                        InputStreamReader isr = null;
                        if (this.httpResponseCode == 200) {
                            OK = true;
                            isr = new InputStreamReader(connection.getInputStream(), "UTF-8");
                        } else {
                            isr = new InputStreamReader(connection.getErrorStream(), "UTF-8");
                        }
                        BufferedReader br = new BufferedReader(isr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            sb.append("\n" + line);
                        }
                        br.close();
                        isr.close();
                        sb.deleteCharAt(0);
                        this.result = sb.toString();
                        if (OK) {
                            log.debug("[{}] Event publish for {} is OK", (Object)this.httpResponseCode, (Object)this.event.getName());
                            continue;
                        }
                        log.trace("Response message from server:\n{}", (Object)this.result);
                        if (this.shouldRetryWithCode(this.httpResponseCode)) {
                            if (this.retryings <= 2L) {
                                log.warn("[{}] Event publish ERROR, retrying in {} seconds", (Object)this.httpResponseCode, (Object)this.actualPause);
                                Thread.sleep(this.actualPause * 1000L);
                                log.debug("Start retrying event publish: {}", (Object)this.event.getName());
                                this.actualPause *= 2L;
                                ++this.retryings;
                                continue;
                            }
                            log.error("[{}] Event publish ERROR, exhausted tries after {} retryings", (Object)this.httpResponseCode, (Object)this.retryings);
                            break;
                        }
                        log.info("[{}] Event publish ERROR but should not retry with this HTTP code", (Object)this.httpResponseCode);
                    }
                    catch (IOException | OpenIdConnectRESTHelperException e) {
                        log.error("POSTing JSON to: " + eventEndpoint, e);
                    }
                    break;
                } while (!OK);
            }
            catch (InterruptedException e) {
                log.error("Sleeping before retry event send", (Throwable)e);
            }
        }

        private boolean shouldRetryWithCode(int httpResultCode) {
            return Arrays.binarySearch(this.RETRY_CODES, httpResultCode) > 0;
        }

        public String getResult() {
            return this.result;
        }
    }

    public abstract class HTTPVerb {
        protected static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
        protected static final int DEFAULT_READ_TIMEOUT = 5000;
        protected URL baseEndpoint;
        protected int httpResponseCode = -1;
        protected String httpContentType;

        public HTTPVerb(URL baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        public int gethttpResponseCode() {
            return this.httpResponseCode;
        }
    }
}

