/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.xml.databases.existlibrary.collections;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.xml.databases.existlibrary.collections.Collection;
import org.gcube.common.xml.databases.existlibrary.collections.CollectionImpl;
import org.gcube.common.xml.databases.existlibrary.collections.SimpleCollection;
import org.gcube.common.xml.databases.existlibrary.collections.XMLResource;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class PartitionedCollection
extends CollectionImpl {
    private static final int MAX_DOCUMENTS_PER_COLL = 2000;
    private GCUBELog logger = new GCUBELog(this.getClass());

    public PartitionedCollection(String name) {
        super(name);
        this.logger.debug((Object)"new partitioned collection");
    }

    public PartitionedCollection(String name, org.xmldb.api.base.Collection collection) {
        super(name);
        this.setInternalCollection(collection);
    }

    @Override
    public void create(Collection parentColl) throws Collection.CollectionCreationException {
        CollectionManagementService mgtService;
        this.logger.debug((Object)"creating PartitionedCollection");
        try {
            CollectionImpl parentCollImpl = (CollectionImpl)parentColl;
            mgtService = (CollectionManagementService)parentCollImpl.getInternalCollection().getService("CollectionManagementService", "1.0");
        }
        catch (XMLDBException e1) {
            throw new Collection.CollectionCreationException();
        }
        this.logger.trace((Object)"the creation service is ready");
        try {
            org.xmldb.api.base.Collection tmpCol = mgtService.createCollection(this.getName());
            mgtService = (CollectionManagementService)tmpCol.getService("CollectionManagementService", "1.0");
            org.xmldb.api.base.Collection subCol = mgtService.createCollection("__sub__0");
            subCol.close();
            this.setInternalCollection(tmpCol);
            tmpCol.close();
        }
        catch (XMLDBException e) {
            this.logger.error((Object)"Rollbacking collection creation", (Throwable)e);
            try {
                mgtService.removeCollection(this.getName());
            }
            catch (XMLDBException e1) {
                this.logger.error((Object)"Error removing collection", (Throwable)e);
            }
            throw new Collection.CollectionCreationException("error creating partitioned collection");
        }
    }

    @Override
    public List<String> store(List<XMLResource> resources) throws Collection.CollectionException {
        SimpleCollection simpleColl;
        org.xmldb.api.base.Collection tmpCol;
        ArrayList<String> toReturn = new ArrayList<String>();
        this.logger.debug((Object)"storing in a partitioned collection");
        int toInsert = resources.size();
        int cursorStart = 0;
        int cursorEnd = 0;
        int emptyPositions = 0;
        try {
            tmpCol = this.getInternalCollection().getChildCollection("__sub__" + (this.getNumberOfSubCollections() - 1));
            emptyPositions = 2000 - tmpCol.getResourceCount();
            String tmpName = tmpCol.getName();
            simpleColl = new SimpleCollection(tmpName);
            simpleColl.setInternalCollection(tmpCol);
        }
        catch (XMLDBException e) {
            throw new Collection.CollectionException();
        }
        if (emptyPositions > 0) {
            cursorEnd = cursorStart + emptyPositions;
            if (cursorEnd > resources.size()) {
                cursorEnd = resources.size();
            }
            toReturn.addAll(this._internalStore(resources.subList(cursorStart, cursorEnd), simpleColl));
            toInsert -= cursorEnd - cursorStart;
            cursorStart = cursorEnd;
        }
        try {
            while (toInsert > 0) {
                SimpleCollection subCollection = new SimpleCollection("__sub__" + this.getNumberOfSubCollections());
                subCollection.create(this);
                subCollection.close();
                tmpCol = this.getInternalCollection().getChildCollection("__sub__" + (this.getNumberOfSubCollections() - 1));
                emptyPositions = 2000 - tmpCol.getResourceCount();
                if (emptyPositions <= 0) continue;
                cursorEnd = cursorStart + emptyPositions - 1;
                if (cursorEnd > resources.size()) {
                    cursorEnd = resources.size();
                }
                toReturn.addAll(this._internalStore(resources.subList(cursorStart, cursorEnd), subCollection));
                toInsert -= cursorEnd - cursorStart + 1;
                cursorStart = cursorEnd + 1;
            }
        }
        catch (XMLDBException e) {
            throw new Collection.CollectionException();
        }
        return toReturn;
    }

    public List<String> _internalStore(List<XMLResource> resources, CollectionImpl ... subCollection) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (XMLResource resource : resources) {
            try {
                if (subCollection != null && subCollection.length > 0) {
                    subCollection[0].getInternalCollection().storeResource((Resource)resource.getResource());
                    continue;
                }
                this.getInternalCollection().storeResource((Resource)resource.getResource());
            }
            catch (XMLDBException e) {
                try {
                    this.logger.error((Object)("the resource with Id " + resource.getResource().getId() + " was not stored due to " + e.getMessage()), (Throwable)e);
                    toReturn.add(resource.getResource().getId());
                }
                catch (XMLDBException e1) {
                    toReturn.add("Unknow id");
                    this.logger.error((Object)("the resource was not stored " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return toReturn;
    }

    public int getNumberOfSubCollections() {
        try {
            return this.getInternalCollection().getChildCollectionCount();
        }
        catch (XMLDBException e) {
            this.logger.error((Object)"Error getting the number of subCollections", (Throwable)e);
            return 0;
        }
    }

    @Override
    public XMLResource getResourceById(String id) throws Exception {
        return null;
    }
}

