/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.xml.databases.existlibrary.test;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.xml.databases.existlibrary.PooledConnection;
import org.gcube.common.xml.databases.existlibrary.PooledConnectionFactory;
import org.gcube.common.xml.databases.existlibrary.collections.Collection;
import org.gcube.common.xml.databases.existlibrary.collections.XMLResource;

public class PoolTester {
    public static void main(String[] args) {
        try {
            PooledConnection conn = PooledConnectionFactory.getFactory().getConnection();
            Collection colSimple = conn.getRootCollection().openSubCollection("GHN");
            Collection colPart = conn.getRootCollection().openSubCollection("lucioPart");
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            start = System.currentTimeMillis();
            List<String> listato = conn.getRootCollection().executeXQueryDirect("for $query in collection(\"/db/RunningInstances\")/Resource return <p>{$query/ID}{$query/Profile/ServiceName}{$query/Profile/DeploymentData/Status}</p>");
            end = System.currentTimeMillis();
            colSimple.close();
            colPart.close();
            PooledConnectionFactory.getFactory().shutDownConnection();
        }
        catch (Exception e) {
            PooledConnectionFactory.getFactory().shutDownConnection();
        }
    }

    public static void storePartitionedTest(Collection coll) {
        try {
            ArrayList<XMLResource> testStoreList = new ArrayList<XMLResource>();
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGHNQuery query = (GCUBEGHNQuery)client.getQuery(GCUBEGHNQuery.class);
            List list = client.execute((ISQuery)query, GCUBEScope.getScope((String)"/gcube/devsec"));
            for (GCUBEHostingNode ri : list) {
                StringWriter sw = new StringWriter();
                ri.store((Writer)sw);
                XMLResource tempResource = PooledConnectionFactory.getFactory().getConnection().createXMLResource(ri.getID(), sw.toString());
                testStoreList.add(tempResource);
            }
            coll.AddElement(testStoreList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

