/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.xml.databases.existlibrary.thread;

import java.util.ArrayList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.common.xml.databases.existlibrary.MOStringHelper;
import org.gcube.common.xml.databases.existlibrary.PooledConnectionFactory;
import org.gcube.common.xml.databases.existlibrary.UpdateEventConsumer;
import org.gcube.common.xml.databases.existlibrary.collections.CollectionImpl;
import org.gcube.common.xml.databases.existlibrary.collections.XMLResource;

public class AddElementRSThread
extends Thread {
    static GCUBELog logger = new GCUBELog(AddElementRSThread.class);
    private String rsLocator;
    private CollectionImpl collection;
    private UpdateEventConsumer consumer;

    public AddElementRSThread(String locator, CollectionImpl coll, UpdateEventConsumer consumer) {
        this.rsLocator = locator;
        this.collection = coll;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        try {
            RSLocator rsl = new RSLocator(this.rsLocator);
            RSXMLReader reader = RSXMLReader.getRSXMLReader((RSLocator)rsl);
            while (true) {
                ArrayList<XMLResource> resourceList = new ArrayList<XMLResource>();
                int partcount = reader.getNumberOfResults();
                for (int i = 0; i < partcount; ++i) {
                    MOStringHelper h = new MOStringHelper(reader.getResults(ResultElementGeneric.class, i).toXML());
                    logger.trace((Object)h.getMetadata());
                    resourceList.add(PooledConnectionFactory.getFactory().getConnection().createXMLResource(h.getID(), h.getMetadata()));
                }
                int notStoredElement = this.collection.store(resourceList).size();
                int totalStored = partcount - notStoredElement;
                this.consumer.onUpdateError(notStoredElement);
                this.consumer.onUpdateCount(totalStored);
                if (reader.isLast()) break;
                reader.getNextPart();
            }
            this.collection.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error storing documents in AddElementRSThread ", (Throwable)e);
        }
    }

    public class Couple {
        private State state;
        private int count;

        public Couple(State state, int count) {
            this.count = count;
            this.state = state;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setState(State state) {
            this.state = state;
        }

        public State getState() {
            return this.state;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static enum State {
        PENDING,
        ERROR,
        FINISHED;

    }
}

