/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.spec.EllipticCurve;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.impl.lang.Converters;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.ECCurve;
import org.gcube.io.jsonwebtoken.io.Encoders;
import org.gcube.io.jsonwebtoken.security.Jwk;
import org.gcube.io.jsonwebtoken.security.UnsupportedKeyException;

abstract class AbstractEcJwkFactory<K extends Key & ECKey, J extends Jwk<K>>
extends AbstractFamilyJwkFactory<K, J> {
    protected static ECCurve getCurveByJwaId(String jwaCurveId) {
        ECCurve curve = ECCurve.findById(jwaCurveId);
        if (curve == null) {
            String msg = "Unrecognized JWA EC curve id '" + jwaCurveId + "'";
            throw new UnsupportedKeyException(msg);
        }
        return curve;
    }

    static String toOctetString(EllipticCurve curve, BigInteger coordinate) {
        byte[] bytes = Converters.BIGINT_UBYTES.applyTo(coordinate);
        int fieldSizeInBits = curve.getField().getFieldSize();
        int mlen = Bytes.length(fieldSizeInBits);
        bytes = Bytes.prepad(bytes, mlen);
        return (String)Encoders.BASE64URL.encode((Object)bytes);
    }

    AbstractEcJwkFactory(Class<K> keyType, Set<Parameter<?>> params) {
        super("EC", keyType, params);
    }
}

