/**
 * 
 */
package org.gcube.common.geoserverinterface;

import java.io.IOException;
import java.util.Properties;

/**
 * @author ceras
 *
 */
public class Constants {	

	private static final String PROPERTIES_FILE_NAME = "geoserverInterface.properties";
	private static boolean isInitialized = false;
	
	private static int connectionTimeOut;
	private static boolean log4jEnabled;

	private static void init() {
		Properties properties = new Properties();
		try {
			properties.load(Constants.class.getResourceAsStream("/"+PROPERTIES_FILE_NAME));
			isInitialized = true;
			
			connectionTimeOut = Integer.parseInt(properties.getProperty("connectionTimeOut", "0"));
			log4jEnabled = Boolean.parseBoolean(properties.getProperty("log4jEnabled", "false"));
			
		} catch(IOException e) {
			e.printStackTrace();
		}
	}
	
	public static int getConnectionTimeOut() {		
		if (!isInitialized)
			init();
		return connectionTimeOut;
	}
	
	public static void main(String args[]) {
		System.out.println("connection time out="+Constants.getConnectionTimeOut());
	}

	/**
	 * @return
	 */
	public static boolean log4jEnabled() {
		if (!isInitialized)
			init();
		return log4jEnabled;
	}

}
