/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.engine;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.Logger;
import org.gcube.common.geoserverinterface.bean.CswLayersResult;
import org.gcube.common.geoserverinterface.bean.CswRecord;
import org.gcube.common.geoserverinterface.bean.LayerCsw;
import org.gcube.common.geoserverinterface.cxml.CXml;
import org.gcube.common.geoserverinterface.cxml.CXmlManager;
import org.gcube.common.geoserverinterface.geonetwork.utils.ParserXpath;

public class GeonetworkGetMethods {
    private HttpMethodCall HMC = null;
    private final String APPLICATIONXML = "application/xml";
    private final String XMLHARVESTINGGET = "xml.harvesting.get";
    private final String XMLMETADATAGET = "xml.metadata.get";
    private final String XMLHARVESTINGRUN = "xml.harvesting.run";
    private final String CSW = "csw";
    private final String XMLSEARCH = "xml.search";
    public static final String GROUP = "Layer-Group";
    private static final int MAX_RECORDS = 100000;

    public GeonetworkGetMethods(HttpMethodCall HMC) {
        this.HMC = HMC;
    }

    public String getListHarvestings() {
        String res = null;
        try {
            res = this.HMC.CallPost("xml.harvesting.get", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><requests/>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getHarvestingById(String id) {
        String res = null;
        try {
            res = this.HMC.CallPost("xml.harvesting.get", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request><id>" + id + "</id></request>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getMetadataByFileIdentifier(String uuid) {
        String res = null;
        try {
            res = this.HMC.CallPost("xml.metadata.get", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request><uuid>" + uuid + "</uuid></request>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getMetadataById(String id) {
        String res = null;
        try {
            res = this.HMC.CallPost("xml.metadata.get", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request><id>" + id + "</id></request>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String updateHarvesting(String id) {
        String res = null;
        try {
            res = this.HMC.CallPost("xml.harvesting.run", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request> <id>" + id + "</id>" + "</request>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String searchLayerByTitleIsLike(String title) {
        String res = null;
        try {
            res = this.HMC.CallPost("csw", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><csw:GetRecords xmlns:csw=\"http://www.opengis.net/cat/csw/2.0.2\" service=\"CSW\" version=\"2.0.2\" resultType=\"results\" outputSchema=\"csw:IsoRecord\"><csw:Query typeNames=\"gmd:MD_Metadata\"><csw:ElementName>/gmd:MD_Metadata/gmd:fileIdentifier</csw:ElementName><csw:ElementName>/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title</csw:ElementName><csw:ElementName>/gmd:MD_Metadata/gmd:distributionInfo//gmd:CI_OnlineResource/gmd:linkage/gmd:URL</csw:ElementName><csw:Constraint version=\"1.1.0\"><Filter xmlns=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\"><PropertyIsLike wildCard=\"%\" singleChar=\"_\" escapeChar=\"\\\"><PropertyName>title</PropertyName><Literal>" + title + "</Literal>" + "</PropertyIsLike>" + "</Filter>" + "</csw:Constraint>" + "</csw:Query>" + "</csw:GetRecords>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String searchLayerByTitleIsEqualTo(String title) {
        String res = null;
        try {
            res = this.HMC.CallPost("csw", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><csw:GetRecords xmlns:csw=\"http://www.opengis.net/cat/csw/2.0.2\" service=\"CSW\" version=\"2.0.2\" resultType=\"results\" outputSchema=\"csw:IsoRecord\"><csw:Query typeNames=\"gmd:MD_Metadata\"><csw:ElementName>/gmd:MD_Metadata/gmd:fileIdentifier</csw:ElementName><csw:ElementName>/gmd:MD_Metadata/gmd:identificationInfo/gmd:MD_DataIdentification/gmd:citation/gmd:CI_Citation/gmd:title</csw:ElementName><csw:ElementName>/gmd:MD_Metadata/gmd:distributionInfo//gmd:CI_OnlineResource/gmd:linkage/gmd:URL</csw:ElementName><csw:Constraint version=\"1.1.0\"><Filter xmlns=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\"><PropertyIsEqualTo><PropertyName>title</PropertyName><Literal>" + title + "</Literal>" + "</PropertyIsEqualTo>" + "</Filter>" + "</csw:Constraint>" + "</csw:Query>" + "</csw:GetRecords>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String searchLayerByAnyText(String anyText, int maxRecords) {
        if (maxRecords < 0) {
            maxRecords = 10;
        }
        String query = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><csw:GetRecords xmlns:csw=\"http://www.opengis.net/cat/csw/2.0.2\" version=\"2.0.2\" service=\"CSW\" resultType=\"results\" ";
        query = maxRecords == 0 ? query + " >" : query + "startPosition=\"1\" maxRecords=\"" + maxRecords + "\">";
        query = query + "<csw:Query xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" typeNames=\"csw:Record\"><csw:ElementSetName>full</csw:ElementSetName><csw:Constraint version=\"1.1.0\"><ogc:Filter><ogc:PropertyIsLike wildCard=\"*\" escape=\"\\\" singleChar=\"?\"><ogc:PropertyName>AnyText</ogc:PropertyName><ogc:Literal>*" + anyText + "*</ogc:Literal>" + "</ogc:PropertyIsLike>" + "</ogc:Filter>" + "</csw:Constraint>" + "</csw:Query>" + "</csw:GetRecords>";
        String res = null;
        try {
            res = this.HMC.CallPost("csw", query, "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String searchMetadataByTitle(String title, int maxRecords) {
        if (maxRecords < 0) {
            maxRecords = 10;
        }
        String query = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><csw:GetRecords xmlns:csw=\"http://www.opengis.net/cat/csw/2.0.2\" version=\"2.0.2\" service=\"CSW\" resultType=\"results\" ";
        query = maxRecords == 0 ? query + " >" : query + "startPosition=\"1\" maxRecords=\"" + maxRecords + "\">";
        query = query + "<csw:Query xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" typeNames=\"csw:Record\"><csw:ElementSetName>full</csw:ElementSetName><csw:Constraint version=\"1.1.0\"><ogc:Filter><ogc:PropertyIsLike wildCard=\"*\" escape=\"\\\" singleChar=\"?\"><ogc:PropertyName>Title</ogc:PropertyName><ogc:Literal>*" + title + "*</ogc:Literal>" + "</ogc:PropertyIsLike>" + "</ogc:Filter>" + "</csw:Constraint>" + "</csw:Query>" + "</csw:GetRecords>";
        String res = null;
        try {
            res = this.HMC.CallPost("csw", query, "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public ArrayList<CswRecord> getCswRecordsBySearch(String anyText, int maxRecords) {
        String xml = this.searchLayerByAnyText(anyText, maxRecords);
        return this.getCswRecordFromXmlResponse(xml);
    }

    public String getGeoserverUrlForName(String groupName, boolean searchgroup) {
        int maxRecords = 0;
        ArrayList<String> uriList = null;
        String xml = this.searchMetadataByTitle(groupName, maxRecords);
        ArrayList<CswRecord> cswRecordsList = this.getCswRecordFromXmlResponse(xml);
        for (CswRecord cswRecord : cswRecordsList) {
            if (searchgroup && cswRecord.getAbstractProperty().contains(GROUP)) {
                uriList = cswRecord.getURI();
                break;
            }
            if (searchgroup) continue;
            uriList = cswRecord.getURI();
            break;
        }
        if (uriList != null) {
            return GeonetworkGetMethods.cleanGeoUrl((String)uriList.get(0));
        }
        return null;
    }

    public static String cleanGeoUrl(String geourl) {
        int interr = geourl.indexOf("?");
        if (interr > 0) {
            geourl = geourl.substring(0, interr);
        }
        if (geourl.endsWith("/wms") || geourl.endsWith("/gwc") || geourl.endsWith("/wfs")) {
            geourl = geourl.substring(0, geourl.length() - 4);
        }
        return geourl;
    }

    public ArrayList<CswRecord> getCswRecordFromXmlResponse(String xml) {
        String tagTitle = "dc:title";
        String tagType = "dc:type";
        String tagSubject = "dc:subject";
        String tagBoundingBox = "ows:BoundingBox";
        String tagURI = "dc:URI";
        String tagAbstract = "dct:abstract";
        String tagCswRecord = "csw:Record";
        String tagIdentifier = "dc:identifier";
        ArrayList<CswRecord> arrayList = new ArrayList<CswRecord>();
        ArrayList<Object> xmlValues = new ArrayList();
        String queryXPath = "//" + tagCswRecord + "/" + tagIdentifier;
        xmlValues = ParserXpath.getTextFromXPathExpression(xml, queryXPath);
        for (String string : xmlValues) {
            CswRecord csw = new CswRecord();
            csw.setIdentifier(string);
            arrayList.add(csw);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            CswRecord cswRecord = arrayList.get(i);
            queryXPath = "//" + tagCswRecord + "[" + tagIdentifier + "/text()[contains(.,'" + cswRecord.getIdentifier() + "')]]/" + tagTitle;
            xmlValues = ParserXpath.getTextFromXPathExpression(xml, queryXPath);
            cswRecord.setTitle((String)xmlValues.get(0));
            queryXPath = "//" + tagCswRecord + "[" + tagIdentifier + "/text()[contains(.,'" + cswRecord.getIdentifier() + "')]]/" + tagType;
            xmlValues = ParserXpath.getTextFromXPathExpression(xml, queryXPath);
            cswRecord.setType((String)xmlValues.get(0));
            queryXPath = "//" + tagCswRecord + "[" + tagIdentifier + "/text()[contains(.,'" + cswRecord.getIdentifier() + "')]]/" + tagAbstract;
            xmlValues = ParserXpath.getTextFromXPathExpression(xml, queryXPath);
            cswRecord.setAbstractProperty((String)xmlValues.get(0));
            queryXPath = "//" + tagCswRecord + "[" + tagIdentifier + "/text()[contains(.,'" + cswRecord.getIdentifier() + "')]]/" + tagURI;
            xmlValues = ParserXpath.getTextFromXPathExpression(xml, queryXPath);
            ArrayList<String> uriList = new ArrayList<String>();
            for (String string : xmlValues) {
                uriList.add(string);
            }
            cswRecord.setURI(uriList);
        }
        return arrayList;
    }

    public List<String> searchID(String title, GeonetworkCommonResourceInterface.GeonetworkCategory category, float similarity) {
        final ArrayList<String> ids = new ArrayList<String>();
        String res = null;
        try {
            String query = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request>";
            if (title != null && !title.isEmpty()) {
                query = query + "<any>" + title + "</any>";
            }
            if (category != null && category != GeonetworkCommonResourceInterface.GeonetworkCategory.ANY) {
                query = query + "<category>" + category.toString().toLowerCase() + "</category>";
            }
            query = query + "<similarity>" + similarity + "</similarity>";
            query = query + "</request>";
            res = this.HMC.CallPost("xml.search", query, "application/xml");
            CXml cxmlResult = new CXml(res);
            cxmlResult.find("geonet:info").each(new CXmlManager(){

                @Override
                public void manage(int i, CXml record) {
                    String id = record.child("id").text();
                    String uuid = record.child("uuid").text();
                    Logger.debug("ID:" + id);
                    Logger.debug("UUID:" + uuid);
                    ids.add(id);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ids;
    }

    public String searchService(String title, GeonetworkCommonResourceInterface.GeonetworkCategory category, Boolean similarity) {
        String res = null;
        try {
            String query = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request>";
            if (title != null && !title.isEmpty()) {
                query = query + "<title>" + title + "</title>";
            }
            if (category != null && category != GeonetworkCommonResourceInterface.GeonetworkCategory.ANY) {
                query = query + "<category>" + category.toString().toLowerCase() + "</category>";
            }
            query = similarity != false ? query + "<similarity>1</similarity>" : query + "<similarity>0.8</similarity>";
            query = query + "</request>";
            res = this.HMC.CallPost("xml.search", query, "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getIdFromXml() {
        return null;
    }

    public CswLayersResult getLayersFromCsw(String referredWorkspace, int startPosition, int maxRecords, boolean sortByTitle, boolean sortAscendent, GeoCaller.FILTER_TYPE filter, String textToSearch) {
        if (maxRecords <= 0) {
            maxRecords = 100000;
        }
        String cswQuery = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><csw:GetRecords xmlns:csw='http://www.opengis.net/cat/csw/2.0.2' service='CSW' version='2.0.2' resultType='results' \toutputSchema='csw:Record' maxRecords='" + maxRecords + "' startPosition='" + startPosition + "'>\n" + "<csw:Query typeNames='csw:Record'>\n" + "\t<csw:ElementName>dc:title</csw:ElementName>\n" + "\t<csw:ElementName>dc:identifier</csw:ElementName>\n" + "\t<csw:ElementName>dc:URI</csw:ElementName>\n" + "\t<csw:Constraint version='1.1.0'>\n" + "\t\t<Filter xmlns='http://www.opengis.net/ogc' xmlns:gml='http://www.opengis.net/gml'>\n" + "\t\t\t<And>\n" + "\t\t\t\t<PropertyIsNotEqualTo>\n" + "\t\t\t\t\t<PropertyName>title</PropertyName>\n" + "\t\t\t\t\t<Literal>GeoServer Web Map Service</Literal>\n" + "\t\t\t\t</PropertyIsNotEqualTo>\n" + "\t\t\t\t<Not>\n" + "\t\t\t\t\t<PropertyIsLike wildCard='*' singleChar='?' escapeChar=''>\n" + "\t\t\t\t\t\t<PropertyName>abstract</PropertyName>\n" + "\t\t\t\t\t\t<Literal>*Group*</Literal>\n" + "\t\t\t\t\t</PropertyIsLike>\n" + "\t\t\t\t</Not>\n";
        if (referredWorkspace != null) {
            cswQuery = cswQuery + "\t\t\t\t<PropertyIsLike wildCard='*' singleChar='?' escapeChar=''>\n\t\t\t\t\t<PropertyName>AnyText</PropertyName>\n\t\t\t\t\t<Literal>" + referredWorkspace + ":*</Literal>\n" + "\t\t\t\t</PropertyIsLike>\n";
        }
        if (filter == GeoCaller.FILTER_TYPE.TITLE || filter == GeoCaller.FILTER_TYPE.ANY_TEXT) {
            cswQuery = cswQuery + "\t\t\t\t<PropertyIsLike wildCard='*' singleChar='?' escapeChar=''>\n\t\t\t\t\t<PropertyName>" + (filter == GeoCaller.FILTER_TYPE.TITLE ? "title" : "AnyText") + "</PropertyName>\n" + "\t\t\t\t\t<Literal>*" + textToSearch + "*</Literal>\n" + "\t\t\t\t</PropertyIsLike>\n";
        }
        cswQuery = cswQuery + "\t\t\t</And>\n\t\t</Filter>\n\t</csw:Constraint>\n";
        if (sortByTitle) {
            cswQuery = cswQuery + "\t<ogc:SortBy xmlns:ogc='http://www.opengis.net/ogc'>\n\t\t<ogc:SortProperty>\n\t\t\t<ogc:PropertyName>title</ogc:PropertyName>\n\t\t\t<ogc:SortOrder>" + (sortAscendent ? "ASC" : "DESC") + "</ogc:SortOrder>\n" + "\t\t</ogc:SortProperty>\n" + "\t</ogc:SortBy>\n";
        }
        cswQuery = cswQuery + "</csw:Query>\n</csw:GetRecords>";
        final CswLayersResult result = new CswLayersResult();
        try {
            String res = this.HMC.CallPost("csw", cswQuery, "application/xml");
            CXml cxmlResult = new CXml(res);
            String nTot = cxmlResult.find("csw:SearchResults").attr("numberOfRecordsMatched");
            result.setResultLayersCount(Integer.parseInt(nTot));
            cxmlResult.find("csw:Record").each(new CXmlManager(){

                @Override
                public void manage(int i, CXml record) {
                    String id = record.child("dc:identifier").text();
                    String title = record.child("dc:title").text();
                    String name = record.child("dc:URI").attr("name");
                    String description = record.child("dc:URI").attr("description");
                    String geoserverUrl = record.child("dc:URI").text();
                    if (id != null && title != null && name != null && geoserverUrl != null) {
                        result.addLayer(new LayerCsw(id, name, title, description, geoserverUrl));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

