/**
 * 
 */
package org.gcube.common.geoserverinterface;

/**
 * @author ceras
 *
 */
public class Logger {

	private static org.apache.log4j.Logger logger;
			
	public static void setLogger(org.apache.log4j.Logger _logger) {
		logger = _logger;
	}
	
	private static void init() {
		if (logger==null && Constants.log4jEnabled())
			logger = org.apache.log4j.Logger.getLogger(Logger.class);
	}
	
	public static void debug(String message) {
		init();
		if (logger==null)
			System.out.println("-[DEBUG] "+message);
		else
			logger.debug(message);
	};	

	public static void error(String message) {
		init();
		if (logger==null)
			System.out.println("-[ERROR] "+message);
		else
			logger.error(message);
	}
	
	public static void info(String message) {
		init();
		if (logger==null)
			System.out.println("-[INFO] "+message);
		else
			logger.info(message);
	}
	
	public static void trace(String message) {
		init();
		if (logger==null)
			System.out.println("-[TRACE] "+message);
		else
			logger.trace(message);
	};	
	
}
