/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.test;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.bean.CswLayersResult;
import org.gcube.common.geoserverinterface.bean.LayerCsw;
import org.gcube.common.geoserverinterface.cxml.CXml;
import org.gcube.common.geoserverinterface.cxml.CXmlManager;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestCsw {
    private static final String geonetworkUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork";
    private static final String gnUser = "admin";
    private static final String gnPwd = "admin";
    private static final int MAX_RECORDS = 100000;
    private static int SELECTOR = 1;

    public static void main(String[] args) {
        if (SELECTOR == 1) {
            TestCsw.testNew();
        } else {
            long startTime = new Date().getTime();
            try {
                MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                HttpMethodCall HMC = new HttpMethodCall(connectionManager, "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork/srv/en", "", "");
                TestCsw.login(HMC);
                int maxRecords = 10;
                int startPosition = 1;
                boolean sortByTitle = true;
                boolean sortAscendent = true;
                FILTER_TYPE filter = FILTER_TYPE.TITLE;
                String textToSearch = "eezall";
                if (maxRecords == 0) {
                    maxRecords = 100000;
                }
                String cswQuery = "<csw:GetRecords xmlns:csw='http://www.opengis.net/cat/csw/2.0.2' service='CSW' version='2.0.2' resultType='results' \toutputSchema='csw:Record' maxRecords='" + maxRecords + "' startPosition='" + startPosition + "'>\n" + "<csw:Query typeNames='csw:Record'>\n" + "\t<csw:ElementName>dc:title</csw:ElementName>\n" + "\t<csw:ElementName>dc:identifier</csw:ElementName>\n" + "\t<csw:ElementName>dc:URI</csw:ElementName>\n" + "\t<csw:Constraint version='1.1.0'>\n" + "\t\t<Filter xmlns='http://www.opengis.net/ogc' xmlns:gml='http://www.opengis.net/gml'>\n" + "\t\t\t<And>\n" + "\t\t\t\t<PropertyIsNotEqualTo>\n" + "\t\t\t\t\t<PropertyName>title</PropertyName>\n" + "\t\t\t\t\t<Literal>GeoServer Web Map Service</Literal>\n" + "\t\t\t\t</PropertyIsNotEqualTo>\n" + "\t\t\t\t<Not>\n" + "\t\t\t\t\t<PropertyIsLike wildCard='*' singleChar='?' escapeChar=''>\n" + "\t\t\t\t\t\t<PropertyName>abstract</PropertyName>\n" + "\t\t\t\t\t\t<Literal>*Group*</Literal>\n" + "\t\t\t\t\t</PropertyIsLike>\n" + "\t\t\t\t</Not>\n";
                if (filter == FILTER_TYPE.TITLE || filter == FILTER_TYPE.ANY_TEXT) {
                    cswQuery = cswQuery + "\t\t\t\t<PropertyIsLike wildCard='*' singleChar='?' escapeChar=''>\n\t\t\t\t\t<PropertyName>" + (filter == FILTER_TYPE.TITLE ? "title" : "AnyText") + "</PropertyName>\n" + "\t\t\t\t\t<Literal>%" + textToSearch + "%</Literal>\n" + "\t\t\t\t</PropertyIsLike>\n";
                }
                cswQuery = cswQuery + "\t\t\t</And>\n\t\t</Filter>\n\t</csw:Constraint>\n";
                if (sortByTitle) {
                    cswQuery = cswQuery + "\t<ogc:SortBy xmlns:ogc='http://www.opengis.net/ogc'>\n\t\t<ogc:SortProperty>\n\t\t\t<ogc:PropertyName>title</ogc:PropertyName>\n\t\t\t<ogc:SortOrder>" + (sortAscendent ? "ASC" : "DESC") + "</ogc:SortOrder>\n" + "\t\t</ogc:SortProperty>\n" + "\t</ogc:SortBy>\n";
                }
                cswQuery = cswQuery + "</csw:Query>\n</csw:GetRecords>";
                String res = TestCsw.call(HMC, "csw", cswQuery);
                TestCsw.out(res);
                CXml result = new CXml(res);
                int nTot = Integer.parseInt(result.find("csw:SearchResults").attr("numberOfRecordsReturned"));
                result.find("csw:Record").each(new CXmlManager(){

                    @Override
                    public void manage(int i, CXml record) {
                        String id = record.child("dc:identifier").text();
                        String title = record.child("dc:title").text();
                        String name = record.child("dc:URI").attr("name");
                        String geoserverUrl = record.child("dc:URI").text();
                        System.out.println(i + ") " + id + "\t" + title + "\t" + name + "\t" + geoserverUrl);
                    }
                });
                System.out.println("OK");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("general error");
            }
            long endTime = new Date().getTime();
            System.out.println("Tempo trascorso :" + (endTime - startTime) / 1000L);
        }
    }

    private static List<String> parseUuids(String res) {
        ArrayList<String> uuids = new ArrayList<String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(res));
            Document doc = db.parse(is);
            NodeList nodes = doc.getElementsByTagName("uuid");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element uuid = (Element)nodes.item(i);
                uuids.add(TestCsw.getCharacterDataFromElement(uuid));
            }
            return uuids;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    private static String call(HttpMethodCall HMC, String req, String xml) {
        try {
            return HMC.CallPost(req, "<?xml version='1.0' encoding='UTF-8'?>" + xml, "text/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void login(HttpMethodCall HMC) throws Exception {
        HMC.CallPost("xml.user.login", "<?xml version='1.0' encoding=\"UTF-8\"?><request>\t\t<username>admin</username>\t\t<password>admin</password></request>", "text/xml");
    }

    private static void out(String res) {
        System.out.println("---------------------------------------\n" + res + "\n--------------------------------------");
    }

    private void asd() throws Exception {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpMethodCall HMC = new HttpMethodCall(connectionManager, "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork/srv/en", "", "");
        TestCsw.login(HMC);
    }

    private static void testNew() {
        String res = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><csw:GetRecordsResponse xmlns:csw='http://www.opengis.net/cat/csw/2.0.2' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.opengis.net/cat/csw/2.0.2 http://schemas.opengis.net/csw/2.0.2/CSW-discovery.xsd'><csw:SearchStatus timestamp='2012-06-21T00:54:06' /><csw:SearchResults numberOfRecordsMatched='6591' numberOfRecordsReturned='6591' elementSet='full' nextRecord='0'>";
        for (int i = 0; i < 2000; ++i) {
            res = res + "<csw:Record xmlns:dct='http://purl.org/dc/terms/' xmlns:ows='http://www.opengis.net/ows' xmlns:geonet='http://www.fao.org/geonetwork' xmlns:dc='http://purl.org/dc/elements/1.1/'><dc:identifier>ba83f74e-44c9-43a2-b0b7-160f523f80d0</dc:identifier><dc:title>TrueMarble.16km.2700x1350</dc:title><dc:URI protocol='OGC:WMS-1.1.1-http-get-map' name='aquamaps:TrueMarble.16km.2700x1350' description='TrueMarble.16km.2700x1350'>http://geoserver2.d4science.research-infrastructures.eu:80/geoserver/wms?SERVICE=WMS&amp;</dc:URI></csw:Record><csw:Record xmlns:dct='http://purl.org/dc/terms/' xmlns:ows='http://www.opengis.net/ows' xmlns:geonet='http://www.fao.org/geonetwork' xmlns:dc='http://purl.org/dc/elements/1.1/'><dc:identifier>97b11ada-2f57-4161-a4ce-7ebfcfc24bf0</dc:identifier><dc:title>biodiversity</dc:title><dc:URI protocol='OGC:WMS-1.1.1-http-get-map' name='aquamaps:biodiversity' description='biodiversity'>http://geoserver2.d4science.research-infrastructures.eu:80/geoserver/wms?SERVICE=WMS&amp;</dc:URI></csw:Record><csw:Record xmlns:dct='http://purl.org/dc/terms/' xmlns:ows='http://www.opengis.net/ows' xmlns:geonet='http://www.fao.org/geonetwork' xmlns:dc='http://purl.org/dc/elements/1.1/'><dc:identifier>18641c17-0e4c-4cfe-84d0-37ad4b392784</dc:identifier><dc:title>DepthMean</dc:title><dc:URI protocol='OGC:WMS-1.1.1-http-get-map' name='aquamaps:depthMean' description='DepthMean'>http://geoserver2.d4science.research-infrastructures.eu:80/geoserver/wms?SERVICE=WMS&amp;</dc:URI></csw:Record><csw:Record xmlns:dct='http://purl.org/dc/terms/' xmlns:ows='http://www.opengis.net/ows' xmlns:geonet='http://www.fao.org/geonetwork' xmlns:dc='http://purl.org/dc/elements/1.1/'><dc:identifier>ac7393df-7213-41ca-a7d1-6389e001f7d4</dc:identifier><dc:title>depthmean_annual</dc:title><dc:URI protocol='OGC:WMS-1.1.1-http-get-map' name='aquamaps:depthmean_annual' description='depthmean_annual'>http://geoserver2.d4science.research-infrastructures.eu:80/geoserver/wms?SERVICE=WMS&amp;</dc:URI></csw:Record><csw:Record xmlns:dct='http://purl.org/dc/terms/' xmlns:ows='http://www.opengis.net/ows' xmlns:geonet='http://www.fao.org/geonetwork' xmlns:dc='http://purl.org/dc/elements/1.1/'><dc:identifier>12409123-348b-4c81-a9c4-b711d14e0fd5</dc:identifier><dc:title>depthmean_annual</dc:title><dc:URI protocol='OGC:WMS-1.1.1-http-get-map' name='aquamaps:depthmean_annual' description='depthmean_annual'>http://geoserver3.d4science.research-infrastructures.eu:80/geoserver/wms?SERVICE=WMS&amp;</dc:URI></csw:Record>";
        }
        res = res + "</csw:SearchResults></csw:GetRecordsResponse>";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            final CswLayersResult result = new CswLayersResult();
            DefaultHandler handler = new DefaultHandler(){
                State state = State.START;
                LayerCsw currentLayer;
                StringBuffer buffer;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    switch (this.state) {
                        case START: {
                            if (!qName.equalsIgnoreCase("csw:GetRecordsResponse")) break;
                            this.state = State.INSIDE_GET_RECORDS_RESPONSE;
                            break;
                        }
                        case INSIDE_GET_RECORDS_RESPONSE: {
                            if (!qName.equalsIgnoreCase("csw:SearchResults")) break;
                            this.state = State.INSIDE_SEARCH_RESULTS;
                            result.setResultLayersCount(Integer.parseInt(attributes.getValue("numberOfRecordsMatched")));
                            break;
                        }
                        case INSIDE_SEARCH_RESULTS: {
                            if (!qName.equalsIgnoreCase("csw:Record")) break;
                            this.state = State.INSIDE_RECORD;
                            this.currentLayer = new LayerCsw();
                            break;
                        }
                        case INSIDE_RECORD: {
                            if (qName.equalsIgnoreCase("dc:identifier")) {
                                this.state = State.INSIDE_IDENTIFIER;
                                this.buffer = new StringBuffer();
                                break;
                            }
                            if (qName.equalsIgnoreCase("dc:title")) {
                                this.state = State.INSIDE_TITLE;
                                this.buffer = new StringBuffer();
                                break;
                            }
                            if (!qName.equalsIgnoreCase("dc:URI")) break;
                            this.state = State.INSIDE_URI;
                            this.currentLayer.setName(attributes.getValue("name"));
                            this.buffer = new StringBuffer();
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equalsIgnoreCase("dc:identifier")) {
                        this.currentLayer.setUuid(this.buffer.toString());
                        this.state = State.INSIDE_RECORD;
                    } else if (qName.equalsIgnoreCase("dc:title")) {
                        this.currentLayer.setTitle(this.buffer.toString());
                        this.state = State.INSIDE_RECORD;
                    } else if (qName.equalsIgnoreCase("dc:URI")) {
                        this.currentLayer.setGeoserverUrl(this.buffer.toString());
                        this.state = State.INSIDE_RECORD;
                    } else if (qName.equalsIgnoreCase("csw:Record")) {
                        this.state = State.INSIDE_SEARCH_RESULTS;
                        result.addLayer(this.currentLayer);
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.state == State.INSIDE_IDENTIFIER || this.state == State.INSIDE_TITLE || this.state == State.INSIDE_URI) {
                        this.buffer.append(new String(ch, start, length));
                    }
                }
            };
            long start1 = new Date().getTime();
            saxParser.parse(new InputSource(new StringReader(res)), handler);
            long end1 = new Date().getTime();
            long start2 = new Date().getTime();
            CXml cxmlResult = new CXml(res);
            String nTot = cxmlResult.find("csw:SearchResults").attr("numberOfRecordsMatched");
            result.setResultLayersCount(Integer.parseInt(nTot));
            cxmlResult.find("csw:Record").each(new CXmlManager(){

                @Override
                public void manage(int i, CXml record) {
                    String id = record.child("dc:identifier").text();
                    String title = record.child("dc:title").text();
                    String name = record.child("dc:URI").attr("name");
                    String geoserverUrl = record.child("dc:URI").text();
                    if (id != null && title != null && name != null && geoserverUrl != null) {
                        result.addLayer(new LayerCsw(id, name, title, null, geoserverUrl));
                    }
                }
            });
            long end2 = new Date().getTime();
            System.out.println("1(" + start1 + "," + end1 + "); 2(" + start2 + "," + end2 + ")");
            System.out.println("SAX TIME: " + (end1 - start1) + "seconds");
            System.out.println("DOM TIME: " + (end2 - start2) + "seconds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static enum State {
        START,
        INSIDE_GET_RECORDS_RESPONSE,
        INSIDE_SEARCH_RESULTS,
        INSIDE_RECORD,
        INSIDE_IDENTIFIER,
        INSIDE_TITLE,
        INSIDE_URI;

    }

    private static enum FILTER_TYPE {
        NO_FILTER,
        TITLE,
        ANY_TEXT;

    }
}

